/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.util;

import com.azure.core.implementation.ImplUtils;
import com.azure.core.implementation.util.BinaryDataContent;
import com.azure.core.implementation.util.BinaryDataContentType;
import com.azure.core.util.FluxUtil;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.serializer.ObjectSerializer;
import com.azure.core.util.serializer.TypeReference;
import com.azure.json.JsonWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.AsynchronousByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class SerializableContent
extends BinaryDataContent {
    private static final ClientLogger LOGGER = new ClientLogger(SerializableContent.class);
    private final Object content;
    private final ObjectSerializer serializer;
    private volatile byte[] bytes;
    private static final AtomicReferenceFieldUpdater<SerializableContent, byte[]> BYTES_UPDATER = AtomicReferenceFieldUpdater.newUpdater(SerializableContent.class, byte[].class, "bytes");

    public SerializableContent(Object content, ObjectSerializer serializer) {
        this.content = content;
        this.serializer = Objects.requireNonNull(serializer, "'serializer' cannot be null.");
    }

    @Override
    public Long getLength() {
        return this.content == null ? null : Long.valueOf(this.toBytes().length);
    }

    @Override
    public String toString() {
        return new String(this.toBytes(), StandardCharsets.UTF_8);
    }

    @Override
    public byte[] toBytes() {
        return BYTES_UPDATER.updateAndGet(this, bytes -> bytes == null ? this.getBytes() : bytes);
    }

    @Override
    public <T> T toObject(TypeReference<T> typeReference, ObjectSerializer serializer) {
        return serializer.deserializeFromBytes(this.toBytes(), typeReference);
    }

    @Override
    public InputStream toStream() {
        return new ByteArrayInputStream(this.getBytes());
    }

    @Override
    public ByteBuffer toByteBuffer() {
        return ByteBuffer.wrap(this.toBytes()).asReadOnlyBuffer();
    }

    @Override
    public Flux<ByteBuffer> toFluxByteBuffer() {
        return Mono.fromSupplier(() -> ByteBuffer.wrap(this.toBytes())).flux();
    }

    @Override
    public void writeTo(OutputStream outputStream) throws IOException {
        Objects.requireNonNull(outputStream, "'outputStream' cannot be null");
        outputStream.write(this.toBytes());
    }

    @Override
    public void writeTo(WritableByteChannel channel) throws IOException {
        Objects.requireNonNull(channel, "'channel' cannot be null");
        ImplUtils.fullyWriteBuffer(this.toByteBuffer(), channel);
    }

    @Override
    public Mono<Void> writeTo(AsynchronousByteChannel channel) {
        if (channel == null) {
            return FluxUtil.monoError(LOGGER, (RuntimeException)new NullPointerException("'channel' cannot be null"));
        }
        return FluxUtil.writeToAsynchronousByteChannel(this.toFluxByteBuffer(), channel);
    }

    @Override
    public void writeTo(JsonWriter jsonWriter) throws IOException {
        Objects.requireNonNull(jsonWriter, "'jsonWriter' cannot be null");
        if (this.content == null) {
            jsonWriter.writeNull();
        } else {
            jsonWriter.writeRawValue(this.toString());
        }
    }

    @Override
    public boolean isReplayable() {
        return true;
    }

    @Override
    public BinaryDataContent toReplayableContent() {
        return this;
    }

    @Override
    public Mono<BinaryDataContent> toReplayableContentAsync() {
        return Mono.just(this);
    }

    @Override
    public BinaryDataContentType getContentType() {
        return BinaryDataContentType.OBJECT;
    }

    private byte[] getBytes() {
        return this.serializer.serializeToBytes(this.content);
    }
}

