/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.implementation.util;

import com.azure.core.http.HttpHeaderName;
import com.azure.core.http.HttpHeaders;
import com.azure.core.http.RequestConditions;
import com.azure.core.http.rest.Response;
import com.azure.core.http.rest.SimpleResponse;
import com.azure.core.util.CoreUtils;
import com.azure.core.util.logging.ClientLogger;
import com.azure.core.util.polling.LongRunningOperationStatus;
import com.azure.storage.blob.implementation.accesshelpers.BlobDownloadHeadersConstructorProxy;
import com.azure.storage.blob.implementation.accesshelpers.BlobItemConstructorProxy;
import com.azure.storage.blob.implementation.accesshelpers.BlobPropertiesConstructorProxy;
import com.azure.storage.blob.implementation.accesshelpers.BlobQueryHeadersConstructorProxy;
import com.azure.storage.blob.implementation.models.BlobItemInternal;
import com.azure.storage.blob.implementation.models.BlobName;
import com.azure.storage.blob.implementation.models.BlobPropertiesInternalDownload;
import com.azure.storage.blob.implementation.models.BlobStorageExceptionInternal;
import com.azure.storage.blob.implementation.models.BlobTag;
import com.azure.storage.blob.implementation.models.BlobTags;
import com.azure.storage.blob.implementation.models.BlobsDownloadHeaders;
import com.azure.storage.blob.implementation.models.BlobsQueryHeaders;
import com.azure.storage.blob.implementation.models.FilterBlobItem;
import com.azure.storage.blob.implementation.util.BlobRequestConditionProperty;
import com.azure.storage.blob.implementation.util.ChunkedDownloadUtils;
import com.azure.storage.blob.models.BlobBeginCopySourceRequestConditions;
import com.azure.storage.blob.models.BlobContainerListDetails;
import com.azure.storage.blob.models.BlobCorsRule;
import com.azure.storage.blob.models.BlobDownloadAsyncResponse;
import com.azure.storage.blob.models.BlobDownloadHeaders;
import com.azure.storage.blob.models.BlobDownloadResponse;
import com.azure.storage.blob.models.BlobItem;
import com.azure.storage.blob.models.BlobLeaseRequestConditions;
import com.azure.storage.blob.models.BlobProperties;
import com.azure.storage.blob.models.BlobQueryHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import com.azure.storage.blob.models.BlobRetentionPolicy;
import com.azure.storage.blob.models.BlobSignedIdentifier;
import com.azure.storage.blob.models.BlobStorageException;
import com.azure.storage.blob.models.CopyStatusType;
import com.azure.storage.blob.models.ListBlobContainersIncludeType;
import com.azure.storage.blob.models.ObjectReplicationPolicy;
import com.azure.storage.blob.models.ObjectReplicationRule;
import com.azure.storage.blob.models.ObjectReplicationStatus;
import com.azure.storage.blob.models.PageBlobCopyIncrementalRequestConditions;
import com.azure.storage.blob.models.PageRange;
import com.azure.storage.blob.models.ParallelTransferOptions;
import com.azure.storage.blob.models.TaggedBlobItem;
import com.azure.storage.common.Utility;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class ModelHelper {
    private static final ClientLogger LOGGER = new ClientLogger(ModelHelper.class);
    public static final long BLOB_DEFAULT_MAX_SINGLE_UPLOAD_SIZE = 0x10000000L;
    private static final HttpHeaderName X_MS_ERROR_CODE = HttpHeaderName.fromString("x-ms-error-code");
    public static final int PAGE_BYTES = 512;

    public static boolean determineAuthorityIsIpStyle(String authority) throws MalformedURLException {
        return new URL("http://" + authority).getPort() != -1;
    }

    public static ParallelTransferOptions populateAndApplyDefaults(ParallelTransferOptions other) {
        Long maxSingleUploadSize;
        Integer maxConcurrency;
        Long blockSize = (other = other == null ? new ParallelTransferOptions() : other).getBlockSizeLong();
        if (blockSize == null) {
            blockSize = 0x400000L;
        }
        if ((maxConcurrency = other.getMaxConcurrency()) == null) {
            maxConcurrency = 8;
        }
        if ((maxSingleUploadSize = other.getMaxSingleUploadSizeLong()) == null) {
            maxSingleUploadSize = 0x10000000L;
        }
        return new ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressListener(other.getProgressListener()).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static com.azure.storage.common.ParallelTransferOptions populateAndApplyDefaults(com.azure.storage.common.ParallelTransferOptions other) {
        Long maxSingleUploadSize;
        Integer maxConcurrency;
        Long blockSize = (other = other == null ? new com.azure.storage.common.ParallelTransferOptions() : other).getBlockSizeLong();
        if (blockSize == null) {
            blockSize = 0x400000L;
        }
        if ((maxConcurrency = other.getMaxConcurrency()) == null) {
            maxConcurrency = 8;
        }
        if ((maxSingleUploadSize = other.getMaxSingleUploadSizeLong()) == null) {
            maxSingleUploadSize = 0x10000000L;
        }
        return new com.azure.storage.common.ParallelTransferOptions().setBlockSizeLong(blockSize).setMaxConcurrency(maxConcurrency).setProgressListener(other.getProgressListener()).setMaxSingleUploadSizeLong(maxSingleUploadSize);
    }

    public static com.azure.storage.common.ParallelTransferOptions wrapBlobOptions(ParallelTransferOptions blobOptions) {
        return new com.azure.storage.common.ParallelTransferOptions().setBlockSizeLong(blobOptions.getBlockSizeLong()).setMaxConcurrency(blobOptions.getMaxConcurrency()).setProgressListener(blobOptions.getProgressListener()).setMaxSingleUploadSizeLong(blobOptions.getMaxSingleUploadSizeLong());
    }

    public static BlobDownloadHeaders populateBlobDownloadHeaders(BlobsDownloadHeaders internalHeaders, String errorCode) {
        return BlobDownloadHeadersConstructorProxy.create(internalHeaders).setErrorCode(errorCode);
    }

    public static BlobItem populateBlobItem(BlobItemInternal blobItemInternal) {
        return BlobItemConstructorProxy.create(blobItemInternal);
    }

    public static String toBlobNameString(BlobName blobName) {
        return blobName.isEncoded() != null && blobName.isEncoded() != false ? Utility.urlDecode(blobName.getContent()) : blobName.getContent();
    }

    public static TaggedBlobItem populateTaggedBlobItem(FilterBlobItem filterBlobItem) {
        return new TaggedBlobItem(filterBlobItem.getContainerName(), filterBlobItem.getName(), ModelHelper.tagMapFromBlobTags(filterBlobItem.getTags()));
    }

    public static Map<String, String> tagMapFromBlobTags(BlobTags blobTags) {
        if (blobTags == null || CoreUtils.isNullOrEmpty(blobTags.getBlobTagSet())) {
            return Collections.emptyMap();
        }
        HashMap<String, String> tags = new HashMap<String, String>((int)((float)blobTags.getBlobTagSet().size() / 0.75f));
        for (BlobTag tag : blobTags.getBlobTagSet()) {
            tags.put(tag.getKey(), tag.getValue());
        }
        return tags;
    }

    public static BlobTags toBlobTags(Map<String, String> tags) {
        if (tags == null) {
            return null;
        }
        if (tags.isEmpty()) {
            return new BlobTags().setBlobTagSet(new ArrayList<BlobTag>());
        }
        ArrayList<BlobTag> blobTagSet = new ArrayList<BlobTag>(tags.size());
        tags.forEach((key, value) -> blobTagSet.add(new BlobTag().setKey((String)key).setValue((String)value)));
        return new BlobTags().setBlobTagSet(blobTagSet);
    }

    public static List<ObjectReplicationPolicy> transformObjectReplicationMetadata(Map<String, String> objectReplicationMetadata) {
        if (CoreUtils.isNullOrEmpty(objectReplicationMetadata)) {
            return null;
        }
        HashMap internalSourcePolicies = new HashMap();
        for (Map.Entry<String, String> entry : objectReplicationMetadata.entrySet()) {
            String orString = entry.getKey();
            int startIndex = orString.startsWith("or-") ? 3 : 0;
            int index = orString.indexOf(95, startIndex);
            String policyId = orString.substring(startIndex, index);
            String ruleId = orString.substring(index + 1);
            ObjectReplicationRule rule = new ObjectReplicationRule(ruleId, ObjectReplicationStatus.fromString(entry.getValue()));
            if (!internalSourcePolicies.containsKey(policyId)) {
                internalSourcePolicies.put(policyId, new ArrayList());
            }
            ((List)internalSourcePolicies.get(policyId)).add(rule);
        }
        ArrayList<ObjectReplicationPolicy> objectReplicationSourcePolicies = new ArrayList<ObjectReplicationPolicy>(internalSourcePolicies.size());
        for (Map.Entry entry : internalSourcePolicies.entrySet()) {
            objectReplicationSourcePolicies.add(new ObjectReplicationPolicy((String)entry.getKey(), (List)entry.getValue()));
        }
        return objectReplicationSourcePolicies;
    }

    public static Map<String, String> toObjectReplicationMetadata(List<ObjectReplicationPolicy> policies) {
        if (policies == null) {
            return null;
        }
        if (policies.isEmpty()) {
            return new HashMap<String, String>();
        }
        HashMap<String, String> objectReplicationMetadata = new HashMap<String, String>((int)((float)policies.size() / 0.75f));
        policies.forEach(policy -> {
            for (ObjectReplicationRule rule : policy.getRules()) {
                String key = "or-" + policy.getPolicyId() + "_" + rule.getRuleId();
                objectReplicationMetadata.put(key, rule.getStatus().toString());
            }
        });
        return objectReplicationMetadata;
    }

    public static BlobLeaseRequestConditions populateBlobLeaseRequestConditions(RequestConditions requestConditions) {
        if (requestConditions == null) {
            return null;
        }
        return new BlobLeaseRequestConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince()).setTagsConditions(null);
    }

    public static BlobBeginCopySourceRequestConditions populateBlobSourceRequestConditions(RequestConditions requestConditions) {
        if (requestConditions == null) {
            return null;
        }
        return new BlobBeginCopySourceRequestConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince()).setTagsConditions(null);
    }

    public static PageBlobCopyIncrementalRequestConditions populateBlobDestinationRequestConditions(RequestConditions requestConditions) {
        if (requestConditions == null) {
            return null;
        }
        return new PageBlobCopyIncrementalRequestConditions().setIfMatch(requestConditions.getIfMatch()).setIfNoneMatch(requestConditions.getIfNoneMatch()).setIfModifiedSince(requestConditions.getIfModifiedSince()).setIfUnmodifiedSince(requestConditions.getIfUnmodifiedSince()).setTagsConditions(null);
    }

    public static String getObjectReplicationDestinationPolicyId(Map<String, String> objectReplicationStatus) {
        if (CoreUtils.isNullOrEmpty(objectReplicationStatus)) {
            return null;
        }
        return objectReplicationStatus.get("policy-id");
    }

    public static List<ObjectReplicationPolicy> getObjectReplicationSourcePolicies(Map<String, String> objectReplicationStatus) {
        if (CoreUtils.isNullOrEmpty(objectReplicationStatus)) {
            return new ArrayList<ObjectReplicationPolicy>();
        }
        HashMap internalSourcePolicies = new HashMap();
        if (ModelHelper.getObjectReplicationDestinationPolicyId(objectReplicationStatus) == null) {
            for (Map.Entry<String, String> entry : objectReplicationStatus.entrySet()) {
                String key = entry.getKey();
                int index = key.indexOf(95);
                String policyId = key.substring(0, index);
                String ruleId = key.substring(index + 1);
                ObjectReplicationRule rule = new ObjectReplicationRule(ruleId, ObjectReplicationStatus.fromString(entry.getValue()));
                if (!internalSourcePolicies.containsKey(policyId)) {
                    internalSourcePolicies.put(policyId, new ArrayList());
                }
                ((List)internalSourcePolicies.get(policyId)).add(rule);
            }
        }
        ArrayList<ObjectReplicationPolicy> objectReplicationSourcePolicies = new ArrayList<ObjectReplicationPolicy>(internalSourcePolicies.size());
        for (Map.Entry entry : internalSourcePolicies.entrySet()) {
            objectReplicationSourcePolicies.add(new ObjectReplicationPolicy((String)entry.getKey(), (List)entry.getValue()));
        }
        return objectReplicationSourcePolicies;
    }

    public static String getErrorCode(HttpHeaders headers) {
        return ModelHelper.getHeaderValue(headers, X_MS_ERROR_CODE);
    }

    public static String getETag(HttpHeaders headers) {
        return ModelHelper.getHeaderValue(headers, HttpHeaderName.ETAG);
    }

    private static String getHeaderValue(HttpHeaders headers, HttpHeaderName headerName) {
        if (headers == null) {
            return null;
        }
        return headers.getValue(headerName);
    }

    public static BlobsDownloadHeaders transformBlobDownloadHeaders(HttpHeaders headers) {
        return new BlobsDownloadHeaders(headers);
    }

    public static BlobQueryHeaders transformQueryHeaders(BlobsQueryHeaders headers, HttpHeaders rawHeaders) {
        return BlobQueryHeadersConstructorProxy.create(headers).setErrorCode(ModelHelper.getErrorCode(rawHeaders));
    }

    public static void validateConditionsNotPresent(BlobRequestConditions requestConditions, EnumSet<BlobRequestConditionProperty> invalidConditions, String operationName, String parameterName) {
        if (requestConditions == null) {
            return;
        }
        List invalidConditionsFound = null;
        for (BlobRequestConditionProperty condition : invalidConditions) {
            switch (condition) {
                case LEASE_ID: {
                    if (requestConditions.getLeaseId() == null) break;
                    invalidConditionsFound = invalidConditionsFound == null ? new ArrayList() : invalidConditionsFound;
                    invalidConditionsFound.add(BlobRequestConditionProperty.LEASE_ID.toString());
                    break;
                }
                case TAGS_CONDITIONS: {
                    if (requestConditions.getTagsConditions() == null) break;
                    invalidConditionsFound = invalidConditionsFound == null ? new ArrayList() : invalidConditionsFound;
                    invalidConditionsFound.add(BlobRequestConditionProperty.TAGS_CONDITIONS.toString());
                    break;
                }
                case IF_MODIFIED_SINCE: {
                    if (requestConditions.getIfModifiedSince() == null) break;
                    invalidConditionsFound = invalidConditionsFound == null ? new ArrayList() : invalidConditionsFound;
                    invalidConditionsFound.add(BlobRequestConditionProperty.IF_MODIFIED_SINCE.toString());
                    break;
                }
                case IF_UNMODIFIED_SINCE: {
                    if (requestConditions.getIfUnmodifiedSince() == null) break;
                    invalidConditionsFound = invalidConditionsFound == null ? new ArrayList() : invalidConditionsFound;
                    invalidConditionsFound.add(BlobRequestConditionProperty.IF_UNMODIFIED_SINCE.toString());
                    break;
                }
                case IF_MATCH: {
                    if (requestConditions.getIfMatch() == null) break;
                    invalidConditionsFound = invalidConditionsFound == null ? new ArrayList() : invalidConditionsFound;
                    invalidConditionsFound.add(BlobRequestConditionProperty.IF_MATCH.toString());
                    break;
                }
                case IF_NONE_MATCH: {
                    if (requestConditions.getIfNoneMatch() == null) break;
                    invalidConditionsFound = invalidConditionsFound == null ? new ArrayList() : invalidConditionsFound;
                    invalidConditionsFound.add(BlobRequestConditionProperty.IF_NONE_MATCH.toString());
                    break;
                }
            }
        }
        if (invalidConditionsFound != null && !invalidConditionsFound.isEmpty()) {
            String unsupported = String.join((CharSequence)", ", invalidConditionsFound);
            throw LOGGER.logExceptionAsError(new IllegalArgumentException(String.format("%s does not support the %s request condition(s) for parameter '%s'.", operationName, unsupported, parameterName)));
        }
    }

    public static Response<BlobProperties> buildBlobPropertiesResponse(BlobDownloadAsyncResponse response) {
        return new SimpleResponse<BlobProperties>(response.getRequest(), response.getStatusCode(), response.getHeaders(), BlobPropertiesConstructorProxy.create(new BlobPropertiesInternalDownload((BlobDownloadHeaders)response.getDeserializedHeaders())));
    }

    public static Response<BlobProperties> buildBlobPropertiesResponse(BlobDownloadResponse response) {
        return new SimpleResponse<BlobProperties>(response.getRequest(), response.getStatusCode(), response.getHeaders(), BlobPropertiesConstructorProxy.create(new BlobPropertiesInternalDownload((BlobDownloadHeaders)response.getDeserializedHeaders())));
    }

    public static long getBlobLength(BlobDownloadHeaders headers) {
        return headers.getContentRange() == null ? headers.getContentLength() : ChunkedDownloadUtils.extractTotalBlobLength(headers.getContentRange());
    }

    public static String tagsToString(Map<String, String> tags) {
        if (tags == null || tags.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            try {
                if (!first) {
                    sb.append("&");
                } else {
                    first = false;
                }
                sb.append(URLEncoder.encode(entry.getKey(), StandardCharsets.UTF_8.toString()));
                sb.append("=");
                sb.append(URLEncoder.encode(entry.getValue(), StandardCharsets.UTF_8.toString()));
            }
            catch (UnsupportedEncodingException e) {
                throw LOGGER.logExceptionAsError(new IllegalStateException(e));
            }
        }
        return sb.toString();
    }

    public static LongRunningOperationStatus mapStatusToLongRunningOperationStatus(CopyStatusType status) {
        LongRunningOperationStatus operationStatus;
        switch (status) {
            case SUCCESS: {
                operationStatus = LongRunningOperationStatus.SUCCESSFULLY_COMPLETED;
                break;
            }
            case FAILED: {
                operationStatus = LongRunningOperationStatus.FAILED;
                break;
            }
            case ABORTED: {
                operationStatus = LongRunningOperationStatus.USER_CANCELLED;
                break;
            }
            case PENDING: {
                operationStatus = LongRunningOperationStatus.IN_PROGRESS;
                break;
            }
            default: {
                throw LOGGER.logExceptionAsError(new IllegalArgumentException("CopyStatusType is not supported. Status: " + (Object)((Object)status)));
            }
        }
        return operationStatus;
    }

    public static boolean validateNoETag(BlobRequestConditions modifiedRequestConditions) {
        if (modifiedRequestConditions == null) {
            return true;
        }
        return modifiedRequestConditions.getIfMatch() == null && modifiedRequestConditions.getIfNoneMatch() == null;
    }

    public static List<ListBlobContainersIncludeType> toIncludeTypes(BlobContainerListDetails blobContainerListDetails) {
        boolean hasDetails;
        boolean bl = hasDetails = blobContainerListDetails != null && (blobContainerListDetails.getRetrieveMetadata() || blobContainerListDetails.getRetrieveDeleted() || blobContainerListDetails.getRetrieveSystemContainers());
        if (hasDetails) {
            ArrayList<ListBlobContainersIncludeType> flags = new ArrayList<ListBlobContainersIncludeType>(3);
            if (blobContainerListDetails.getRetrieveDeleted()) {
                flags.add(ListBlobContainersIncludeType.DELETED);
            }
            if (blobContainerListDetails.getRetrieveMetadata()) {
                flags.add(ListBlobContainersIncludeType.METADATA);
            }
            if (blobContainerListDetails.getRetrieveSystemContainers()) {
                flags.add(ListBlobContainersIncludeType.SYSTEM);
            }
            return flags;
        }
        return null;
    }

    public static void validateRetentionPolicy(BlobRetentionPolicy retentionPolicy, String policyName) {
        if (retentionPolicy == null) {
            return;
        }
        if (retentionPolicy.isEnabled()) {
            StorageImplUtils.assertInBounds(policyName, retentionPolicy.getDays().intValue(), 1L, 365L);
        }
    }

    public static BlobCorsRule validatedCorsRule(BlobCorsRule originalRule) {
        if (originalRule == null) {
            return null;
        }
        BlobCorsRule validRule = new BlobCorsRule();
        validRule.setAllowedHeaders(StorageImplUtils.emptyIfNull(originalRule.getAllowedHeaders()));
        validRule.setAllowedMethods(StorageImplUtils.emptyIfNull(originalRule.getAllowedMethods()));
        validRule.setAllowedOrigins(StorageImplUtils.emptyIfNull(originalRule.getAllowedOrigins()));
        validRule.setExposedHeaders(StorageImplUtils.emptyIfNull(originalRule.getExposedHeaders()));
        validRule.setMaxAgeInSeconds(originalRule.getMaxAgeInSeconds());
        return validRule;
    }

    public static String pageRangeToString(PageRange pageRange) {
        if (pageRange.getStart() < 0L || pageRange.getEnd() <= 0L) {
            throw new IllegalArgumentException("PageRange's start and end values must be greater than or equal to 0 if specified.");
        }
        if (pageRange.getStart() % 512L != 0L) {
            throw new IllegalArgumentException("PageRange's start value must be a multiple of 512.");
        }
        if (pageRange.getEnd() % 512L != 511L) {
            throw new IllegalArgumentException("PageRange's end value must be 1 less than a multiple of 512.");
        }
        if (pageRange.getEnd() <= pageRange.getStart()) {
            throw new IllegalArgumentException("PageRange's End value must be after the start.");
        }
        return "bytes=" + pageRange.getStart() + '-' + pageRange.getEnd();
    }

    public static List<BlobSignedIdentifier> truncateTimeForBlobSignedIdentifier(List<BlobSignedIdentifier> identifiers) {
        if (identifiers == null) {
            return null;
        }
        for (BlobSignedIdentifier identifier : identifiers) {
            if (identifier.getAccessPolicy() != null && identifier.getAccessPolicy().getStartsOn() != null) {
                identifier.getAccessPolicy().setStartsOn(identifier.getAccessPolicy().getStartsOn().truncatedTo(ChronoUnit.SECONDS));
            }
            if (identifier.getAccessPolicy() == null || identifier.getAccessPolicy().getExpiresOn() == null) continue;
            identifier.getAccessPolicy().setExpiresOn(identifier.getAccessPolicy().getExpiresOn().truncatedTo(ChronoUnit.SECONDS));
        }
        return identifiers;
    }

    public static BlobStorageException mapToBlobStorageException(BlobStorageExceptionInternal internal) {
        return new BlobStorageException(internal.getMessage(), internal.getResponse(), internal.getValue());
    }

    private ModelHelper() {
    }
}

