/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.blob.options;

import com.azure.core.util.ExpandableStringEnum;
import com.azure.core.util.logging.ClientLogger;
import com.azure.storage.blob.models.AccessTier;
import com.azure.storage.blob.models.BlobHttpHeaders;
import com.azure.storage.blob.models.BlobRequestConditions;
import java.util.Collection;
import java.util.Map;
import java.util.Objects;

public final class BlockBlobSeekableByteChannelWriteOptions {
    private static final ClientLogger LOGGER = new ClientLogger(BlockBlobSeekableByteChannelWriteOptions.class);
    private final WriteMode writeMode;
    private Long blockSizeInBytes;
    private BlobHttpHeaders headers;
    private Map<String, String> metadata;
    private Map<String, String> tags;
    private AccessTier tier;
    private BlobRequestConditions conditions;

    public BlockBlobSeekableByteChannelWriteOptions(WriteMode mode) {
        this.writeMode = Objects.requireNonNull(mode, "'mode' cannot be null.");
    }

    public WriteMode getWriteMode() {
        return this.writeMode;
    }

    public Long getBlockSizeInBytes() {
        return this.blockSizeInBytes;
    }

    public BlockBlobSeekableByteChannelWriteOptions setBlockSizeInBytes(Long blockSizeInBytes) {
        this.blockSizeInBytes = blockSizeInBytes;
        return this;
    }

    public BlobHttpHeaders getHeaders() {
        return this.headers;
    }

    public BlockBlobSeekableByteChannelWriteOptions setHeaders(BlobHttpHeaders headers) {
        this.headers = headers;
        return this;
    }

    public Map<String, String> getMetadata() {
        return this.metadata;
    }

    public BlockBlobSeekableByteChannelWriteOptions setMetadata(Map<String, String> metadata) {
        this.metadata = metadata;
        return this;
    }

    public Map<String, String> getTags() {
        return this.tags;
    }

    public BlockBlobSeekableByteChannelWriteOptions setTags(Map<String, String> tags) {
        this.tags = tags;
        return this;
    }

    public AccessTier getTier() {
        return this.tier;
    }

    public BlockBlobSeekableByteChannelWriteOptions setTier(AccessTier tier) {
        this.tier = tier;
        return this;
    }

    public BlobRequestConditions getRequestConditions() {
        return this.conditions;
    }

    public BlockBlobSeekableByteChannelWriteOptions setRequestConditions(BlobRequestConditions conditions) {
        this.conditions = conditions;
        return this;
    }

    public static final class WriteMode
    extends ExpandableStringEnum<WriteMode> {
        public static final WriteMode OVERWRITE = WriteMode.fromString("Overwrite");

        public static WriteMode fromString(String name) {
            return WriteMode.fromString(name, WriteMode.class);
        }

        public static Collection<WriteMode> values() {
            return WriteMode.values(WriteMode.class);
        }
    }
}

