/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.options;

import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonToken;
import com.azure.json.JsonWriter;
import java.io.IOException;

public final class FileSystemEncryptionScopeOptions
implements JsonSerializable<FileSystemEncryptionScopeOptions> {
    private String defaultEncryptionScope;
    private Boolean encryptionScopeOverridePrevented;

    public String getDefaultEncryptionScope() {
        return this.defaultEncryptionScope;
    }

    public FileSystemEncryptionScopeOptions setDefaultEncryptionScope(String encryptionScope) {
        this.defaultEncryptionScope = encryptionScope;
        return this;
    }

    public Boolean isEncryptionScopeOverridePrevented() {
        return this.encryptionScopeOverridePrevented;
    }

    public FileSystemEncryptionScopeOptions setEncryptionScopeOverridePrevented(Boolean encryptionScopeOverridePrevented) {
        this.encryptionScopeOverridePrevented = encryptionScopeOverridePrevented;
        return this;
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        jsonWriter.writeStartObject();
        jsonWriter.writeStringField("DefaultEncryptionScope", this.defaultEncryptionScope);
        jsonWriter.writeBooleanField("EncryptionScopeOverridePrevented", this.encryptionScopeOverridePrevented);
        jsonWriter.writeEndObject();
        return jsonWriter;
    }

    public static FileSystemEncryptionScopeOptions fromJson(JsonReader jsonReader) throws IOException {
        return jsonReader.readObject(reader -> {
            FileSystemEncryptionScopeOptions fileSystemEncryptionScopeOptions = new FileSystemEncryptionScopeOptions();
            while (reader.nextToken() != JsonToken.END_OBJECT) {
                String fieldName = reader.getFieldName();
                reader.nextToken();
                if ("DefaultEncryptionScope".equals(fieldName)) {
                    fileSystemEncryptionScopeOptions.defaultEncryptionScope = reader.getString();
                    continue;
                }
                if ("EncryptionScopeOverridePrevented".equals(fieldName)) {
                    fileSystemEncryptionScopeOptions.encryptionScopeOverridePrevented = reader.getNullable(JsonReader::getBoolean);
                    continue;
                }
                reader.skipChildren();
            }
            return fileSystemEncryptionScopeOptions;
        });
    }
}

