/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelInboundHandlerAdapter;
import org.apache.iceberg.azure.shaded.io.netty.util.concurrent.ScheduledFuture;

public final class ReadTimeoutHandler
extends ChannelInboundHandlerAdapter {
    public static final String HANDLER_NAME = "azureReadTimeoutHandler";
    private static final String READ_TIMED_OUT_MESSAGE = "Channel read timed out after %d milliseconds.";
    private final long timeoutMillis;
    private boolean closed;
    private long lastReadMillis;
    private ScheduledFuture<?> readTimeoutWatcher;

    public ReadTimeoutHandler(long timeoutMillis) {
        this.timeoutMillis = timeoutMillis;
    }

    ScheduledFuture<?> getReadTimeoutWatcher() {
        return this.readTimeoutWatcher;
    }

    @Override
    public void channelReadComplete(ChannelHandlerContext ctx) {
        this.lastReadMillis = System.currentTimeMillis();
        ctx.fireChannelReadComplete();
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) {
        if (this.timeoutMillis > 0L) {
            this.readTimeoutWatcher = ctx.executor().scheduleAtFixedRate(() -> this.readTimeoutRunnable(ctx), this.timeoutMillis, this.timeoutMillis, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void handlerRemoved(ChannelHandlerContext ctx) {
        this.disposeWatcher();
    }

    void readTimeoutRunnable(ChannelHandlerContext ctx) {
        if (this.timeoutMillis - (System.currentTimeMillis() - this.lastReadMillis) > 0L) {
            return;
        }
        if (!this.closed) {
            this.disposeWatcher();
            ctx.fireExceptionCaught(new TimeoutException(String.format(READ_TIMED_OUT_MESSAGE, this.timeoutMillis)));
            ctx.close();
            this.closed = true;
        }
    }

    private void disposeWatcher() {
        if (this.readTimeoutWatcher != null && !this.readTimeoutWatcher.isDone()) {
            this.readTimeoutWatcher.cancel(false);
            this.readTimeoutWatcher = null;
        }
    }
}

