/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.http.netty.implementation;

import com.azure.core.util.ProgressReporter;
import java.util.Objects;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBuf;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBufHolder;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelOutboundHandlerAdapter;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelPromise;
import org.apache.iceberg.azure.shaded.io.netty.channel.FileRegion;

public final class RequestProgressReportingHandler
extends ChannelOutboundHandlerAdapter {
    public static final String HANDLER_NAME = "azureRequestProgressHandler";
    private final ProgressReporter progressReporter;

    public RequestProgressReportingHandler(ProgressReporter progressReporter) {
        this.progressReporter = Objects.requireNonNull(progressReporter, "'progressReporter' must not be null");
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof ByteBuf) {
            this.progressReporter.reportProgress(((ByteBuf)msg).readableBytes());
        } else if (msg instanceof ByteBufHolder) {
            this.progressReporter.reportProgress(((ByteBufHolder)msg).content().readableBytes());
        } else if (msg instanceof FileRegion) {
            this.progressReporter.reportProgress(((FileRegion)msg).count());
        }
        ctx.write(msg, promise.unvoid());
    }
}

