/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.implementation.jackson;

import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.BeanDescription;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.DeserializationConfig;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonDeserializer;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonMappingException;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.cfg.CoercionAction;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.cfg.CoercionInputShape;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.cfg.MapperConfig;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.deser.BeanDeserializerModifier;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.deser.std.DelegatingDeserializer;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.introspect.AccessorNamingStrategy;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedClass;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.module.SimpleModule;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.util.AccessPattern;

final class JacksonDatabind212 {
    JacksonDatabind212() {
    }

    static ObjectMapper mutateXmlCoercions(ObjectMapper mapper) {
        mapper.registerModule(new SimpleModule().setDeserializerModifier(new BeanDeserializerModifier(){

            @Override
            public JsonDeserializer<?> modifyDeserializer(DeserializationConfig config, BeanDescription beanDesc, JsonDeserializer<?> deserializer) {
                if (String.class.isAssignableFrom(beanDesc.getBeanClass())) {
                    return new DelegatingDeserializer(deserializer){

                        @Override
                        protected JsonDeserializer<?> newDelegatingInstance(JsonDeserializer<?> newDelegatee) {
                            return this;
                        }

                        @Override
                        public AccessPattern getNullAccessPattern() {
                            return AccessPattern.DYNAMIC;
                        }

                        @Override
                        public Object getNullValue(DeserializationContext ctxt) throws JsonMappingException {
                            return ctxt.getParser().getParsingContext().inArray() ? "" : super.getNullValue(ctxt);
                        }
                    };
                }
                return deserializer;
            }
        }));
        mapper.coercionConfigDefaults().setCoercion(CoercionInputShape.EmptyString, CoercionAction.AsNull);
        return mapper;
    }

    static String removePrefix(MapperConfig<?> config, AnnotatedClass annotatedClass, AnnotatedMethod method, String methodName) {
        AccessorNamingStrategy namingStrategy = config.getAccessorNaming().forPOJO(config, annotatedClass);
        String name = namingStrategy.findNameForIsGetter(method, methodName);
        if (name == null) {
            name = namingStrategy.findNameForRegularGetter(method, methodName);
        }
        return name;
    }
}

