/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.models.GeoArray;
import com.azure.core.models.GeoPosition;
import com.azure.core.util.logging.ClientLogger;
import com.azure.json.JsonReader;
import com.azure.json.JsonSerializable;
import com.azure.json.JsonWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public final class GeoLinearRing
implements JsonSerializable<GeoLinearRing> {
    private static final ClientLogger LOGGER = new ClientLogger(GeoLinearRing.class);
    private final GeoArray<GeoPosition> coordinates;

    public GeoLinearRing(List<GeoPosition> coordinates) {
        Objects.requireNonNull(coordinates, "'coordinates' cannot be null.");
        int size = coordinates.size();
        if (size < 4) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("A linear ring requires at least 4 coordinates."));
        }
        if (!Objects.equals(coordinates.get(0), coordinates.get(size - 1))) {
            throw LOGGER.logExceptionAsError(new IllegalArgumentException("The first and last coordinates of a linear ring must be equivalent."));
        }
        this.coordinates = new GeoArray(new ArrayList<GeoPosition>(coordinates));
    }

    public List<GeoPosition> getCoordinates() {
        return this.coordinates;
    }

    public int hashCode() {
        return this.coordinates.hashCode();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof GeoLinearRing)) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        GeoLinearRing other = (GeoLinearRing)obj;
        return Objects.equals(this.coordinates, other.coordinates);
    }

    @Override
    public JsonWriter toJson(JsonWriter jsonWriter) throws IOException {
        return jsonWriter.writeArray(this.getCoordinates(), JsonWriter::writeJson);
    }

    public static GeoLinearRing fromJson(JsonReader jsonReader) throws IOException {
        List<GeoPosition> coordinates = jsonReader.readArray(GeoPosition::fromJson);
        if (coordinates == null) {
            return null;
        }
        return new GeoLinearRing(coordinates);
    }
}

