/*
 * Decompiled with CFR 0.152.
 */
package com.azure.core.models;

import com.azure.core.implementation.Option;
import com.azure.core.models.JsonPatchOperation;
import java.io.IOException;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonGenerator;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.JsonSerializer;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.SerializerProvider;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.module.SimpleModule;

final class JsonPatchOperationSerializer
extends JsonSerializer<JsonPatchOperation> {
    private static final SimpleModule MODULE = new SimpleModule().addSerializer(JsonPatchOperation.class, new JsonPatchOperationSerializer());

    JsonPatchOperationSerializer() {
    }

    public static SimpleModule getModule() {
        return MODULE;
    }

    @Override
    public void serialize(JsonPatchOperation value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
        gen.writeStartObject();
        gen.writeStringField("op", value.getOp().toString());
        String from = value.getFrom();
        if (from != null) {
            gen.writeStringField("from", from);
        }
        gen.writeStringField("path", value.getPath());
        Option<String> optionalValue = value.getValue();
        if (optionalValue.isInitialized()) {
            String val = optionalValue.getValue();
            if (val != null) {
                gen.writeFieldName("value");
                gen.writeRawValue(val);
            } else {
                gen.writeNullField("value");
            }
        }
        gen.writeEndObject();
    }
}

