/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.shaded.com.fasterxml.jackson.datatype.jsr310.deser;

import java.io.IOException;
import java.time.DateTimeException;
import java.time.Year;
import java.time.format.DateTimeFormatter;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.annotation.JsonFormat;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonParser;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.JsonToken;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.StreamReadCapability;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.core.io.NumberInput;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.iceberg.azure.shaded.com.fasterxml.jackson.datatype.jsr310.deser.JSR310DateTimeDeserializerBase;

public class YearDeserializer
extends JSR310DateTimeDeserializerBase<Year> {
    private static final long serialVersionUID = 1L;
    public static final YearDeserializer INSTANCE = new YearDeserializer();

    public YearDeserializer() {
        this((DateTimeFormatter)null);
    }

    public YearDeserializer(DateTimeFormatter formatter) {
        super(Year.class, formatter);
    }

    protected YearDeserializer(YearDeserializer base, Boolean leniency) {
        super(base, leniency);
    }

    public YearDeserializer(YearDeserializer base, Boolean leniency, DateTimeFormatter formatter, JsonFormat.Shape shape) {
        super(base, leniency, formatter, shape);
    }

    protected YearDeserializer withDateFormat(DateTimeFormatter dtf) {
        return new YearDeserializer(this, (Boolean)this._isLenient, dtf, this._shape);
    }

    @Override
    protected YearDeserializer withLeniency(Boolean leniency) {
        return new YearDeserializer(this, leniency);
    }

    @Override
    public Year deserialize(JsonParser parser, DeserializationContext context) throws IOException {
        JsonToken t = parser.currentToken();
        if (t == JsonToken.VALUE_STRING) {
            return this._fromString(parser, context, parser.getText());
        }
        if (t == JsonToken.START_OBJECT) {
            return this._fromString(parser, context, context.extractScalarFromObject(parser, this, this.handledType()));
        }
        if (t == JsonToken.VALUE_NUMBER_INT) {
            return this._fromNumber(context, parser.getIntValue());
        }
        if (t == JsonToken.VALUE_EMBEDDED_OBJECT) {
            return (Year)parser.getEmbeddedObject();
        }
        if (parser.hasToken(JsonToken.START_ARRAY)) {
            return (Year)this._deserializeFromArray(parser, context);
        }
        return (Year)this._handleUnexpectedToken(context, parser, JsonToken.VALUE_STRING, JsonToken.VALUE_NUMBER_INT);
    }

    protected Year _fromString(JsonParser p, DeserializationContext ctxt, String string0) throws IOException {
        String string = string0.trim();
        if (string.length() == 0) {
            return (Year)this._fromEmptyString(p, ctxt, string);
        }
        if (ctxt.isEnabled(StreamReadCapability.UNTYPED_SCALARS) && this._isValidTimestampString(string)) {
            return this._fromNumber(ctxt, NumberInput.parseInt(string));
        }
        try {
            if (this._formatter == null) {
                return Year.parse(string);
            }
            return Year.parse(string, this._formatter);
        }
        catch (DateTimeException e) {
            return (Year)this._handleDateTimeException(ctxt, e, string);
        }
    }

    protected Year _fromNumber(DeserializationContext ctxt, int value) {
        return Year.of(value);
    }
}

