/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.azure.shaded.io.netty.resolver.dns;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

final class ResolvConf {
    private final List<InetSocketAddress> nameservers;

    static ResolvConf fromReader(BufferedReader reader) throws IOException {
        return new ResolvConf(reader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static ResolvConf fromFile(String file) throws IOException {
        FileReader fileReader = new FileReader(file);
        try {
            BufferedReader reader = new BufferedReader(new FileReader(file));
            ResolvConf resolvConf = ResolvConf.fromReader(reader);
            return resolvConf;
        }
        finally {
            fileReader.close();
        }
    }

    static ResolvConf system() {
        ResolvConf resolvConv = ResolvConfLazy.machineResolvConf;
        if (resolvConv != null) {
            return resolvConv;
        }
        throw new IllegalStateException("/etc/resolv.conf could not be read");
    }

    private ResolvConf(BufferedReader reader) throws IOException {
        String ln;
        ArrayList<InetSocketAddress> nameservers = new ArrayList<InetSocketAddress>();
        while ((ln = reader.readLine()) != null) {
            if ((ln = ln.trim()).isEmpty() || !ln.startsWith("nameserver")) continue;
            ln = ln.substring("nameserver".length()).trim();
            nameservers.add(new InetSocketAddress(ln, 53));
        }
        this.nameservers = Collections.unmodifiableList(nameservers);
    }

    List<InetSocketAddress> getNameservers() {
        return this.nameservers;
    }

    private static final class ResolvConfLazy {
        static final ResolvConf machineResolvConf;

        private ResolvConfLazy() {
        }

        static {
            ResolvConf resolvConf;
            try {
                resolvConf = ResolvConf.fromFile("/etc/resolv.conf");
            }
            catch (IOException e) {
                resolvConf = null;
            }
            catch (SecurityException ignore) {
                resolvConf = null;
            }
            machineResolvConf = resolvConf;
        }
    }
}

