/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server.logging;

import java.util.function.Function;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBuf;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBufHolder;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelPromise;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpMessage;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpResponse;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpResponseStatus;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpUtil;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.iceberg.azure.shaded.io.netty.util.concurrent.Future;
import org.apache.iceberg.azure.shaded.io.netty.util.concurrent.GenericFutureListener;
import reactor.netty.channel.ChannelOperations;
import reactor.netty.http.server.HttpServerRequest;
import reactor.netty.http.server.logging.AccessLog;
import reactor.netty.http.server.logging.AccessLogArgProvider;
import reactor.netty.http.server.logging.AccessLogArgProviderH1;
import reactor.netty.http.server.logging.BaseAccessLogHandler;
import reactor.util.annotation.Nullable;

final class AccessLogHandlerH1
extends BaseAccessLogHandler {
    AccessLogArgProviderH1 accessLogArgProvider;

    AccessLogHandlerH1(@Nullable Function<AccessLogArgProvider, AccessLog> accessLog) {
        super(accessLog);
    }

    @Override
    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
        if (msg instanceof HttpResponse) {
            ChannelOperations<?, ?> ops;
            HttpResponse response = (HttpResponse)msg;
            HttpResponseStatus status = response.status();
            if (status.equals(HttpResponseStatus.CONTINUE)) {
                ctx.write(msg, promise);
                return;
            }
            if (this.accessLogArgProvider == null) {
                this.accessLogArgProvider = new AccessLogArgProviderH1(ctx.channel().remoteAddress());
            }
            if ((ops = ChannelOperations.get(ctx.channel())) instanceof HttpServerRequest) {
                this.accessLogArgProvider.request((HttpServerRequest)((Object)ops));
            }
            boolean chunked = HttpUtil.isTransferEncodingChunked(response);
            this.accessLogArgProvider.response(response).chunked(chunked);
            if (!chunked) {
                this.accessLogArgProvider.contentLength(HttpUtil.getContentLength((HttpMessage)response, -1));
            }
        }
        if (msg instanceof LastHttpContent) {
            this.accessLogArgProvider.increaseContentLength(((LastHttpContent)msg).content().readableBytes());
            ctx.write(msg, promise.unvoid()).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)future -> {
                if (future.isSuccess()) {
                    AccessLog log = (AccessLog)this.accessLog.apply(this.accessLogArgProvider);
                    if (log != null) {
                        log.log();
                    }
                    this.accessLogArgProvider.clear();
                }
            }));
            return;
        }
        if (msg instanceof ByteBuf) {
            this.accessLogArgProvider.increaseContentLength(((ByteBuf)msg).readableBytes());
        }
        if (msg instanceof ByteBufHolder) {
            this.accessLogArgProvider.increaseContentLength(((ByteBufHolder)msg).content().readableBytes());
        }
        ctx.write(msg, promise);
    }
}

