/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.resources;

import java.util.concurrent.ThreadFactory;
import org.apache.iceberg.azure.shaded.io.netty.channel.Channel;
import org.apache.iceberg.azure.shaded.io.netty.channel.EventLoopGroup;
import org.apache.iceberg.azure.shaded.io.netty.channel.socket.DatagramChannel;
import org.apache.iceberg.azure.shaded.io.netty.channel.socket.ServerSocketChannel;
import org.apache.iceberg.azure.shaded.io.netty.channel.socket.SocketChannel;
import org.apache.iceberg.azure.shaded.io.netty.channel.socket.nio.NioDatagramChannel;
import org.apache.iceberg.azure.shaded.io.netty.channel.socket.nio.NioServerSocketChannel;
import org.apache.iceberg.azure.shaded.io.netty.channel.socket.nio.NioSocketChannel;
import reactor.netty.resources.DefaultLoop;

final class DefaultLoopNIO
implements DefaultLoop {
    DefaultLoopNIO() {
    }

    @Override
    public <CHANNEL extends Channel> CHANNEL getChannel(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return (CHANNEL)new NioSocketChannel();
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return (CHANNEL)new NioServerSocketChannel();
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return (CHANNEL)new NioDatagramChannel();
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public <CHANNEL extends Channel> Class<? extends CHANNEL> getChannelClass(Class<CHANNEL> channelClass) {
        if (channelClass.equals(SocketChannel.class)) {
            return NioSocketChannel.class;
        }
        if (channelClass.equals(ServerSocketChannel.class)) {
            return NioServerSocketChannel.class;
        }
        if (channelClass.equals(DatagramChannel.class)) {
            return NioDatagramChannel.class;
        }
        throw new IllegalArgumentException("Unsupported channel type: " + channelClass.getSimpleName());
    }

    @Override
    public String getName() {
        return "nio";
    }

    @Override
    public EventLoopGroup newEventLoopGroup(int threads, ThreadFactory factory) {
        throw new IllegalStateException("Missing Epoll/KQueue on current system");
    }

    @Override
    public boolean supportGroup(EventLoopGroup group) {
        return false;
    }
}

