/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.common.implementation;

import com.azure.storage.common.implementation.BufferAggregator;
import com.azure.storage.common.implementation.StorageImplUtils;
import java.nio.ByteBuffer;
import reactor.core.publisher.Flux;

public final class BufferStagingArea {
    private final long buffSize;
    private BufferAggregator currentBuf;

    public BufferStagingArea(long buffSize, long maxBuffSize) {
        StorageImplUtils.assertInBounds("buffSize", buffSize, 1L, maxBuffSize);
        this.buffSize = buffSize;
    }

    public Flux<BufferAggregator> write(ByteBuffer buf) {
        Flux<BufferAggregator> result;
        if (this.currentBuf == null) {
            this.currentBuf = new BufferAggregator(this.buffSize);
        }
        if (this.currentBuf.remainingCapacity() >= (long)buf.remaining()) {
            this.currentBuf.append(buf);
            if (this.currentBuf.remainingCapacity() == 0L) {
                result = Flux.just(this.currentBuf);
                this.currentBuf = null;
            } else {
                result = Flux.empty();
            }
        } else {
            ByteBuffer duplicate = buf.duplicate();
            int newLimit = buf.position() + (int)this.currentBuf.remainingCapacity();
            duplicate.limit(newLimit);
            this.currentBuf.append(duplicate);
            buf.position(newLimit);
            result = Flux.just(this.currentBuf);
            int remainingChunks = buf.remaining() / (int)this.buffSize;
            if (remainingChunks >= 1) {
                BufferAggregator[] aggregators = new BufferAggregator[remainingChunks];
                for (int i = 0; i < remainingChunks; ++i) {
                    BufferAggregator aggregator = new BufferAggregator(this.buffSize);
                    ByteBuffer overflowDup = buf.duplicate();
                    int overflowLimit = buf.position() + (int)this.buffSize;
                    overflowDup.limit(overflowLimit);
                    aggregator.append(overflowDup);
                    buf.position(overflowLimit);
                    aggregators[i] = aggregator;
                }
                result = result.concatWith(Flux.fromArray(aggregators));
            }
            if (buf.remaining() > 0) {
                this.currentBuf = new BufferAggregator(this.buffSize);
                this.currentBuf.append(buf);
            } else {
                this.currentBuf = null;
            }
        }
        return result;
    }

    public Flux<BufferAggregator> flush() {
        if (this.currentBuf != null) {
            BufferAggregator last = this.currentBuf;
            this.currentBuf = null;
            return Flux.just(last);
        }
        return Flux.empty();
    }
}

