/*
 * Decompiled with CFR 0.152.
 */
package com.azure.storage.file.datalake.options;

import com.azure.storage.common.implementation.StorageImplUtils;
import com.azure.storage.file.datalake.models.DataLakeRequestConditions;
import com.azure.storage.file.datalake.models.FileQueryError;
import com.azure.storage.file.datalake.models.FileQueryProgress;
import com.azure.storage.file.datalake.models.FileQuerySerialization;
import java.io.OutputStream;
import java.util.function.Consumer;

public class FileQueryOptions {
    private final String expression;
    private final OutputStream outputStream;
    private FileQuerySerialization inputSerialization;
    private FileQuerySerialization outputSerialization;
    private DataLakeRequestConditions requestConditions;
    private Consumer<FileQueryError> errorConsumer;
    private Consumer<FileQueryProgress> progressConsumer;

    public FileQueryOptions(String expression) {
        StorageImplUtils.assertNotNull("expression", expression);
        this.expression = expression;
        this.outputStream = null;
    }

    public FileQueryOptions(String expression, OutputStream outputStream) {
        StorageImplUtils.assertNotNull("expression", expression);
        StorageImplUtils.assertNotNull("outputStream", outputStream);
        this.expression = expression;
        this.outputStream = outputStream;
    }

    public String getExpression() {
        return this.expression;
    }

    public OutputStream getOutputStream() {
        return this.outputStream;
    }

    public FileQuerySerialization getInputSerialization() {
        return this.inputSerialization;
    }

    public FileQueryOptions setInputSerialization(FileQuerySerialization inputSerialization) {
        this.inputSerialization = inputSerialization;
        return this;
    }

    public FileQuerySerialization getOutputSerialization() {
        return this.outputSerialization;
    }

    public FileQueryOptions setOutputSerialization(FileQuerySerialization outputSerialization) {
        this.outputSerialization = outputSerialization;
        return this;
    }

    public DataLakeRequestConditions getRequestConditions() {
        return this.requestConditions;
    }

    public FileQueryOptions setRequestConditions(DataLakeRequestConditions requestConditions) {
        this.requestConditions = requestConditions;
        return this;
    }

    public Consumer<FileQueryError> getErrorConsumer() {
        return this.errorConsumer;
    }

    public FileQueryOptions setErrorConsumer(Consumer<FileQueryError> errorConsumer) {
        this.errorConsumer = errorConsumer;
        return this;
    }

    public Consumer<FileQueryProgress> getProgressConsumer() {
        return this.progressConsumer;
    }

    public FileQueryOptions setProgressConsumer(Consumer<FileQueryProgress> progressConsumer) {
        this.progressConsumer = progressConsumer;
        return this;
    }
}

