/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.openid.connect.sdk.token;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.oauth2.sdk.token.Tokens;
import com.nimbusds.oauth2.sdk.util.JSONObjectUtils;
import com.nimbusds.openid.connect.sdk.nativesso.DeviceSecret;
import java.util.Collections;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import net.minidev.json.JSONObject;

public final class OIDCTokens
extends Tokens {
    private final JWT idToken;
    private final String idTokenString;
    private final DeviceSecret deviceSecret;

    public OIDCTokens(JWT idToken, AccessToken accessToken, RefreshToken refreshToken) {
        this(idToken, accessToken, refreshToken, null);
    }

    public OIDCTokens(JWT idToken, AccessToken accessToken, RefreshToken refreshToken, DeviceSecret deviceSecret) {
        super(accessToken, refreshToken);
        this.idToken = Objects.requireNonNull(idToken);
        this.idTokenString = null;
        this.deviceSecret = deviceSecret;
    }

    public OIDCTokens(String idTokenString, AccessToken accessToken, RefreshToken refreshToken) {
        this(idTokenString, accessToken, refreshToken, null);
    }

    public OIDCTokens(String idTokenString, AccessToken accessToken, RefreshToken refreshToken, DeviceSecret deviceSecret) {
        super(accessToken, refreshToken);
        this.idTokenString = Objects.requireNonNull(idTokenString);
        this.idToken = null;
        this.deviceSecret = deviceSecret;
    }

    public OIDCTokens(AccessToken accessToken, RefreshToken refreshToken) {
        this(accessToken, refreshToken, null);
    }

    public OIDCTokens(AccessToken accessToken, RefreshToken refreshToken, DeviceSecret deviceSecret) {
        super(accessToken, refreshToken);
        this.idToken = null;
        this.idTokenString = null;
        this.deviceSecret = deviceSecret;
    }

    public JWT getIDToken() {
        if (this.idToken != null) {
            return this.idToken;
        }
        if (this.idTokenString != null) {
            try {
                return JWTParser.parse(this.idTokenString);
            }
            catch (java.text.ParseException e) {
                return null;
            }
        }
        return null;
    }

    public String getIDTokenString() {
        if (this.idTokenString != null) {
            return this.idTokenString;
        }
        if (this.idToken != null) {
            if (this.idToken.getParsedString() != null) {
                return this.idToken.getParsedString();
            }
            try {
                return this.idToken.serialize();
            }
            catch (IllegalStateException e) {
                return null;
            }
        }
        return null;
    }

    public DeviceSecret getDeviceSecret() {
        return this.deviceSecret;
    }

    @Override
    public Set<String> getParameterNames() {
        HashSet<String> paramNames = new HashSet<String>(super.getParameterNames());
        if (this.idToken != null || this.idTokenString != null) {
            paramNames.add("id_token");
        }
        if (this.deviceSecret != null) {
            paramNames.add("device_secret");
        }
        return Collections.unmodifiableSet(paramNames);
    }

    @Override
    public JSONObject toJSONObject() {
        JSONObject o = super.toJSONObject();
        if (this.getIDTokenString() != null) {
            o.put("id_token", this.getIDTokenString());
        }
        if (this.deviceSecret != null) {
            o.put("device_secret", this.deviceSecret.getValue());
        }
        return o;
    }

    public static OIDCTokens parse(JSONObject jsonObject) throws ParseException {
        AccessToken accessToken = AccessToken.parse(jsonObject);
        RefreshToken refreshToken = RefreshToken.parse(jsonObject);
        DeviceSecret deviceSecret = null;
        if (jsonObject.get("device_secret") != null) {
            deviceSecret = DeviceSecret.parse(JSONObjectUtils.getString(jsonObject, "device_secret"));
        }
        if (jsonObject.get("id_token") != null) {
            JWT idToken;
            try {
                idToken = JWTParser.parse(JSONObjectUtils.getString(jsonObject, "id_token"));
            }
            catch (java.text.ParseException e) {
                throw new ParseException("Couldn't parse ID token: " + e.getMessage(), e);
            }
            return new OIDCTokens(idToken, accessToken, refreshToken, deviceSecret);
        }
        return new OIDCTokens(accessToken, refreshToken, deviceSecret);
    }
}

