/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.logging;

import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpResponse;
import reactor.netty.http.logging.AbstractHttpMessageArgProvider;
import reactor.netty.http.logging.HttpMessageType;

final class HttpResponseArgProvider
extends AbstractHttpMessageArgProvider {
    final HttpHeaders httpHeaders;
    final String protocol;
    final String status;

    HttpResponseArgProvider(HttpResponse httpResponse) {
        super(httpResponse.decoderResult());
        this.httpHeaders = httpResponse.headers();
        this.protocol = httpResponse.protocolVersion().text();
        this.status = httpResponse.status().toString();
    }

    @Override
    public HttpHeaders headers() {
        return this.httpHeaders;
    }

    @Override
    public HttpMessageType httpMessageType() {
        return HttpMessageType.RESPONSE;
    }

    @Override
    public String protocol() {
        return this.protocol;
    }

    @Override
    public String status() {
        return this.status;
    }
}

