/*
 * Decompiled with CFR 0.152.
 */
package reactor.netty.http.server;

import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.apache.iceberg.azure.shaded.io.netty.buffer.ByteBuf;
import org.apache.iceberg.azure.shaded.io.netty.channel.Channel;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelFutureListener;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandler;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelHandlerContext;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelPipeline;
import org.apache.iceberg.azure.shaded.io.netty.channel.ChannelPromise;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.DefaultFullHttpRequest;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaderNames;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpHeaders;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpRequest;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.HttpServerCodec;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.LastHttpContent;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.websocketx.WebSocketCloseStatus;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import org.apache.iceberg.azure.shaded.io.netty.handler.codec.http.websocketx.extensions.compression.WebSocketServerCompressionHandler;
import org.apache.iceberg.azure.shaded.io.netty.util.concurrent.Future;
import org.apache.iceberg.azure.shaded.io.netty.util.concurrent.GenericFutureListener;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.core.publisher.Sinks;
import reactor.netty.FutureMono;
import reactor.netty.NettyOutbound;
import reactor.netty.ReactorNetty;
import reactor.netty.http.server.AbstractHttpServerMetricsHandler;
import reactor.netty.http.server.HttpServerMetricsRecorder;
import reactor.netty.http.server.HttpServerOperations;
import reactor.netty.http.server.MicrometerHttpServerMetricsRecorder;
import reactor.netty.http.server.WebsocketServerSpec;
import reactor.netty.http.websocket.WebsocketInbound;
import reactor.netty.http.websocket.WebsocketOutbound;
import reactor.util.annotation.Nullable;

final class WebsocketServerOperations
extends HttpServerOperations
implements WebsocketInbound,
WebsocketOutbound {
    final WebSocketServerHandshaker handshaker;
    final ChannelPromise handshakerResult;
    final Sinks.One<WebSocketCloseStatus> onCloseState;
    final boolean proxyPing;
    volatile int closeSent;
    static final String INBOUND_CANCEL_LOG = "WebSocket server inbound receiver cancelled, closing Websocket.";
    static final AtomicIntegerFieldUpdater<WebsocketServerOperations> CLOSE_SENT = AtomicIntegerFieldUpdater.newUpdater(WebsocketServerOperations.class, "closeSent");

    WebsocketServerOperations(String wsUrl, WebsocketServerSpec websocketServerSpec, HttpServerOperations replaced) {
        super(replaced);
        this.proxyPing = websocketServerSpec.handlePing();
        Channel channel = replaced.channel();
        this.onCloseState = Sinks.unsafe().one();
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, websocketServerSpec.protocols(), true, websocketServerSpec.maxFramePayloadLength());
        this.handshaker = wsFactory.newHandshaker(replaced.nettyRequest);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedVersionResponse(channel);
            this.handshakerResult = null;
        } else {
            this.removeHandler("reactor.left.httpTrafficHandler");
            this.removeHandler("reactor.left.accessLogHandler");
            ChannelHandler handler = channel.pipeline().get("reactor.left.httpMetricsHandler");
            if (handler != null) {
                this.replaceHandler("reactor.left.httpMetricsHandler", new WebsocketHttpServerMetricsHandler((AbstractHttpServerMetricsHandler)handler));
            }
            this.handshakerResult = channel.newPromise();
            DefaultFullHttpRequest request = new DefaultFullHttpRequest(replaced.version(), replaced.method(), replaced.uri());
            request.headers().set(replaced.nettyRequest.headers());
            if (websocketServerSpec.compress()) {
                this.removeHandler("reactor.left.compressionHandler");
                WebSocketServerCompressionHandler wsServerCompressionHandler = new WebSocketServerCompressionHandler();
                try {
                    ChannelPipeline pipeline = channel.pipeline();
                    wsServerCompressionHandler.channelRead(pipeline.context("reactor.right.reactiveBridge"), request);
                    String baseName = null;
                    if (pipeline.get("reactor.left.httpCodec") != null) {
                        baseName = "reactor.left.httpCodec";
                    } else {
                        HttpServerCodec httpServerCodec = pipeline.get(HttpServerCodec.class);
                        if (httpServerCodec != null) {
                            baseName = pipeline.context(httpServerCodec).name();
                        }
                    }
                    pipeline.addAfter(baseName, "reactor.left.wsCompressionHandler", wsServerCompressionHandler);
                }
                catch (Throwable e) {
                    log.error(ReactorNetty.format(this.channel(), ""), e);
                }
            }
            this.handshaker.handshake(channel, (HttpRequest)request, replaced.responseHeaders.remove(HttpHeaderNames.TRANSFER_ENCODING), this.handshakerResult).addListener((GenericFutureListener<? extends Future<? super Void>>)((GenericFutureListener<Future>)f -> {
                if (replaced.rebind(this)) {
                    this.markPersistent(false);
                    channel.read();
                } else if (log.isDebugEnabled()) {
                    log.debug(ReactorNetty.format(channel, "Cannot bind WebsocketServerOperations after the handshake."));
                }
            }));
        }
    }

    @Override
    public NettyOutbound send(Publisher<? extends ByteBuf> dataStream) {
        return this.sendObject(Flux.from(dataStream).map(bytebufToWebsocketFrame));
    }

    @Override
    public HttpHeaders headers() {
        return this.requestHeaders();
    }

    @Override
    public void onInboundNext(ChannelHandlerContext ctx, Object frame) {
        if (frame instanceof CloseWebSocketFrame && ((CloseWebSocketFrame)frame).isFinalFragment()) {
            CloseWebSocketFrame closeFrame;
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "CloseWebSocketFrame detected. Closing Websocket"));
            }
            if ((closeFrame = new CloseWebSocketFrame(true, ((CloseWebSocketFrame)frame).rsv(), ((CloseWebSocketFrame)frame).content())).statusCode() != -1) {
                this.sendCloseNow(closeFrame, f -> this.terminate());
            } else {
                this.sendCloseNow(closeFrame, WebSocketCloseStatus.EMPTY, f -> this.terminate());
            }
            return;
        }
        if (!this.proxyPing && frame instanceof PingWebSocketFrame) {
            ctx.writeAndFlush(new PongWebSocketFrame(((PingWebSocketFrame)frame).content()));
            ctx.read();
            return;
        }
        if (frame != LastHttpContent.EMPTY_LAST_CONTENT) {
            super.onInboundNext(ctx, frame);
        }
    }

    @Override
    protected void onOutboundComplete() {
    }

    @Override
    protected void onOutboundError(Throwable err) {
        if (this.channel().isActive()) {
            if (log.isDebugEnabled()) {
                log.debug(ReactorNetty.format(this.channel(), "Outbound error happened"), err);
            }
            this.sendCloseNow(new CloseWebSocketFrame(WebSocketCloseStatus.PROTOCOL_ERROR), f -> this.terminate());
        }
    }

    @Override
    protected void onInboundCancel() {
        if (log.isDebugEnabled()) {
            log.debug(ReactorNetty.format(this.channel(), INBOUND_CANCEL_LOG));
        }
        this.sendCloseNow(new CloseWebSocketFrame(), WebSocketCloseStatus.ABNORMAL_CLOSURE, f -> this.terminate());
    }

    @Override
    public Mono<Void> sendClose() {
        return this.sendClose(new CloseWebSocketFrame());
    }

    @Override
    public Mono<Void> sendClose(int rsv) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv));
    }

    @Override
    public Mono<Void> sendClose(int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(statusCode, reasonText));
    }

    @Override
    public Mono<Void> sendClose(int rsv, int statusCode, @Nullable String reasonText) {
        return this.sendClose(new CloseWebSocketFrame(true, rsv, statusCode, reasonText));
    }

    @Override
    public Mono<WebSocketCloseStatus> receiveCloseStatus() {
        return this.onCloseState.asMono().or(this.onTerminate());
    }

    Mono<Void> sendClose(CloseWebSocketFrame frame) {
        if (CLOSE_SENT.get(this) == 0) {
            return FutureMono.deferFuture(() -> {
                if (CLOSE_SENT.getAndSet(this, 1) == 0) {
                    this.discard();
                    this.onCloseState.tryEmitValue(new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()));
                    return this.channel().writeAndFlush(frame).addListener(ChannelFutureListener.CLOSE);
                }
                frame.release();
                return this.channel().newSucceededFuture();
            }).doOnCancel(() -> ReactorNetty.safeRelease(frame));
        }
        frame.release();
        return Mono.empty();
    }

    void sendCloseNow(CloseWebSocketFrame frame, ChannelFutureListener listener) {
        this.sendCloseNow(frame, new WebSocketCloseStatus(frame.statusCode(), frame.reasonText()), listener);
    }

    void sendCloseNow(CloseWebSocketFrame frame, WebSocketCloseStatus closeStatus, ChannelFutureListener listener) {
        if (!frame.isFinalFragment()) {
            this.channel().writeAndFlush(frame);
            return;
        }
        if (CLOSE_SENT.getAndSet(this, 1) == 0) {
            this.onCloseState.tryEmitValue(closeStatus);
            this.channel().writeAndFlush(frame).addListener(listener);
        } else {
            frame.release();
        }
    }

    @Override
    public boolean isWebsocket() {
        return true;
    }

    @Override
    @Nullable
    public String selectedSubprotocol() {
        return this.handshaker.selectedSubprotocol();
    }

    static final class WebsocketHttpServerMetricsHandler
    extends AbstractHttpServerMetricsHandler {
        final HttpServerMetricsRecorder recorder;

        WebsocketHttpServerMetricsHandler(AbstractHttpServerMetricsHandler copy) {
            super(copy);
            this.recorder = copy.recorder();
        }

        @Override
        public void channelActive(ChannelHandlerContext ctx) {
            ctx.fireChannelActive();
        }

        @Override
        public void channelInactive(ChannelHandlerContext ctx) {
            try {
                if (this.channelOpened && this.recorder instanceof MicrometerHttpServerMetricsRecorder) {
                    this.channelOpened = false;
                    this.recorder.recordServerConnectionClosed(ctx.channel().localAddress());
                }
                if (this.channelActivated) {
                    this.channelActivated = false;
                    this.recorder.recordServerConnectionInactive(ctx.channel().localAddress());
                }
            }
            catch (RuntimeException e) {
                if (HttpServerOperations.log.isWarnEnabled()) {
                    HttpServerOperations.log.warn(ReactorNetty.format(ctx.channel(), "Exception caught while recording metrics."), e);
                }
            }
            finally {
                ctx.fireChannelInactive();
            }
        }

        @Override
        public void channelRead(ChannelHandlerContext ctx, Object msg) {
            ctx.fireChannelRead(msg);
        }

        @Override
        public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
            ctx.fireExceptionCaught(cause);
        }

        @Override
        public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) {
            ctx.write(msg, promise);
        }

        @Override
        public HttpServerMetricsRecorder recorder() {
            return this.recorder;
        }
    }
}

