/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;

public class GenericAppenderFactory
implements FileAppenderFactory<Record> {
    private final Schema schema;
    private final PartitionSpec spec;
    private final int[] equalityFieldIds;
    private final Schema eqDeleteRowSchema;
    private final Schema posDeleteRowSchema;
    private final Map<String, String> config = Maps.newHashMap();

    public GenericAppenderFactory(Schema schema) {
        this(schema, PartitionSpec.unpartitioned(), null, null, null);
    }

    public GenericAppenderFactory(Schema schema, PartitionSpec spec) {
        this(schema, spec, null, null, null);
    }

    public GenericAppenderFactory(Schema schema, PartitionSpec spec, int[] equalityFieldIds, Schema eqDeleteRowSchema, Schema posDeleteRowSchema) {
        this.schema = schema;
        this.spec = spec;
        this.equalityFieldIds = equalityFieldIds;
        this.eqDeleteRowSchema = eqDeleteRowSchema;
        this.posDeleteRowSchema = posDeleteRowSchema;
    }

    public GenericAppenderFactory set(String property, String value) {
        this.config.put(property, value);
        return this;
    }

    public GenericAppenderFactory setAll(Map<String, String> properties) {
        this.config.putAll(properties);
        return this;
    }

    public FileAppender<Record> newAppender(OutputFile outputFile, FileFormat fileFormat) {
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.config);
        try {
            switch (fileFormat) {
                case AVRO: {
                    return Avro.write((OutputFile)outputFile).schema(this.schema).createWriterFunc(DataWriter::create).metricsConfig(metricsConfig).setAll(this.config).overwrite().build();
                }
                case PARQUET: {
                    return Parquet.write((OutputFile)outputFile).schema(this.schema).createWriterFunc(GenericParquetWriter::buildWriter).setAll(this.config).metricsConfig(metricsConfig).overwrite().build();
                }
                case ORC: {
                    return ORC.write((OutputFile)outputFile).schema(this.schema).createWriterFunc(GenericOrcWriter::buildWriter).setAll(this.config).metricsConfig(metricsConfig).overwrite().build();
                }
            }
            throw new UnsupportedOperationException("Cannot write unknown file format: " + fileFormat);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public org.apache.iceberg.io.DataWriter<Record> newDataWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        return new org.apache.iceberg.io.DataWriter(this.newAppender(file.encryptingOutputFile(), format), format, file.encryptingOutputFile().location(), this.spec, partition, file.keyMetadata());
    }

    public EqualityDeleteWriter<Record> newEqDeleteWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        Preconditions.checkState((this.equalityFieldIds != null && this.equalityFieldIds.length > 0 ? 1 : 0) != 0, (Object)"Equality field ids shouldn't be null or empty when creating equality-delete writer");
        Preconditions.checkNotNull((Object)this.eqDeleteRowSchema, (Object)"Equality delete row schema shouldn't be null when creating equality-delete writer");
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.config);
        try {
            switch (format) {
                case AVRO: {
                    return Avro.writeDeletes((OutputFile)file.encryptingOutputFile()).createWriterFunc(DataWriter::create).withPartition(partition).overwrite().setAll(this.config).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
                case PARQUET: {
                    return Parquet.writeDeletes((OutputFile)file.encryptingOutputFile()).createWriterFunc(GenericParquetWriter::buildWriter).withPartition(partition).overwrite().setAll(this.config).metricsConfig(metricsConfig).rowSchema(this.eqDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).equalityFieldIds(this.equalityFieldIds).buildEqualityWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write equality-deletes for unsupported file format: " + format);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public PositionDeleteWriter<Record> newPosDeleteWriter(EncryptedOutputFile file, FileFormat format, StructLike partition) {
        MetricsConfig metricsConfig = MetricsConfig.fromProperties(this.config);
        try {
            switch (format) {
                case AVRO: {
                    return Avro.writeDeletes((OutputFile)file.encryptingOutputFile()).createWriterFunc(DataWriter::create).withPartition(partition).overwrite().setAll(this.config).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).buildPositionWriter();
                }
                case PARQUET: {
                    return Parquet.writeDeletes((OutputFile)file.encryptingOutputFile()).createWriterFunc(GenericParquetWriter::buildWriter).withPartition(partition).overwrite().setAll(this.config).metricsConfig(metricsConfig).rowSchema(this.posDeleteRowSchema).withSpec(this.spec).withKeyMetadata(file.keyMetadata()).buildPositionWriter();
                }
            }
            throw new UnsupportedOperationException("Cannot write pos-deletes for unsupported file format: " + format);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

