/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.iceberg.Accessor;
import org.apache.iceberg.ContentFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.deletes.Deletes;
import org.apache.iceberg.deletes.PositionDeleteIndex;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.relocated.com.google.common.collect.Multimap;
import org.apache.iceberg.relocated.com.google.common.collect.Multimaps;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.StructProjection;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;

public abstract class DeleteFilter<T> {
    private static final long DEFAULT_SET_FILTER_THRESHOLD = 100000L;
    private static final Schema POS_DELETE_SCHEMA = new Schema(new Types.NestedField[]{MetadataColumns.DELETE_FILE_PATH, MetadataColumns.DELETE_FILE_POS});
    private final long setFilterThreshold;
    private final String filePath;
    private final List<DeleteFile> posDeletes;
    private final List<DeleteFile> eqDeletes;
    private final Schema requiredSchema;
    private final Accessor<StructLike> posAccessor;
    private final boolean hasIsDeletedColumn;
    private final int isDeletedColumnPosition;
    private PositionDeleteIndex deleteRowPositions = null;
    private List<Predicate<T>> isInDeleteSets = null;
    private Predicate<T> eqDeleteRows = null;

    protected DeleteFilter(String filePath, List<DeleteFile> deletes, Schema tableSchema, Schema requestedSchema) {
        this.setFilterThreshold = 100000L;
        this.filePath = filePath;
        ImmutableList.Builder posDeleteBuilder = ImmutableList.builder();
        ImmutableList.Builder eqDeleteBuilder = ImmutableList.builder();
        block4: for (DeleteFile delete : deletes) {
            switch (delete.content()) {
                case POSITION_DELETES: {
                    posDeleteBuilder.add((Object)delete);
                    continue block4;
                }
                case EQUALITY_DELETES: {
                    eqDeleteBuilder.add((Object)delete);
                    continue block4;
                }
            }
            throw new UnsupportedOperationException("Unknown delete file content: " + delete.content());
        }
        this.posDeletes = posDeleteBuilder.build();
        this.eqDeletes = eqDeleteBuilder.build();
        this.requiredSchema = DeleteFilter.fileProjection(tableSchema, requestedSchema, this.posDeletes, this.eqDeletes);
        this.posAccessor = this.requiredSchema.accessorForField(MetadataColumns.ROW_POSITION.fieldId());
        this.hasIsDeletedColumn = this.requiredSchema.findField(MetadataColumns.IS_DELETED.fieldId()) != null;
        this.isDeletedColumnPosition = this.requiredSchema.columns().indexOf(MetadataColumns.IS_DELETED);
    }

    protected int columnIsDeletedPosition() {
        return this.isDeletedColumnPosition;
    }

    public Schema requiredSchema() {
        return this.requiredSchema;
    }

    public boolean hasPosDeletes() {
        return !this.posDeletes.isEmpty();
    }

    public boolean hasEqDeletes() {
        return !this.eqDeletes.isEmpty();
    }

    Accessor<StructLike> posAccessor() {
        return this.posAccessor;
    }

    protected abstract StructLike asStructLike(T var1);

    protected abstract InputFile getInputFile(String var1);

    protected long pos(T record) {
        return (Long)this.posAccessor.get((Object)this.asStructLike(record));
    }

    public CloseableIterable<T> filter(CloseableIterable<T> records) {
        return this.applyEqDeletes(this.applyPosDeletes(records));
    }

    private List<Predicate<T>> applyEqDeletes() {
        if (this.isInDeleteSets != null) {
            return this.isInDeleteSets;
        }
        this.isInDeleteSets = Lists.newArrayList();
        if (this.eqDeletes.isEmpty()) {
            return this.isInDeleteSets;
        }
        Multimap filesByDeleteIds = Multimaps.newMultimap((Map)Maps.newHashMap(), Lists::newArrayList);
        for (DeleteFile deleteFile : this.eqDeletes) {
            filesByDeleteIds.put((Object)Sets.newHashSet((Iterable)deleteFile.equalityFieldIds()), (Object)deleteFile);
        }
        for (Map.Entry entry : filesByDeleteIds.asMap().entrySet()) {
            Set ids = (Set)entry.getKey();
            Iterable deletes = (Iterable)entry.getValue();
            Schema deleteSchema = TypeUtil.select((Schema)this.requiredSchema, (Set)ids);
            InternalRecordWrapper wrapper = new InternalRecordWrapper(deleteSchema.asStruct());
            StructProjection projectRow = StructProjection.create((Schema)this.requiredSchema, (Schema)deleteSchema);
            Iterable deleteRecords = Iterables.transform((Iterable)deletes, delete -> this.openDeletes((DeleteFile)delete, deleteSchema));
            CloseableIterable records = CloseableIterable.transform((CloseableIterable)CloseableIterable.concat((Iterable)deleteRecords), Record::copy);
            StructLikeSet deleteSet = Deletes.toEqualitySet((CloseableIterable)CloseableIterable.transform((CloseableIterable)records, wrapper::copyFor), (Types.StructType)deleteSchema.asStruct());
            Predicate<Object> isInDeleteSet = record -> deleteSet.contains((Object)projectRow.wrap(this.asStructLike(record)));
            this.isInDeleteSets.add(isInDeleteSet);
        }
        return this.isInDeleteSets;
    }

    public CloseableIterable<T> findEqualityDeleteRows(CloseableIterable<T> records) {
        Predicate<Object> deletedRows = this.applyEqDeletes().stream().reduce(Predicate::or).orElse(t -> false);
        return CloseableIterable.filter(records, deletedRows);
    }

    private CloseableIterable<T> applyEqDeletes(CloseableIterable<T> records) {
        Predicate<Object> isEqDeleted = this.applyEqDeletes().stream().reduce(Predicate::or).orElse(t -> false);
        return this.createDeleteIterable(records, isEqDeleted);
    }

    protected void markRowDeleted(T item) {
        throw new UnsupportedOperationException(this.getClass().getName() + " does not implement markRowDeleted");
    }

    public Predicate<T> eqDeletedRowFilter() {
        if (this.eqDeleteRows == null) {
            this.eqDeleteRows = this.applyEqDeletes().stream().map(Predicate::negate).reduce(Predicate::and).orElse(t -> true);
        }
        return this.eqDeleteRows;
    }

    public PositionDeleteIndex deletedRowPositions() {
        if (this.posDeletes.isEmpty()) {
            return null;
        }
        if (this.deleteRowPositions == null) {
            List deletes = Lists.transform(this.posDeletes, this::openPosDeletes);
            this.deleteRowPositions = Deletes.toPositionIndex((CharSequence)this.filePath, (List)deletes);
        }
        return this.deleteRowPositions;
    }

    private CloseableIterable<T> applyPosDeletes(CloseableIterable<T> records) {
        if (this.posDeletes.isEmpty()) {
            return records;
        }
        List deletes = Lists.transform(this.posDeletes, this::openPosDeletes);
        if (this.posDeletes.stream().mapToLong(ContentFile::recordCount).sum() < this.setFilterThreshold) {
            PositionDeleteIndex positionIndex = Deletes.toPositionIndex((CharSequence)this.filePath, (List)deletes);
            Predicate<Object> isDeleted = record -> positionIndex.isDeleted(this.pos(record));
            return this.createDeleteIterable(records, isDeleted);
        }
        return this.hasIsDeletedColumn ? Deletes.streamingMarker(records, this::pos, (CloseableIterable)Deletes.deletePositions((CharSequence)this.filePath, (List)deletes), this::markRowDeleted) : Deletes.streamingFilter(records, this::pos, (CloseableIterable)Deletes.deletePositions((CharSequence)this.filePath, (List)deletes));
    }

    private CloseableIterable<T> createDeleteIterable(CloseableIterable<T> records, Predicate<T> isDeleted) {
        return this.hasIsDeletedColumn ? Deletes.markDeleted(records, isDeleted, this::markRowDeleted) : Deletes.filterDeleted(records, isDeleted);
    }

    private CloseableIterable<Record> openPosDeletes(DeleteFile file) {
        return this.openDeletes(file, POS_DELETE_SCHEMA);
    }

    private CloseableIterable<Record> openDeletes(DeleteFile deleteFile, Schema deleteSchema) {
        InputFile input = this.getInputFile(deleteFile.path().toString());
        switch (deleteFile.format()) {
            case AVRO: {
                return Avro.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(DataReader::create).build();
            }
            case PARQUET: {
                Parquet.ReadBuilder builder = Parquet.read((InputFile)input).project(deleteSchema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)deleteSchema, (MessageType)fileSchema));
                if (deleteFile.content() == FileContent.POSITION_DELETES) {
                    builder.filter((Expression)Expressions.equal((String)MetadataColumns.DELETE_FILE_PATH.name(), (Object)this.filePath));
                }
                return builder.build();
            }
            case ORC: {
                ORC.ReadBuilder orcBuilder = ORC.read((InputFile)input).project(deleteSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)deleteSchema, (TypeDescription)fileSchema));
                if (deleteFile.content() == FileContent.POSITION_DELETES) {
                    orcBuilder.filter((Expression)Expressions.equal((String)MetadataColumns.DELETE_FILE_PATH.name(), (Object)this.filePath));
                }
                return orcBuilder.build();
            }
        }
        throw new UnsupportedOperationException(String.format("Cannot read deletes, %s is not a supported format: %s", deleteFile.format().name(), deleteFile.path()));
    }

    private static Schema fileProjection(Schema tableSchema, Schema requestedSchema, List<DeleteFile> posDeletes, List<DeleteFile> eqDeletes) {
        if (posDeletes.isEmpty() && eqDeletes.isEmpty()) {
            return requestedSchema;
        }
        LinkedHashSet requiredIds = Sets.newLinkedHashSet();
        if (!posDeletes.isEmpty()) {
            requiredIds.add(MetadataColumns.ROW_POSITION.fieldId());
        }
        for (DeleteFile eqDelete : eqDeletes) {
            requiredIds.addAll(eqDelete.equalityFieldIds());
        }
        LinkedHashSet missingIds = Sets.newLinkedHashSet((Iterable)Sets.difference((Set)requiredIds, (Set)TypeUtil.getProjectedIds((Schema)requestedSchema)));
        if (missingIds.isEmpty()) {
            return requestedSchema;
        }
        ArrayList columns = Lists.newArrayList((Iterable)requestedSchema.columns());
        Iterator iterator = missingIds.iterator();
        while (iterator.hasNext()) {
            int fieldId = (Integer)iterator.next();
            if (fieldId == MetadataColumns.ROW_POSITION.fieldId() || fieldId == MetadataColumns.IS_DELETED.fieldId()) continue;
            Types.NestedField field = tableSchema.asStruct().field(fieldId);
            Preconditions.checkArgument((field != null ? 1 : 0) != 0, (String)"Cannot find required field for ID %s", (int)fieldId);
            columns.add(field);
        }
        if (missingIds.contains(MetadataColumns.ROW_POSITION.fieldId())) {
            columns.add(MetadataColumns.ROW_POSITION);
        }
        if (missingIds.contains(MetadataColumns.IS_DELETED.fieldId())) {
            columns.add(MetadataColumns.IS_DELETED);
        }
        return new Schema((List)columns);
    }
}

