/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedFiles;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.encryption.EncryptionKeyMetadata;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;

public class FileHelpers {
    private FileHelpers() {
    }

    public static Pair<DeleteFile, CharSequenceSet> writeDeleteFile(Table table, OutputFile out, List<Pair<CharSequence, Long>> deletes) throws IOException {
        return FileHelpers.writeDeleteFile(table, out, null, deletes);
    }

    public static Pair<DeleteFile, CharSequenceSet> writeDeleteFile(Table table, OutputFile out, StructLike partition, List<Pair<CharSequence, Long>> deletes) throws IOException {
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema(), table.spec());
        PositionDeleteWriter writer = factory.newPosDeleteWriter(FileHelpers.encrypt(out), format, partition);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter toClose = writer;){
            for (Pair<CharSequence, Long> delete : deletes) {
                writer.write(posDelete.set((CharSequence)delete.first(), ((Long)delete.second()).longValue(), null));
            }
        }
        return Pair.of((Object)writer.toDeleteFile(), (Object)writer.referencedDataFiles());
    }

    public static DeleteFile writeDeleteFile(Table table, OutputFile out, List<Record> deletes, Schema deleteRowSchema) throws IOException {
        return FileHelpers.writeDeleteFile(table, out, null, deletes, deleteRowSchema);
    }

    public static DeleteFile writeDeleteFile(Table table, OutputFile out, StructLike partition, List<Record> deletes, Schema deleteRowSchema) throws IOException {
        EqualityDeleteWriter writer;
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        int[] equalityFieldIds = deleteRowSchema.columns().stream().mapToInt(Types.NestedField::fieldId).toArray();
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema(), table.spec(), equalityFieldIds, deleteRowSchema, null);
        try (EqualityDeleteWriter toClose = writer = factory.newEqDeleteWriter(FileHelpers.encrypt(out), format, partition);){
            writer.write(deletes);
        }
        return writer.toDeleteFile();
    }

    public static DataFile writeDataFile(Table table, OutputFile out, List<Record> rows) throws IOException {
        FileAppender writer;
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema());
        try (FileAppender toClose = writer = factory.newAppender(out, format);){
            writer.addAll(rows);
        }
        return DataFiles.builder((PartitionSpec)table.spec()).withFormat(format).withPath(out.location()).withFileSizeInBytes(writer.length()).withSplitOffsets(writer.splitOffsets()).withMetrics(writer.metrics()).build();
    }

    public static DataFile writeDataFile(Table table, OutputFile out, StructLike partition, List<Record> rows) throws IOException {
        FileAppender writer;
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema(), table.spec());
        try (FileAppender toClose = writer = factory.newAppender(out, format);){
            writer.addAll(rows);
        }
        return DataFiles.builder((PartitionSpec)table.spec()).withFormat(format).withPath(out.location()).withPartition(partition).withFileSizeInBytes(writer.length()).withSplitOffsets(writer.splitOffsets()).withMetrics(writer.metrics()).build();
    }

    public static DeleteFile writePosDeleteFile(Table table, OutputFile out, StructLike partition, List<PositionDelete<?>> deletes) throws IOException {
        PositionDeleteWriter writer;
        FileFormat format = FileHelpers.defaultFormat(table.properties());
        GenericAppenderFactory factory = new GenericAppenderFactory(table.schema(), table.spec(), null, null, table.schema());
        try (PositionDeleteWriter toClose = writer = factory.newPosDeleteWriter(FileHelpers.encrypt(out), format, partition);){
            for (PositionDelete<?> delete : deletes) {
                writer.write(delete);
            }
        }
        return writer.toDeleteFile();
    }

    private static EncryptedOutputFile encrypt(OutputFile out) {
        return EncryptedFiles.encryptedOutput((OutputFile)out, (EncryptionKeyMetadata)EncryptionKeyMetadata.EMPTY);
    }

    private static FileFormat defaultFormat(Map<String, String> properties) {
        String formatString = properties.getOrDefault("write.format.default", "parquet");
        return FileFormat.fromString((String)formatString);
    }
}

