/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetMetricsRowGroupFilter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestMetricsRowGroupFilterTypes {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"boolean", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)2, (String)"int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"long", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"float", (Type)Types.FloatType.get()), Types.NestedField.optional((int)5, (String)"double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)6, (String)"date", (Type)Types.DateType.get()), Types.NestedField.optional((int)7, (String)"time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)8, (String)"timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)9, (String)"timestamptz", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)10, (String)"string", (Type)Types.StringType.get()), Types.NestedField.optional((int)11, (String)"uuid", (Type)Types.UUIDType.get()), Types.NestedField.optional((int)12, (String)"fixed", (Type)Types.FixedType.ofLength((int)4)), Types.NestedField.optional((int)13, (String)"binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)14, (String)"int_decimal", (Type)Types.DecimalType.of((int)8, (int)2)), Types.NestedField.optional((int)15, (String)"long_decimal", (Type)Types.DecimalType.of((int)14, (int)2)), Types.NestedField.optional((int)16, (String)"fixed_decimal", (Type)Types.DecimalType.of((int)31, (int)2))});
    private static final Schema FILE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"_boolean", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)2, (String)"_int", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"_long", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"_float", (Type)Types.FloatType.get()), Types.NestedField.optional((int)5, (String)"_double", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)6, (String)"_date", (Type)Types.DateType.get()), Types.NestedField.optional((int)7, (String)"_time", (Type)Types.TimeType.get()), Types.NestedField.optional((int)8, (String)"_timestamp", (Type)Types.TimestampType.withoutZone()), Types.NestedField.optional((int)9, (String)"_timestamptz", (Type)Types.TimestampType.withZone()), Types.NestedField.optional((int)10, (String)"_string", (Type)Types.StringType.get()), Types.NestedField.optional((int)11, (String)"_uuid", (Type)Types.UUIDType.get()), Types.NestedField.optional((int)12, (String)"_fixed", (Type)Types.FixedType.ofLength((int)4)), Types.NestedField.optional((int)13, (String)"_binary", (Type)Types.BinaryType.get()), Types.NestedField.optional((int)14, (String)"_int_decimal", (Type)Types.DecimalType.of((int)8, (int)2)), Types.NestedField.optional((int)15, (String)"_long_decimal", (Type)Types.DecimalType.of((int)14, (int)2)), Types.NestedField.optional((int)16, (String)"_fixed_decimal", (Type)Types.DecimalType.of((int)31, (int)2))});
    private static final File ORC_FILE = new File("/tmp/stats-row-group-filter-types-test.orc");
    private static final File PARQUET_FILE = new File("/tmp/stats-row-group-filter-types-test.parquet");
    private static MessageType parquetSchema = null;
    private static BlockMetaData rowGroupMetadata = null;
    private static final UUID uuid = UUID.randomUUID();
    private static final LocalDate date = LocalDate.parse("2018-06-29", DateTimeFormatter.ISO_LOCAL_DATE);
    private static final LocalTime time = LocalTime.parse("10:02:34.000000", DateTimeFormatter.ISO_LOCAL_TIME);
    private static final OffsetDateTime timestamptz = OffsetDateTime.parse("2018-06-29T10:02:34.000000+00:00", DateTimeFormatter.ISO_DATE_TIME);
    private static final LocalDateTime timestamp = LocalDateTime.parse("2018-06-29T10:02:34.000000", DateTimeFormatter.ISO_LOCAL_DATE_TIME);
    private static final byte[] fixed = "abcd".getBytes(StandardCharsets.UTF_8);
    private final FileFormat format;
    private final String column;
    private final Object readValue;
    private final Object skipValue;

    @Before
    public void createInputFile() throws IOException {
        ArrayList records = Lists.newArrayList();
        for (int i = 0; i < 50; ++i) {
            GenericRecord record = GenericRecord.create((Schema)FILE_SCHEMA);
            record.setField("_boolean", (Object)false);
            record.setField("_int", (Object)i);
            record.setField("_long", (Object)(5000000000L + (long)i));
            record.setField("_float", (Object)Float.valueOf((float)(100 - i) / 100.0f + 1.0f));
            record.setField("_double", (Object)((double)i / 100.0 + 2.0));
            record.setField("_date", (Object)date);
            record.setField("_time", (Object)time);
            record.setField("_timestamp", (Object)timestamp);
            record.setField("_timestamptz", (Object)timestamptz);
            record.setField("_string", (Object)"tapir");
            record.setField("_fixed", (Object)fixed);
            record.setField("_binary", (Object)ByteBuffer.wrap("xyz".getBytes(StandardCharsets.UTF_8)));
            record.setField("_int_decimal", (Object)new BigDecimal("77.77"));
            record.setField("_long_decimal", (Object)new BigDecimal("88.88"));
            record.setField("_fixed_decimal", (Object)new BigDecimal("99.99"));
            records.add(record);
        }
        switch (this.format) {
            case ORC: {
                this.createOrcInputFile(records);
                break;
            }
            case PARQUET: {
                this.createParquetInputFile(records);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Row group filter types tests not supported for " + this.format);
            }
        }
    }

    public void createOrcInputFile(List<Record> records) throws IOException {
        if (ORC_FILE.exists()) {
            Assert.assertTrue((boolean)ORC_FILE.delete());
        }
        OutputFile outFile = Files.localOutput((File)ORC_FILE);
        try (FileAppender appender = ORC.write((OutputFile)outFile).schema(FILE_SCHEMA).createWriterFunc(GenericOrcWriter::buildWriter).build();){
            appender.addAll(records);
        }
        InputFile inFile = Files.localInput((File)ORC_FILE);
        try (Reader reader = OrcFile.createReader((Path)new Path(inFile.location()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)new Configuration()));){
            Assert.assertEquals((String)"Should create only one stripe", (long)1L, (long)reader.getStripes().size());
        }
        ORC_FILE.deleteOnExit();
    }

    public void createParquetInputFile(List<Record> records) throws IOException {
        if (PARQUET_FILE.exists()) {
            Assert.assertTrue((boolean)PARQUET_FILE.delete());
        }
        OutputFile outFile = Files.localOutput((File)PARQUET_FILE);
        try (FileAppender appender = Parquet.write((OutputFile)outFile).schema(FILE_SCHEMA).createWriterFunc(GenericParquetWriter::buildWriter).build();){
            appender.addAll(records);
        }
        InputFile inFile = Files.localInput((File)PARQUET_FILE);
        try (ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)this.parquetInputFile(inFile));){
            Assert.assertEquals((String)"Should create only one row group", (long)1L, (long)reader.getRowGroups().size());
            rowGroupMetadata = (BlockMetaData)reader.getRowGroups().get(0);
            parquetSchema = reader.getFileMetaData().getSchema();
        }
        PARQUET_FILE.deleteOnExit();
    }

    @Parameterized.Parameters(name="format = {0} column = {1} readValue = {2} skipValue = {3}")
    public static Object[][] parameters() {
        return new Object[][]{{"parquet", "boolean", false, true}, {"parquet", "int", 5, 55}, {"parquet", "long", 5000000049L, 5000L}, {"parquet", "float", Float.valueOf(1.97f), Float.valueOf(2.11f)}, {"parquet", "double", 2.11, 1.97}, {"parquet", "date", "2018-06-29", "2018-05-03"}, {"parquet", "time", "10:02:34.000000", "10:02:34.000001"}, {"parquet", "timestamp", "2018-06-29T10:02:34.000000", "2018-06-29T15:02:34.000000"}, {"parquet", "timestamptz", "2018-06-29T10:02:34.000000+00:00", "2018-06-29T10:02:34.000000-07:00"}, {"parquet", "string", "tapir", "monthly"}, {"parquet", "fixed", "abcd".getBytes(StandardCharsets.UTF_8), new byte[]{0, 1, 2, 3}}, {"parquet", "binary", "xyz".getBytes(StandardCharsets.UTF_8), new byte[]{0, 1, 2, 3, 4, 5}}, {"parquet", "int_decimal", "77.77", "12.34"}, {"parquet", "long_decimal", "88.88", "12.34"}, {"parquet", "fixed_decimal", "99.99", "12.34"}, {"orc", "boolean", false, true}, {"orc", "int", 5, 55}, {"orc", "long", 5000000049L, 5000L}, {"orc", "float", Float.valueOf(1.97f), Float.valueOf(2.11f)}, {"orc", "double", 2.11, 1.97}, {"orc", "date", "2018-06-29", "2018-05-03"}, {"orc", "time", "10:02:34.000000", "10:02:34.000001"}, {"orc", "timestamp", "2018-06-29T10:02:34.000000", "2018-06-29T15:02:34.000000"}, {"orc", "timestamptz", "2018-06-29T10:02:34.000000+00:00", "2018-06-29T10:02:34.000000-07:00"}, {"orc", "string", "tapir", "monthly"}, {"orc", "int_decimal", "77.77", "12.34"}, {"orc", "long_decimal", "88.88", "12.34"}, {"orc", "fixed_decimal", "99.99", "12.34"}};
    }

    public TestMetricsRowGroupFilterTypes(String format, String column, Object readValue, Object skipValue) {
        this.format = FileFormat.fromString((String)format);
        this.column = column;
        this.readValue = readValue;
        this.skipValue = skipValue;
    }

    @Test
    public void testEq() {
        boolean shouldRead = this.shouldRead(this.readValue);
        Assert.assertTrue((String)("Should read: value is in the row group: " + this.readValue), (boolean)shouldRead);
        shouldRead = this.shouldRead(this.skipValue);
        Assert.assertFalse((String)("Should skip: value is not in the row group: " + this.skipValue), (boolean)shouldRead);
    }

    private boolean shouldRead(Object value) {
        switch (this.format) {
            case ORC: {
                return this.shouldReadOrc(value);
            }
            case PARQUET: {
                return this.shouldReadParquet(value);
            }
        }
        throw new UnsupportedOperationException("Row group filter types tests not supported for " + this.format);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldReadOrc(Object value) {
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)ORC_FILE)).project(SCHEMA).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)SCHEMA, (TypeDescription)fileSchema)).filter((Expression)Expressions.equal((String)this.column, (Object)value)).build();){
            boolean bl = Lists.newArrayList((Iterable)reader).size() > 0;
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean shouldReadParquet(Object value) {
        return new ParquetMetricsRowGroupFilter(SCHEMA, (Expression)Expressions.equal((String)this.column, (Object)value)).shouldRead(parquetSchema, rowGroupMetadata);
    }

    private org.apache.parquet.io.InputFile parquetInputFile(final InputFile inFile) {
        return new org.apache.parquet.io.InputFile(){

            public long getLength() throws IOException {
                return inFile.getLength();
            }

            public SeekableInputStream newStream() throws IOException {
                final org.apache.iceberg.io.SeekableInputStream stream = inFile.newStream();
                return new DelegatingSeekableInputStream((InputStream)stream){

                    public long getPos() throws IOException {
                        return stream.getPos();
                    }

                    public void seek(long newPos) throws IOException {
                        stream.seek(newPos);
                    }
                };
            }
        };
    }
}

