/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.avro.AvroRuntimeException;
import org.apache.avro.message.BadHeaderException;
import org.apache.avro.message.MessageDecoder;
import org.apache.avro.message.MissingSchemaException;
import org.apache.avro.message.SchemaStore;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.IcebergDecoder;
import org.apache.iceberg.data.avro.IcebergEncoder;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Ordering;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Test;

public class TestSingleMessageEncoding {
    private static final Schema SCHEMA_V1 = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)1, (String)"msg", (Type)Types.StringType.get())});
    private static final List<Record> V1_RECORDS = Arrays.asList(TestSingleMessageEncoding.v1Record(1, "m-1"), TestSingleMessageEncoding.v1Record(2, "m-2"), TestSingleMessageEncoding.v1Record(4, "m-4"), TestSingleMessageEncoding.v1Record(6, "m-6"));
    private static final Schema SCHEMA_V2 = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"message", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.DoubleType.get())});
    private static final List<Record> V2_RECORDS = Arrays.asList(TestSingleMessageEncoding.v2Record(3L, "m-3", 12.3), TestSingleMessageEncoding.v2Record(5L, "m-5", 23.4), TestSingleMessageEncoding.v2Record(7L, "m-7", 34.5), TestSingleMessageEncoding.v2Record(8L, "m-8", 35.6));

    private static Record v1Record(int id, String msg) {
        GenericRecord rec = GenericRecord.create((Types.StructType)SCHEMA_V1.asStruct());
        rec.setField("id", (Object)id);
        rec.setField("msg", (Object)msg);
        return rec;
    }

    private static Record v2Record(long id, String message, Double data) {
        GenericRecord rec = GenericRecord.create((Types.StructType)SCHEMA_V2.asStruct());
        rec.setField("id", (Object)id);
        rec.setField("message", (Object)message);
        rec.setField("data", (Object)data);
        return rec;
    }

    @Test
    public void testByteBufferRoundTrip() throws Exception {
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V2);
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V2);
        Record copy = (Record)decoder.decode(encoder.encode((Object)V2_RECORDS.get(0)));
        Assert.assertTrue((String)"Copy should not be the same object", (copy != V2_RECORDS.get(0) ? 1 : 0) != 0);
        Assert.assertEquals((String)"Record should be identical after round-trip", (Object)V2_RECORDS.get(0), (Object)copy);
    }

    @Test
    public void testSchemaEvolution() throws Exception {
        ArrayList buffers = Lists.newArrayList();
        List records = Ordering.usingToString().sortedCopy(Iterables.concat(V1_RECORDS, V2_RECORDS));
        IcebergEncoder v1Encoder = new IcebergEncoder(SCHEMA_V1);
        IcebergEncoder v2Encoder = new IcebergEncoder(SCHEMA_V2);
        for (Record record : records) {
            if (record.struct() == SCHEMA_V1.asStruct()) {
                buffers.add(v1Encoder.encode((Object)record));
                continue;
            }
            buffers.add(v2Encoder.encode((Object)record));
        }
        HashSet allAsV2 = Sets.newHashSet(V2_RECORDS);
        allAsV2.add(TestSingleMessageEncoding.v2Record(1L, "m-1", null));
        allAsV2.add(TestSingleMessageEncoding.v2Record(2L, "m-2", null));
        allAsV2.add(TestSingleMessageEncoding.v2Record(4L, "m-4", null));
        allAsV2.add(TestSingleMessageEncoding.v2Record(6L, "m-6", null));
        IcebergDecoder v2Decoder = new IcebergDecoder(SCHEMA_V2);
        v2Decoder.addSchema(SCHEMA_V1);
        HashSet decodedUsingV2 = Sets.newHashSet();
        for (ByteBuffer buffer : buffers) {
            decodedUsingV2.add((Record)v2Decoder.decode(buffer));
        }
        Assert.assertEquals((Object)allAsV2, (Object)decodedUsingV2);
    }

    @Test
    public void testCompatibleReadFailsWithoutSchema() throws Exception {
        IcebergEncoder v1Encoder = new IcebergEncoder(SCHEMA_V1);
        IcebergDecoder v2Decoder = new IcebergDecoder(SCHEMA_V2);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(3));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSingleMessageEncoding.lambda$testCompatibleReadFailsWithoutSchema$0((MessageDecoder)v2Decoder, v1Buffer)).isInstanceOf(MissingSchemaException.class)).hasMessageContaining("Cannot resolve schema for fingerprint");
    }

    @Test
    public void testCompatibleReadWithSchema() throws Exception {
        IcebergEncoder v1Encoder = new IcebergEncoder(SCHEMA_V1);
        IcebergDecoder v2Decoder = new IcebergDecoder(SCHEMA_V2);
        v2Decoder.addSchema(SCHEMA_V1);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(3));
        Record record = (Record)v2Decoder.decode(v1Buffer);
        Assert.assertEquals((Object)TestSingleMessageEncoding.v2Record(6L, "m-6", null), (Object)record);
    }

    @Test
    public void testCompatibleReadWithSchemaFromLookup() throws Exception {
        IcebergEncoder v1Encoder = new IcebergEncoder(SCHEMA_V1);
        SchemaStore.Cache schemaCache = new SchemaStore.Cache();
        schemaCache.addSchema(AvroSchemaUtil.convert((Schema)SCHEMA_V1, (String)"table"));
        IcebergDecoder v2Decoder = new IcebergDecoder(SCHEMA_V2, (SchemaStore)schemaCache);
        ByteBuffer v1Buffer = v1Encoder.encode((Object)V1_RECORDS.get(2));
        Record record = (Record)v2Decoder.decode(v1Buffer);
        Assert.assertEquals((Object)TestSingleMessageEncoding.v2Record(4L, "m-4", null), (Object)record);
    }

    @Test
    public void testBufferReuse() throws Exception {
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V1, false);
        ByteBuffer b0 = encoder.encode((Object)V1_RECORDS.get(0));
        ByteBuffer b1 = encoder.encode((Object)V1_RECORDS.get(1));
        Assert.assertEquals((Object)b0.array(), (Object)b1.array());
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V1);
        Assert.assertEquals((String)"Buffer was reused, decode(b0) should be record 1", (Object)V1_RECORDS.get(1), (Object)decoder.decode(b0));
    }

    @Test
    public void testBufferCopy() throws Exception {
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V1);
        ByteBuffer b0 = encoder.encode((Object)V1_RECORDS.get(0));
        ByteBuffer b1 = encoder.encode((Object)V1_RECORDS.get(1));
        Assert.assertNotEquals((Object)b0.array(), (Object)b1.array());
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V1);
        Assert.assertEquals((String)"Buffer was copied, decode(b0) should be record 0", (Object)V1_RECORDS.get(0), (Object)decoder.decode(b0));
    }

    @Test
    public void testByteBufferMissingPayload() throws Exception {
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V2);
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.limit(12);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSingleMessageEncoding.lambda$testByteBufferMissingPayload$1((MessageDecoder)decoder, buffer)).isInstanceOf(AvroRuntimeException.class)).hasMessage("Decoding datum failed");
    }

    @Test
    public void testByteBufferMissingFullHeader() throws Exception {
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V2);
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.limit(8);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSingleMessageEncoding.lambda$testByteBufferMissingFullHeader$2((MessageDecoder)decoder, buffer)).isInstanceOf(BadHeaderException.class)).hasMessage("Not enough header bytes");
    }

    @Test
    public void testByteBufferBadMarkerByte() throws Exception {
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V2);
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.array()[0] = 0;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSingleMessageEncoding.lambda$testByteBufferBadMarkerByte$3((MessageDecoder)decoder, buffer)).isInstanceOf(BadHeaderException.class)).hasMessageContaining("Unrecognized header bytes");
    }

    @Test
    public void testByteBufferBadVersionByte() throws Exception {
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V2);
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.array()[1] = 0;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSingleMessageEncoding.lambda$testByteBufferBadVersionByte$4((MessageDecoder)decoder, buffer)).isInstanceOf(BadHeaderException.class)).hasMessageContaining("Unrecognized header bytes");
    }

    @Test
    public void testByteBufferUnknownSchema() throws Exception {
        IcebergEncoder encoder = new IcebergEncoder(SCHEMA_V2);
        IcebergDecoder decoder = new IcebergDecoder(SCHEMA_V2);
        ByteBuffer buffer = encoder.encode((Object)V2_RECORDS.get(0));
        buffer.array()[4] = 0;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> TestSingleMessageEncoding.lambda$testByteBufferUnknownSchema$5((MessageDecoder)decoder, buffer)).isInstanceOf(MissingSchemaException.class)).hasMessageContaining("Cannot resolve schema for fingerprint");
    }

    private static /* synthetic */ void lambda$testByteBufferUnknownSchema$5(MessageDecoder decoder, ByteBuffer buffer) throws Throwable {
        Record cfr_ignored_0 = (Record)decoder.decode(buffer);
    }

    private static /* synthetic */ void lambda$testByteBufferBadVersionByte$4(MessageDecoder decoder, ByteBuffer buffer) throws Throwable {
        Record cfr_ignored_0 = (Record)decoder.decode(buffer);
    }

    private static /* synthetic */ void lambda$testByteBufferBadMarkerByte$3(MessageDecoder decoder, ByteBuffer buffer) throws Throwable {
        Record cfr_ignored_0 = (Record)decoder.decode(buffer);
    }

    private static /* synthetic */ void lambda$testByteBufferMissingFullHeader$2(MessageDecoder decoder, ByteBuffer buffer) throws Throwable {
        Record cfr_ignored_0 = (Record)decoder.decode(buffer);
    }

    private static /* synthetic */ void lambda$testByteBufferMissingPayload$1(MessageDecoder decoder, ByteBuffer buffer) throws Throwable {
        Record cfr_ignored_0 = (Record)decoder.decode(buffer);
    }

    private static /* synthetic */ void lambda$testCompatibleReadFailsWithoutSchema$0(MessageDecoder v2Decoder, ByteBuffer v1Buffer) throws Throwable {
        Record cfr_ignored_0 = (Record)v2Decoder.decode(v1Buffer);
    }
}

