/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.TypeDescription;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestOrcDataWriter {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private List<Record> records;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Before
    public void createRecords() {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA);
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"data", (Object)"a")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)2L, (Object)"data", (Object)"b")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)3L, (Object)"data", (Object)"c")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)4L, (Object)"data", (Object)"d")));
        builder.add((Object)record.copy((Map)ImmutableMap.of((Object)"id", (Object)5L, (Object)"data", (Object)"e")));
        this.records = builder.build();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testDataWriter() throws IOException {
        ArrayList writtenRecords;
        OutputFile file = Files.localOutput((File)this.temp.newFile());
        SortOrder sortOrder = ((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).withOrderId(10).asc("id")).build();
        try (DataWriter dataWriter = ORC.writeData((OutputFile)file).schema(SCHEMA).createWriterFunc(GenericOrcWriter::buildWriter).overwrite().withSpec(PartitionSpec.unpartitioned()).withSortOrder(sortOrder).build();){
            for (Record record : this.records) {
                dataWriter.write((Object)record);
            }
        }
        DataFile dataFile = dataWriter.toDataFile();
        Assert.assertEquals((String)"Format should be ORC", (Object)FileFormat.ORC, (Object)dataFile.format());
        Assert.assertEquals((String)"Should be data file", (Object)FileContent.DATA, (Object)dataFile.content());
        Assert.assertEquals((String)"Record count should match", (long)this.records.size(), (long)dataFile.recordCount());
        Assert.assertEquals((String)"Partition should be empty", (long)0L, (long)dataFile.partition().size());
        Assert.assertEquals((String)"Sort order should match", (long)sortOrder.orderId(), (long)dataFile.sortOrderId().intValue());
        Assert.assertNull((String)"Key metadata should be null", (Object)dataFile.keyMetadata());
        try (CloseableIterable reader = ORC.read((InputFile)file.toInputFile()).project(SCHEMA).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)SCHEMA, (TypeDescription)fileSchema)).build();){
            writtenRecords = Lists.newArrayList((Iterable)reader);
        }
        Assert.assertEquals((String)"Written records should match", this.records, (Object)writtenRecords);
    }
}

