/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestFileWriterFactory<T>
extends WriterTestBase<T> {
    private static final int TABLE_FORMAT_VERSION = 2;
    private static final String PARTITION_VALUE = "aaa";
    private final FileFormat fileFormat;
    private final boolean partitioned;
    private final List<T> dataRows;
    private StructLike partition = null;
    private OutputFileFactory fileFactory = null;

    @Parameterized.Parameters(name="FileFormat={0}, Partitioned={1}")
    public static Object[] parameters() {
        return new Object[][]{{FileFormat.AVRO, false}, {FileFormat.AVRO, true}, {FileFormat.PARQUET, false}, {FileFormat.PARQUET, true}, {FileFormat.ORC, false}, {FileFormat.ORC, true}};
    }

    public TestFileWriterFactory(FileFormat fileFormat, boolean partitioned) {
        super(2);
        this.fileFormat = fileFormat;
        this.partitioned = partitioned;
        this.dataRows = ImmutableList.of(this.toRow(1, PARTITION_VALUE), this.toRow(2, PARTITION_VALUE), this.toRow(3, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE), this.toRow(5, PARTITION_VALUE));
    }

    protected abstract StructLikeSet toSet(Iterable<T> var1);

    protected FileFormat format() {
        return this.fileFormat;
    }

    @Before
    public void setupTable() throws Exception {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
        if (this.partitioned) {
            this.table = this.create(SCHEMA, SPEC);
            this.partition = this.partitionKey(this.table.spec(), PARTITION_VALUE);
        } else {
            this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
            this.partition = null;
        }
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @Test
    public void testDataWriter() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        this.table.newRowDelta().addRows(dataFile).commit();
        Assert.assertEquals((String)"Records should match", (Object)this.toSet(this.dataRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testEqualityDeleteWriter() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        this.table.newRowDelta().addRows(dataFile).commit();
        ImmutableList deletes = ImmutableList.of(this.toRow(1, PARTITION_VALUE), this.toRow(3, "bbb"), this.toRow(5, "ccc"));
        DeleteFile deleteFile = this.writeEqualityDeletes(writerFactory, (List<T>)deletes, this.table.spec(), this.partition);
        GenericRecord deleteRecord = GenericRecord.create((Schema)equalityDeleteRowSchema);
        ImmutableList expectedDeletes = ImmutableList.of((Object)deleteRecord.copy("id", (Object)1), (Object)deleteRecord.copy("id", (Object)3), (Object)deleteRecord.copy("id", (Object)5));
        InputFile inputDeleteFile = this.table.io().newInputFile(deleteFile.path().toString());
        List<Record> actualDeletes = this.readFile(equalityDeleteRowSchema, inputDeleteFile);
        Assert.assertEquals((String)"Delete records must match", (Object)expectedDeletes, actualDeletes);
        this.table.newRowDelta().addDeletes(deleteFile).commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(2, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testEqualityDeleteWriterWithMultipleSpecs() throws IOException {
        Assume.assumeFalse((String)"Table must start unpartitioned", (boolean)this.partitioned);
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        DataFile firstDataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        Assert.assertEquals((String)"First data file must be unpartitioned", (long)0L, (long)firstDataFile.partition().size());
        ImmutableList deletes = ImmutableList.of(this.toRow(1, PARTITION_VALUE), this.toRow(2, PARTITION_VALUE), this.toRow(3, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE));
        DeleteFile firstDeleteFile = this.writeEqualityDeletes(writerFactory, (List<T>)deletes, this.table.spec(), this.partition);
        Assert.assertEquals((String)"First delete file must be unpartitioned", (long)0L, (long)firstDeleteFile.partition().size());
        this.table.newAppend().appendFile(firstDataFile).commit();
        this.table.newRowDelta().addDeletes(firstDeleteFile).commit();
        this.table.updateSpec().addField("data").commit();
        this.partition = this.partitionKey(this.table.spec(), PARTITION_VALUE);
        DataFile secondDataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        Assert.assertEquals((String)"Second data file must be partitioned", (long)1L, (long)secondDataFile.partition().size());
        DeleteFile secondDeleteFile = this.writeEqualityDeletes(writerFactory, (List<T>)deletes, this.table.spec(), this.partition);
        Assert.assertEquals((String)"Second delete file must be artitioned", (long)1L, (long)secondDeleteFile.partition().size());
        this.table.newAppend().appendFile(secondDataFile).commit();
        this.table.newRowDelta().addDeletes(secondDeleteFile).commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(5, PARTITION_VALUE), this.toRow(5, PARTITION_VALUE));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testPositionDeleteWriter() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        ImmutableList deletes = ImmutableList.of((Object)this.positionDelete(dataFile.path(), 0L, null), (Object)this.positionDelete(dataFile.path(), 2L, null), (Object)this.positionDelete(dataFile.path(), 4L, null));
        Pair<DeleteFile, CharSequenceSet> result = this.writePositionDeletes(writerFactory, (List<PositionDelete<T>>)deletes, this.table.spec(), this.partition);
        DeleteFile deleteFile = (DeleteFile)result.first();
        CharSequenceSet referencedDataFiles = (CharSequenceSet)result.second();
        GenericRecord deleteRecord = GenericRecord.create((Schema)DeleteSchemaUtil.pathPosSchema());
        ImmutableList expectedDeletes = ImmutableList.of((Object)deleteRecord.copy(MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), MetadataColumns.DELETE_FILE_POS.name(), (Object)0L), (Object)deleteRecord.copy(MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), MetadataColumns.DELETE_FILE_POS.name(), (Object)2L), (Object)deleteRecord.copy(MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), MetadataColumns.DELETE_FILE_POS.name(), (Object)4L));
        InputFile inputDeleteFile = this.table.io().newInputFile(deleteFile.path().toString());
        List<Record> actualDeletes = this.readFile(DeleteSchemaUtil.pathPosSchema(), inputDeleteFile);
        Assert.assertEquals((String)"Delete records must match", (Object)expectedDeletes, actualDeletes);
        this.table.newRowDelta().addRows(dataFile).addDeletes(deleteFile).validateDataFilesExist((Iterable)referencedDataFiles).validateDeletedFiles().commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(2, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testPositionDeleteWriterWithRow() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), this.table.schema());
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        ImmutableList deletes = ImmutableList.of((Object)this.positionDelete(dataFile.path(), 0L, this.dataRows.get(0)));
        Pair<DeleteFile, CharSequenceSet> result = this.writePositionDeletes(writerFactory, (List<PositionDelete<T>>)deletes, this.table.spec(), this.partition);
        DeleteFile deleteFile = (DeleteFile)result.first();
        CharSequenceSet referencedDataFiles = (CharSequenceSet)result.second();
        GenericRecord deletedRow = GenericRecord.create((Schema)this.table.schema());
        Schema positionDeleteSchema = DeleteSchemaUtil.posDeleteSchema((Schema)this.table.schema());
        GenericRecord deleteRecord = GenericRecord.create((Schema)positionDeleteSchema);
        ImmutableMap deleteRecordColumns = ImmutableMap.of((Object)MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), (Object)MetadataColumns.DELETE_FILE_POS.name(), (Object)0L, (Object)"row", (Object)deletedRow.copy("id", (Object)1, "data", (Object)PARTITION_VALUE));
        ImmutableList expectedDeletes = ImmutableList.of((Object)deleteRecord.copy((Map)deleteRecordColumns));
        InputFile inputDeleteFile = this.table.io().newInputFile(deleteFile.path().toString());
        List<Record> actualDeletes = this.readFile(positionDeleteSchema, inputDeleteFile);
        Assert.assertEquals((String)"Delete records must match", (Object)expectedDeletes, actualDeletes);
        this.table.newRowDelta().addRows(dataFile).addDeletes(deleteFile).validateDataFilesExist((Iterable)referencedDataFiles).validateDeletedFiles().commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(2, PARTITION_VALUE), this.toRow(3, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE), this.toRow(5, PARTITION_VALUE));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    private DataFile writeData(FileWriterFactory<T> writerFactory, List<T> rows, PartitionSpec spec, StructLike partitionKey) throws IOException {
        DataWriter writer;
        EncryptedOutputFile file = this.newOutputFile(spec, partitionKey);
        try (DataWriter closeableWriter = writer = writerFactory.newDataWriter(file, spec, partitionKey);){
            for (T row : rows) {
                closeableWriter.write(row);
            }
        }
        return writer.toDataFile();
    }

    private DeleteFile writeEqualityDeletes(FileWriterFactory<T> writerFactory, List<T> deletes, PartitionSpec spec, StructLike partitionKey) throws IOException {
        EqualityDeleteWriter writer;
        EncryptedOutputFile file = this.newOutputFile(spec, partitionKey);
        try (EqualityDeleteWriter closableWriter = writer = writerFactory.newEqualityDeleteWriter(file, spec, partitionKey);){
            closableWriter.write(deletes);
        }
        return writer.toDeleteFile();
    }

    private Pair<DeleteFile, CharSequenceSet> writePositionDeletes(FileWriterFactory<T> writerFactory, List<PositionDelete<T>> deletes, PartitionSpec spec, StructLike partitionKey) throws IOException {
        EncryptedOutputFile file = this.newOutputFile(spec, partitionKey);
        PositionDeleteWriter writer = writerFactory.newPositionDeleteWriter(file, spec, partitionKey);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter closableWriter = writer;){
            for (PositionDelete<T> delete : deletes) {
                closableWriter.write(posDelete.set(delete.path(), delete.pos(), delete.row()));
            }
        }
        return Pair.of((Object)writer.toDeleteFile(), (Object)writer.referencedDataFiles());
    }

    private List<Record> readFile(Schema schema, InputFile inputFile) throws IOException {
        switch (this.fileFormat) {
            case PARQUET: {
                try (CloseableIterable records = Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();){
                    ImmutableList immutableList = ImmutableList.copyOf((Iterable)records);
                    return immutableList;
                }
            }
            case AVRO: {
                try (AvroIterable records = Avro.read((InputFile)inputFile).project(schema).createReaderFunc(DataReader::create).build();){
                    ImmutableList immutableList = ImmutableList.copyOf((Iterable)records);
                    return immutableList;
                }
            }
            case ORC: {
                try (CloseableIterable records = ORC.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)fileSchema)).build();){
                    ImmutableList immutableList = ImmutableList.copyOf((Iterable)records);
                    return immutableList;
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported read file format: " + this.fileFormat);
    }

    private EncryptedOutputFile newOutputFile(PartitionSpec spec, StructLike partitionKey) {
        return this.fileFactory.newOutputFile(spec, partitionKey);
    }
}

