/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestWriterMetrics<T> {
    private static final int FORMAT_V2 = 2;
    protected static final Types.NestedField ID_FIELD = Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get());
    protected static final Types.NestedField DATA_FIELD = Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get());
    protected static final Types.StructType NESTED_FIELDS = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"booleanField", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)5, (String)"longValue", (Type)Types.LongType.get())});
    protected static final Types.NestedField STRUCT_FIELD = Types.NestedField.optional((int)3, (String)"structField", (Type)NESTED_FIELDS);
    protected static final Schema SCHEMA = new Schema(new Types.NestedField[]{ID_FIELD, DATA_FIELD, STRUCT_FIELD});
    protected static final SortOrder sortOrder = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id")).asc("structField.longValue")).build();
    protected static final Map<String, String> properties = ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"none");
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    protected FileFormat fileFormat;
    protected TestTables.TestTable table = null;
    private OutputFileFactory fileFactory = null;

    @Parameterized.Parameters(name="FileFormat = {0}")
    public static Object[][] parameters() {
        return new Object[][]{{FileFormat.ORC}, {FileFormat.PARQUET}};
    }

    public TestWriterMetrics(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    protected abstract FileWriterFactory<T> newWriterFactory(Table var1);

    protected abstract T toRow(Integer var1, String var2, boolean var3, Long var4);

    protected abstract T toGenericRow(int var1, int var2);

    @Before
    public void setupTable() throws Exception {
        File tableDir = this.temp.newFolder();
        tableDir.delete();
        this.table = TestTables.create((File)tableDir, (String)"test", (Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)sortOrder, (int)2);
        this.table.updateProperties().set("write.metadata.metrics.default", "none").commit();
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @After
    public void after() {
        TestTables.clearTables();
    }

    @Test
    public void verifySortedColMetric() throws Exception {
        T row = this.toRow(3, "3", true, 3L);
        DataWriter dataWriter = this.newWriterFactory((Table)this.table).newDataWriter(this.fileFactory.newOutputFile(), PartitionSpec.unpartitioned(), null);
        dataWriter.write(row);
        dataWriter.close();
        DataFile dataFile = dataWriter.toDataFile();
        Map lowerBounds = dataFile.lowerBounds();
        Assert.assertEquals((long)3L, (long)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(1)))).intValue());
        Assert.assertFalse((boolean)lowerBounds.containsKey(2));
        Assert.assertFalse((boolean)lowerBounds.containsKey(3));
        Assert.assertFalse((boolean)lowerBounds.containsKey(4));
        Assert.assertEquals((long)3L, (long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(5)))));
        Map upperBounds = dataFile.upperBounds();
        Assert.assertEquals((long)3L, (long)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(1)))).intValue());
        Assert.assertFalse((boolean)upperBounds.containsKey(2));
        Assert.assertFalse((boolean)upperBounds.containsKey(3));
        Assert.assertFalse((boolean)upperBounds.containsKey(4));
        Assert.assertEquals((long)3L, (long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(5)))));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPositionDeleteMetrics() throws IOException {
        FileWriterFactory<T> writerFactory = this.newWriterFactory((Table)this.table);
        EncryptedOutputFile outputFile = this.fileFactory.newOutputFile();
        try (PositionDeleteWriter deleteWriter = writerFactory.newPositionDeleteWriter(outputFile, this.table.spec(), null);){
            T deletedRow = this.toRow(3, "3", true, 3L);
            PositionDelete positionDelete = PositionDelete.create();
            positionDelete.set((CharSequence)"File A", 1L, deletedRow);
            deleteWriter.write(positionDelete);
        }
        DeleteFile deleteFile = deleteWriter.toDeleteFile();
        int pathFieldId = MetadataColumns.DELETE_FILE_PATH.fieldId();
        int posFieldId = MetadataColumns.DELETE_FILE_POS.fieldId();
        Map lowerBounds = deleteFile.lowerBounds();
        Assert.assertEquals((Object)CharBuffer.wrap("File A"), (Object)Conversions.fromByteBuffer((Type)Types.StringType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(pathFieldId))));
        Assert.assertEquals((long)1L, (long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(posFieldId)))));
        Assert.assertEquals((long)3L, (long)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(1)))).intValue());
        Assert.assertFalse((boolean)lowerBounds.containsKey(2));
        Assert.assertFalse((boolean)lowerBounds.containsKey(3));
        Assert.assertFalse((boolean)lowerBounds.containsKey(4));
        Assert.assertEquals((long)3L, (long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(5)))));
        Map upperBounds = deleteFile.upperBounds();
        Assert.assertEquals((Object)CharBuffer.wrap("File A"), (Object)Conversions.fromByteBuffer((Type)Types.StringType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(pathFieldId))));
        Assert.assertEquals((long)1L, (long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(posFieldId)))));
        Assert.assertEquals((long)3L, (long)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(1)))).intValue());
        Assert.assertFalse((boolean)upperBounds.containsKey(2));
        Assert.assertFalse((boolean)upperBounds.containsKey(3));
        Assert.assertFalse((boolean)upperBounds.containsKey(4));
        Assert.assertEquals((long)3L, (long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(5)))));
    }

    @Test
    public void testMaxColumns() throws IOException {
        int id;
        File tableDir = this.temp.newFolder();
        tableDir.delete();
        int numColumns = 101;
        ArrayList fields = Lists.newArrayListWithCapacity((int)numColumns);
        for (int i = 0; i < numColumns; ++i) {
            fields.add(Types.NestedField.required((int)i, (String)("col" + i), (Type)Types.IntegerType.get()));
        }
        Schema maxColSchema = new Schema((List)fields);
        TestTables.TestTable maxColumnTable = TestTables.create((File)tableDir, (String)"max_col_table", (Schema)maxColSchema, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)SortOrder.unsorted(), (int)2);
        OutputFileFactory maxColFactory = OutputFileFactory.builderFor((Table)maxColumnTable, (int)1, (long)1L).format(this.fileFormat).build();
        T row = this.toGenericRow(1, numColumns);
        DataWriter dataWriter = this.newWriterFactory((Table)maxColumnTable).newDataWriter(maxColFactory.newOutputFile(), PartitionSpec.unpartitioned(), null);
        dataWriter.write(row);
        dataWriter.close();
        DataFile dataFile = dataWriter.toDataFile();
        for (id = 1; id <= 100; ++id) {
            Assert.assertNotNull((String)"Should have lower bound metrics", dataFile.lowerBounds().get(id));
            Assert.assertNotNull((String)"Should have upper bound metrics", dataFile.upperBounds().get(id));
            Assert.assertNull((String)"Should not have nan value metrics (not floating point)", dataFile.nanValueCounts().get(id));
            Assert.assertNotNull((String)"Should have null value metrics", dataFile.nullValueCounts().get(id));
            Assert.assertNotNull((String)"Should have value metrics", dataFile.valueCounts().get(id));
        }
        while (id <= numColumns) {
            Assert.assertNull((String)"Should not have any lower bound metrics", dataFile.lowerBounds().get(id));
            Assert.assertNull((String)"Should not have any upper bound metrics", dataFile.upperBounds().get(id));
            Assert.assertNull((String)"Should not have any nan value metrics", dataFile.nanValueCounts().get(id));
            Assert.assertNull((String)"Should not have any null value metrics", dataFile.nullValueCounts().get(id));
            Assert.assertNull((String)"Should not have any value metrics", dataFile.valueCounts().get(id));
            ++id;
        }
    }

    @Test
    public void testMaxColumnsWithDefaultOverride() throws IOException {
        File tableDir = this.temp.newFolder();
        tableDir.delete();
        int numColumns = 101;
        ArrayList fields = Lists.newArrayListWithCapacity((int)numColumns);
        for (int i = 0; i < numColumns; ++i) {
            fields.add(Types.NestedField.required((int)i, (String)("col" + i), (Type)Types.IntegerType.get()));
        }
        Schema maxColSchema = new Schema((List)fields);
        TestTables.TestTable maxColumnTable = TestTables.create((File)tableDir, (String)"max_col_table", (Schema)maxColSchema, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)SortOrder.unsorted(), (int)2);
        maxColumnTable.updateProperties().set("write.metadata.metrics.default", "truncate(16)").commit();
        OutputFileFactory maxColFactory = OutputFileFactory.builderFor((Table)maxColumnTable, (int)1, (long)1L).format(this.fileFormat).build();
        T row = this.toGenericRow(1, numColumns);
        DataWriter dataWriter = this.newWriterFactory((Table)maxColumnTable).newDataWriter(maxColFactory.newOutputFile(), PartitionSpec.unpartitioned(), null);
        dataWriter.write(row);
        dataWriter.close();
        DataFile dataFile = dataWriter.toDataFile();
        Map upperBounds = dataFile.upperBounds();
        Map lowerBounds = dataFile.upperBounds();
        for (int i = 0; i < numColumns; ++i) {
            Assert.assertEquals((long)1L, (long)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(1)))).intValue());
            Assert.assertEquals((long)1L, (long)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(1)))).intValue());
        }
    }
}

