/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.util.List;
import org.apache.iceberg.Schema;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeWrapper;
import org.junit.Assert;
import org.junit.Test;

public abstract class RecordWrapperTest {
    private static final Types.StructType PRIMITIVE_WITHOUT_TIME = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts_tz", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.required((int)112, (String)"fixed", (Type)Types.FixedType.ofLength((int)7)), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10))});
    private static final Types.StructType TIMESTAMP_WITHOUT_ZONE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)101, (String)"ts0", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)102, (String)"ts1", (Type)Types.TimestampType.withoutZone())});
    protected static final Types.StructType TIME = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"time0", (Type)Types.TimeType.get()), Types.NestedField.optional((int)101, (String)"time1", (Type)Types.TimeType.get())});

    @Test
    public void testSimpleStructWithoutTime() {
        this.generateAndValidate(new Schema(PRIMITIVE_WITHOUT_TIME.fields()));
    }

    @Test
    public void testTimestampWithoutZone() {
        this.generateAndValidate(new Schema(TIMESTAMP_WITHOUT_ZONE.fields()));
    }

    @Test
    public void testTime() {
        this.generateAndValidate(new Schema(TIME.fields()));
    }

    @Test
    public void testNestedSchema() {
        Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)1, (String)"level1", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"level2", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"level3", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)4, (String)"level4", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"level5", (Type)Types.StructType.of((List)PRIMITIVE_WITHOUT_TIME.fields()))}))}))}))}))});
        this.generateAndValidate(new Schema(structType.fields()));
    }

    private void generateAndValidate(Schema schema) {
        this.generateAndValidate(schema, Assert::assertEquals);
    }

    protected abstract void generateAndValidate(Schema var1, AssertMethod var2);

    public static interface AssertMethod {
        public void assertEquals(String var1, StructLikeWrapper var2, StructLikeWrapper var3);
    }
}

