/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.junit.Assert;

public class DataTestHelpers {
    private DataTestHelpers() {
    }

    public static void assertEquals(Types.StructType struct, Record expected, Record actual) {
        List fields = struct.fields();
        for (int i = 0; i < fields.size(); ++i) {
            Type fieldType = ((Types.NestedField)fields.get(i)).type();
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            DataTestHelpers.assertEquals(fieldType, expectedValue, actualValue);
        }
    }

    public static void assertEquals(Types.ListType list, List<?> expected, List<?> actual) {
        Type elementType = list.elementType();
        Assert.assertEquals((String)"List size should match", (long)expected.size(), (long)actual.size());
        for (int i = 0; i < expected.size(); ++i) {
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            DataTestHelpers.assertEquals(elementType, expectedValue, actualValue);
        }
    }

    public static void assertEquals(Types.MapType map, Map<?, ?> expected, Map<?, ?> actual) {
        Type valueType = map.valueType();
        Assert.assertEquals((String)"Map size should match", (long)expected.size(), (long)actual.size());
        for (Object expectedKey : expected.keySet()) {
            Object expectedValue = expected.get(expectedKey);
            Object actualValue = actual.get(expectedKey);
            DataTestHelpers.assertEquals(valueType, expectedValue, actualValue);
        }
    }

    private static void assertEquals(Type type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case UUID: 
            case BINARY: 
            case DECIMAL: {
                Assert.assertEquals((String)("Primitive value should be equal to expected for type " + type), (Object)expected, (Object)actual);
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Actual should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                Assert.assertArrayEquals((String)"Array contents should be equal", (byte[])((byte[])expected), (byte[])((byte[])actual));
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a Record", new Object[0])).isInstanceOf(Record.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a Record", new Object[0])).isInstanceOf(Record.class);
                DataTestHelpers.assertEquals(type.asStructType(), (Record)expected, (Record)actual);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a List", new Object[0])).isInstanceOf(List.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a List", new Object[0])).isInstanceOf(List.class);
                DataTestHelpers.assertEquals(type.asListType(), (List)expected, (List)actual);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a Map", new Object[0])).isInstanceOf(Map.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a Map", new Object[0])).isInstanceOf(Map.class);
                DataTestHelpers.assertEquals(type.asMapType(), (Map)expected, (Map)actual);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }
}

