/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileScanTask;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDataFileIndexStatsFilters {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"category", (Type)Types.StringType.get())});
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private Table table;
    private List<Record> records = null;
    private DataFile dataFile = null;
    private DataFile dataFileWithoutNulls = null;
    private DataFile dataFileOnlyNulls = null;

    @Before
    public void createTableAndData() throws IOException {
        File location = this.temp.newFolder();
        this.table = TestTables.create((File)location, (String)"test", (Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (int)2);
        this.records = Lists.newArrayList();
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        this.records.add(record.copy("id", (Object)1, "data", (Object)"a", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)2, "data", (Object)"b", "category", (Object)"even"));
        this.records.add(record.copy("id", (Object)3, "data", (Object)"c", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)4, "data", (Object)"d", "category", (Object)"even"));
        this.records.add(record.copy("id", (Object)5, "data", (Object)"e", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)6, "data", (Object)"f", "category", (Object)"even"));
        this.records.add(record.copy("id", (Object)7, "data", (Object)"g", "category", (Object)"odd"));
        this.records.add(record.copy("id", (Object)8, "data", null, "category", (Object)"even"));
        this.dataFile = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), this.records);
        this.dataFileWithoutNulls = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), this.records.stream().filter(rec -> rec.getField("data") != null).collect(Collectors.toList()));
        this.dataFileOnlyNulls = FileHelpers.writeDataFile(this.table, Files.localOutput((File)this.temp.newFile()), this.records.stream().filter(rec -> rec.getField("data") == null).collect(Collectors.toList()));
    }

    @After
    public void dropTable() {
        TestTables.clearTables();
    }

    @Test
    public void testPositionDeletePlanningPath() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        deletes.add(Pair.of((Object)this.dataFile.path(), (Object)0L));
        deletes.add(Pair.of((Object)this.dataFile.path(), (Object)1L));
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have one delete file, file_path matches", (long)1L, (long)task.deletes().size());
    }

    @Test
    public void testPositionDeletePlanningPathFilter() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        deletes.add(Pair.of((Object)"some-other-file.parquet", (Object)0L));
        deletes.add(Pair.of((Object)"some-other-file.parquet", (Object)1L));
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should not have delete file, filtered by file_path stats", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStats() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", (Object)"d"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have one delete file, data contains a matching value", (long)1L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsFilter() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", (Object)"x"));
        deletes.add(delete.copy("data", (Object)"y"));
        deletes.add(delete.copy("data", (Object)"z"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should not have delete file, filtered by data column stats", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsNullValueWithAllNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", null));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have delete file, data contains a null value", (long)1L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsNoNullValuesWithAllNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFileWithoutNulls).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", null));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have no delete files, data contains no null values", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsAllNullValuesWithNoNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFileOnlyNulls).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", (Object)"d"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have no delete files, data contains no null values", (long)0L, (long)task.deletes().size());
    }

    @Test
    public void testEqualityDeletePlanningStatsSomeNullValuesWithSomeNullDeletes() throws IOException {
        ArrayList tasks;
        this.table.newAppend().appendFile(this.dataFile).commit();
        ArrayList deletes = Lists.newArrayList();
        Schema deleteRowSchema = SCHEMA.select(new String[]{"data"});
        GenericRecord delete = GenericRecord.create((Schema)deleteRowSchema);
        deletes.add(delete.copy("data", null));
        deletes.add(delete.copy("data", (Object)"x"));
        DeleteFile posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)this.temp.newFile()), deletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(posDeletes).commit();
        try (CloseableIterable tasksIterable = this.table.newScan().planFiles();){
            tasks = Lists.newArrayList((Iterable)tasksIterable);
        }
        Assert.assertEquals((String)"Should produce one task", (long)1L, (long)tasks.size());
        FileScanTask task = (FileScanTask)tasks.get(0);
        Assert.assertEquals((String)"Should have one delete file, data and deletes have null values", (long)1L, (long)task.deletes().size());
    }
}

