/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.TableTestBase;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.SortedPosDeleteWriter;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestGenericSortedPosDeleteWriter
extends TableTestBase {
    private static final int FORMAT_V2 = 2;
    private final FileFormat format;
    private OutputFileFactory fileFactory;
    private Record gRecord;

    @Parameterized.Parameters(name="FileFormat={0}")
    public static Object[] parameters() {
        return new Object[][]{{"avro"}, {"orc"}, {"parquet"}};
    }

    public TestGenericSortedPosDeleteWriter(String fileFormat) {
        super(2);
        this.format = FileFormat.fromString((String)fileFormat);
    }

    @Before
    public void setupTable() throws IOException {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.gRecord = GenericRecord.create((Schema)SCHEMA);
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.format).build();
        this.table.updateProperties().defaultFormat(this.format).commit();
    }

    private EncryptedOutputFile createEncryptedOutputFile() {
        return this.fileFactory.newOutputFile();
    }

    private DataFile prepareDataFile(FileAppenderFactory<Record> appenderFactory, List<Record> rowSet) throws IOException {
        DataWriter writer;
        try (DataWriter closeableWriter = writer = appenderFactory.newDataWriter(this.createEncryptedOutputFile(), this.format, null);){
            for (Record record : rowSet) {
                closeableWriter.write((Object)record);
            }
        }
        return writer.toDataFile();
    }

    private Record createRow(Integer id, String data) {
        Record row = this.gRecord.copy();
        row.setField("id", (Object)id);
        row.setField("data", (Object)data);
        return row;
    }

    private StructLikeSet expectedRowSet(Iterable<Record> records) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        records.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    private StructLikeSet actualRowSet(String ... columns) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        try (CloseableIterable reader = IcebergGenerics.read((Table)this.table).select(columns).build();){
            reader.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        }
        return set;
    }

    @Test
    public void testSortedPosDelete() throws IOException {
        SortedPosDeleteWriter writer;
        ArrayList rowSet = Lists.newArrayList((Object[])new Record[]{this.createRow(0, "aaa"), this.createRow(1, "bbb"), this.createRow(2, "ccc"), this.createRow(3, "ddd"), this.createRow(4, "eee")});
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec(), null, null, null);
        DataFile dataFile = this.prepareDataFile((FileAppenderFactory<Record>)appenderFactory, rowSet);
        try (SortedPosDeleteWriter closeableWriter = writer = new SortedPosDeleteWriter((FileAppenderFactory)appenderFactory, this.fileFactory, this.format, null, 100L);){
            for (int index = rowSet.size() - 1; index >= 0; index -= 2) {
                closeableWriter.delete(dataFile.path(), (long)index);
            }
        }
        List deleteFiles = writer.complete();
        Assert.assertEquals((long)1L, (long)deleteFiles.size());
        DeleteFile deleteFile = (DeleteFile)deleteFiles.get(0);
        Schema pathPosSchema = DeleteSchemaUtil.pathPosSchema();
        GenericRecord record = GenericRecord.create((Schema)pathPosSchema);
        ArrayList expectedDeletes = Lists.newArrayList((Object[])new Record[]{record.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L), record.copy("file_path", (Object)dataFile.path(), "pos", (Object)2L), record.copy("file_path", (Object)dataFile.path(), "pos", (Object)4L)});
        Assert.assertEquals((Object)expectedDeletes, this.readRecordsAsList(pathPosSchema, deleteFile.path()));
        this.table.newRowDelta().addRows(dataFile).addDeletes((DeleteFile)deleteFiles.get(0)).validateDataFilesExist((Iterable)writer.referencedDataFiles()).validateDeletedFiles().commit();
        ArrayList expectedData = Lists.newArrayList((Object[])new Record[]{this.createRow(1, "bbb"), this.createRow(3, "ddd")});
        Assert.assertEquals((String)"Should have the expected records", (Object)this.expectedRowSet(expectedData), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testSortedPosDeleteWithSchemaAndNullRow() throws IOException {
        ArrayList rowSet = Lists.newArrayList((Object[])new Record[]{this.createRow(0, "aaa"), this.createRow(1, "bbb"), this.createRow(2, "ccc")});
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec(), null, null, this.table.schema());
        DataFile dataFile = this.prepareDataFile((FileAppenderFactory<Record>)appenderFactory, rowSet);
        SortedPosDeleteWriter writer = new SortedPosDeleteWriter((FileAppenderFactory)appenderFactory, this.fileFactory, this.format, null, 1L);
        boolean caughtError = false;
        try {
            writer.delete(dataFile.path(), 0L);
        }
        catch (Exception e) {
            caughtError = true;
        }
        Assert.assertTrue((String)"Should fail because the appender are required non-null rows to write", (boolean)caughtError);
    }

    @Test
    public void testSortedPosDeleteWithRow() throws IOException {
        SortedPosDeleteWriter writer;
        ArrayList rowSet = Lists.newArrayList((Object[])new Record[]{this.createRow(0, "aaa"), this.createRow(1, "bbb"), this.createRow(2, "ccc"), this.createRow(3, "ddd"), this.createRow(4, "eee")});
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec(), null, null, this.table.schema());
        DataFile dataFile = this.prepareDataFile((FileAppenderFactory<Record>)appenderFactory, rowSet);
        try (SortedPosDeleteWriter closeableWriter = writer = new SortedPosDeleteWriter((FileAppenderFactory)appenderFactory, this.fileFactory, this.format, null, 100L);){
            for (int index = rowSet.size() - 1; index >= 0; index -= 2) {
                closeableWriter.delete(dataFile.path(), (long)index, (Object)((Record)rowSet.get(index)));
            }
        }
        List deleteFiles = writer.complete();
        Assert.assertEquals((long)1L, (long)deleteFiles.size());
        DeleteFile deleteFile = (DeleteFile)deleteFiles.get(0);
        Schema pathPosSchema = DeleteSchemaUtil.posDeleteSchema((Schema)this.table.schema());
        GenericRecord record = GenericRecord.create((Schema)pathPosSchema);
        ArrayList expectedDeletes = Lists.newArrayList((Object[])new Record[]{record.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L, "row", (Object)this.createRow(0, "aaa")), record.copy("file_path", (Object)dataFile.path(), "pos", (Object)2L, "row", (Object)this.createRow(2, "ccc")), record.copy("file_path", (Object)dataFile.path(), "pos", (Object)4L, "row", (Object)this.createRow(4, "eee"))});
        Assert.assertEquals((Object)expectedDeletes, this.readRecordsAsList(pathPosSchema, deleteFile.path()));
        this.table.newRowDelta().addRows(dataFile).addDeletes((DeleteFile)deleteFiles.get(0)).validateDataFilesExist((Iterable)writer.referencedDataFiles()).validateDeletedFiles().commit();
        ArrayList expectedData = Lists.newArrayList((Object[])new Record[]{this.createRow(1, "bbb"), this.createRow(3, "ddd")});
        Assert.assertEquals((String)"Should have the expected records", (Object)this.expectedRowSet(expectedData), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testMultipleFlush() throws IOException {
        SortedPosDeleteWriter writer;
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec(), null, null, null);
        ArrayList dataFiles = Lists.newArrayList();
        for (int fileIndex = 0; fileIndex < 5; ++fileIndex) {
            LinkedList recordList = Lists.newLinkedList();
            for (int recordIndex = 0; recordIndex < 100; ++recordIndex) {
                int id = fileIndex * 100 + recordIndex;
                recordList.add(this.createRow(id, String.format("val-%s", id)));
            }
            dataFiles.add(this.prepareDataFile((FileAppenderFactory<Record>)appenderFactory, recordList));
        }
        RowDelta rowDelta = this.table.newRowDelta();
        dataFiles.forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        rowDelta.commit();
        try (SortedPosDeleteWriter closeableWriter = writer = new SortedPosDeleteWriter((FileAppenderFactory)appenderFactory, this.fileFactory, this.format, null, 50L);){
            for (int pos = 0; pos < 100; ++pos) {
                for (int fileIndex = 4; fileIndex >= 0; --fileIndex) {
                    closeableWriter.delete(((DataFile)dataFiles.get(fileIndex)).path(), (long)pos);
                }
            }
        }
        List deleteFiles = writer.complete();
        Assert.assertEquals((long)10L, (long)deleteFiles.size());
        Schema pathPosSchema = DeleteSchemaUtil.pathPosSchema();
        GenericRecord record = GenericRecord.create((Schema)pathPosSchema);
        for (int deleteFileIndex = 0; deleteFileIndex < 10; ++deleteFileIndex) {
            ArrayList expectedDeletes = Lists.newArrayList();
            for (int dataFileIndex = 0; dataFileIndex < 5; ++dataFileIndex) {
                DataFile dataFile = (DataFile)dataFiles.get(dataFileIndex);
                for (long pos = (long)(deleteFileIndex * 10); pos < (long)(deleteFileIndex * 10 + 10); ++pos) {
                    expectedDeletes.add(record.copy("file_path", (Object)dataFile.path(), "pos", (Object)pos));
                }
            }
            DeleteFile deleteFile = (DeleteFile)deleteFiles.get(deleteFileIndex);
            Assert.assertEquals((Object)expectedDeletes, this.readRecordsAsList(pathPosSchema, deleteFile.path()));
        }
        rowDelta = this.table.newRowDelta();
        deleteFiles.forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        Assert.assertEquals((String)"Should have no record.", (Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of()), (Object)this.actualRowSet("*"));
    }

    private List<Record> readRecordsAsList(Schema schema, CharSequence path) throws IOException {
        AvroIterable iterable;
        InputFile inputFile = Files.localInput((String)path.toString());
        switch (this.format) {
            case PARQUET: {
                iterable = Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();
                break;
            }
            case AVRO: {
                iterable = Avro.read((InputFile)inputFile).project(schema).createReaderFunc(DataReader::create).build();
                break;
            }
            case ORC: {
                iterable = ORC.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)fileSchema)).build();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported file format: " + this.format);
            }
        }
        try (AvroIterable closeableIterable = iterable;){
            ArrayList arrayList = Lists.newArrayList((Iterable)closeableIterable);
            return arrayList;
        }
    }
}

