/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.Term;
import org.apache.iceberg.io.ClusteredDataWriter;
import org.apache.iceberg.io.ClusteredEqualityDeleteWriter;
import org.apache.iceberg.io.ClusteredPositionDeleteWriter;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FanoutDataWriter;
import org.apache.iceberg.io.FanoutPositionOnlyDeleteWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.util.StructLikeSet;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestPartitioningWriters<T>
extends WriterTestBase<T> {
    private static final int TABLE_FORMAT_VERSION = 2;
    private static final long TARGET_FILE_SIZE = 0x8000000L;
    private final FileFormat fileFormat;
    private OutputFileFactory fileFactory = null;

    @Parameterized.Parameters(name="FileFormat={0}")
    public static Object[] parameters() {
        return new Object[][]{{FileFormat.AVRO}, {FileFormat.PARQUET}, {FileFormat.ORC}};
    }

    public TestPartitioningWriters(FileFormat fileFormat) {
        super(2);
        this.fileFormat = fileFormat;
    }

    protected abstract StructLikeSet toSet(Iterable<T> var1);

    protected FileFormat format() {
        return this.fileFormat;
    }

    @Before
    public void setupTable() throws Exception {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @Test
    public void testClusteredDataWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter writer = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assert.assertEquals((String)"Must be no data files", (long)0L, (long)((DataWriteResult)writer.result()).dataFiles().size());
        writer.close();
        Assert.assertEquals((String)"Must be no data files", (long)0L, (long)((DataWriteResult)writer.result()).dataFiles().size());
    }

    @Test
    public void testClusteredDataWriterMultiplePartitions() throws IOException {
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter writer = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec spec = this.table.spec();
        writer.write(this.toRow(1, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(2, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(3, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(4, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(5, "ccc"), spec, (StructLike)this.partitionKey(spec, "ccc"));
        writer.close();
        DataWriteResult result = (DataWriteResult)writer.result();
        Assert.assertEquals((String)"Must be 3 data files", (long)3L, (long)result.dataFiles().size());
        RowDelta rowDelta = this.table.newRowDelta();
        result.dataFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(5, "ccc"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testClusteredDataWriterOutOfOrderPartitions() throws IOException {
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredDataWriter writer = new ClusteredDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec spec = this.table.spec();
        writer.write(this.toRow(1, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(2, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(3, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(4, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(5, "ccc"), spec, (StructLike)this.partitionKey(spec, "ccc"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(this.toRow(6, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"))).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("partition 'data=aaa' in spec " + spec);
        writer.close();
    }

    @Test
    public void testClusteredEqualityDeleteWriterNoRecords() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        ClusteredEqualityDeleteWriter writer = new ClusteredEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
    }

    @Test
    public void testClusteredEqualityDeleteWriterMultipleSpecs() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(12, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows3 = ImmutableList.of(this.toRow(5, "ccc"), this.toRow(13, "ccc"));
        DataFile dataFile3 = this.writeData(writerFactory, this.fileFactory, rows3, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "ccc"));
        this.table.newFastAppend().appendFile(dataFile3).commit();
        ClusteredEqualityDeleteWriter writer = new ClusteredEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write(this.toRow(1, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(2, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(3, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(4, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(5, "ccc"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assert.assertEquals((String)"Must be 3 delete files", (long)3L, (long)result.deleteFiles().size());
        Assert.assertEquals((String)"Must not reference data files", (long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((String)"Must not reference data files", (boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "bbb"), this.toRow(13, "ccc"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testClusteredEqualityDeleteWriterOutOfOrderSpecsAndPartitions() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ClusteredEqualityDeleteWriter writer = new ClusteredEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write(this.toRow(1, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(2, "aaa"), unpartitionedSpec, null);
        writer.write(this.toRow(3, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(4, "bbb"), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write(this.toRow(5, "ccc"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write(this.toRow(6, "ddd"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ddd"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(this.toRow(7, "ccc"), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"))).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("partition 'data=ccc' in spec " + identitySpec);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> writer.write(this.toRow(7, "aaa"), unpartitionedSpec, null)).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("spec []");
        writer.close();
    }

    @Test
    public void testClusteredPositionDeleteWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ClusteredPositionDeleteWriter writer = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
    }

    @Test
    public void testClusteredPositionDeleteWriterMultipleSpecs() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(12, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows3 = ImmutableList.of(this.toRow(5, "ccc"), this.toRow(13, "ccc"));
        DataFile dataFile3 = this.writeData(writerFactory, this.fileFactory, rows3, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "ccc"));
        this.table.newFastAppend().appendFile(dataFile3).commit();
        ClusteredPositionDeleteWriter writer = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write((Object)this.positionDelete(dataFile1.path(), 0L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile1.path(), 1L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile2.path(), 0L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile2.path(), 1L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile3.path(), 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assert.assertEquals((String)"Must be 3 delete files", (long)3L, (long)result.deleteFiles().size());
        Assert.assertEquals((String)"Must reference 3 data files", (long)3L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertTrue((String)"Must reference data files", (boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(11, "aaa"), this.toRow(12, "bbb"), this.toRow(13, "ccc"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testClusteredPositionDeleteWriterOutOfOrderSpecsAndPartitions() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ClusteredPositionDeleteWriter writer = new ClusteredPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write((Object)this.positionDelete("file-1.parquet", 0L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete("file-1.parquet", 1L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete("file-2.parquet", 0L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete("file-2.parquet", 1L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete("file-3.parquet", 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete("file-4.parquet", 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ddd"));
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            PositionDelete positionDelete = this.positionDelete("file-5.parquet", 1L, null);
            writer.write((Object)positionDelete, identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("partition 'data=ccc' in spec " + identitySpec);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> {
            PositionDelete positionDelete = this.positionDelete("file-1.parquet", 3L, null);
            writer.write((Object)positionDelete, unpartitionedSpec, null);
        }).isInstanceOf(IllegalStateException.class)).hasMessageContaining("Encountered records that belong to already closed files").hasMessageEndingWith("spec []");
        writer.close();
    }

    @Test
    public void testFanoutDataWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        FanoutDataWriter writer = new FanoutDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assert.assertEquals((String)"Must be no data files", (long)0L, (long)((DataWriteResult)writer.result()).dataFiles().size());
        writer.close();
        Assert.assertEquals((String)"Must be no data files", (long)0L, (long)((DataWriteResult)writer.result()).dataFiles().size());
    }

    @Test
    public void testFanoutDataWriterMultiplePartitions() throws IOException {
        this.table.updateSpec().addField((Term)Expressions.ref((String)"data")).commit();
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        FanoutDataWriter writer = new FanoutDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec spec = this.table.spec();
        writer.write(this.toRow(1, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(3, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(2, "aaa"), spec, (StructLike)this.partitionKey(spec, "aaa"));
        writer.write(this.toRow(4, "bbb"), spec, (StructLike)this.partitionKey(spec, "bbb"));
        writer.write(this.toRow(5, "ccc"), spec, (StructLike)this.partitionKey(spec, "ccc"));
        writer.close();
        DataWriteResult result = (DataWriteResult)writer.result();
        Assert.assertEquals((String)"Must be 3 data files", (long)3L, (long)result.dataFiles().size());
        RowDelta rowDelta = this.table.newRowDelta();
        result.dataFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(5, "ccc"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }

    @Test
    public void testFanoutPositionOnlyDeleteWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        FanoutPositionOnlyDeleteWriter writer = new FanoutPositionOnlyDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
    }

    @Test
    public void testFanoutPositionOnlyDeleteWriterOutOfOrderRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        ImmutableList rows1 = ImmutableList.of(this.toRow(1, "aaa"), this.toRow(2, "aaa"), this.toRow(11, "aaa"));
        DataFile dataFile1 = this.writeData(writerFactory, this.fileFactory, rows1, this.table.spec(), (StructLike)null);
        this.table.newFastAppend().appendFile(dataFile1).commit();
        this.table.updateSpec().addField((Term)Expressions.bucket((String)"data", (int)16)).commit();
        ImmutableList rows2 = ImmutableList.of(this.toRow(3, "bbb"), this.toRow(4, "bbb"), this.toRow(12, "bbb"));
        DataFile dataFile2 = this.writeData(writerFactory, this.fileFactory, rows2, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "bbb"));
        this.table.newFastAppend().appendFile(dataFile2).commit();
        this.table.updateSpec().removeField((Term)Expressions.bucket((String)"data", (int)16)).addField((Term)Expressions.ref((String)"data")).commit();
        ImmutableList rows3 = ImmutableList.of(this.toRow(5, "ccc"), this.toRow(13, "ccc"));
        DataFile dataFile3 = this.writeData(writerFactory, this.fileFactory, rows3, this.table.spec(), (StructLike)this.partitionKey(this.table.spec(), "ccc"));
        this.table.newFastAppend().appendFile(dataFile3).commit();
        FanoutPositionOnlyDeleteWriter writer = new FanoutPositionOnlyDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L);
        PartitionSpec unpartitionedSpec = (PartitionSpec)this.table.specs().get(0);
        PartitionSpec bucketSpec = (PartitionSpec)this.table.specs().get(1);
        PartitionSpec identitySpec = (PartitionSpec)this.table.specs().get(2);
        writer.write((Object)this.positionDelete(dataFile1.path(), 1L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile2.path(), 1L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile2.path(), 0L, null), bucketSpec, (StructLike)this.partitionKey(bucketSpec, "bbb"));
        writer.write((Object)this.positionDelete(dataFile3.path(), 1L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete(dataFile3.path(), 2L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete(dataFile1.path(), 0L, null), unpartitionedSpec, null);
        writer.write((Object)this.positionDelete(dataFile3.path(), 0L, null), identitySpec, (StructLike)this.partitionKey(identitySpec, "ccc"));
        writer.write((Object)this.positionDelete(dataFile1.path(), 2L, null), unpartitionedSpec, null);
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assert.assertEquals((String)"Must be 3 delete files", (long)3L, (long)result.deleteFiles().size());
        Assert.assertEquals((String)"Must reference 3 data files", (long)3L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertTrue((String)"Must reference data files", (boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        RowDelta rowDelta = this.table.newRowDelta();
        result.deleteFiles().forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(12, "bbb"));
        Assert.assertEquals((String)"Records should match", (Object)this.toSet((Iterable<T>)expectedRows), (Object)this.actualRowSet("*"));
    }
}

