/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.orc;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import java.util.UUID;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.MetricsConfig;
import org.apache.iceberg.Schema;
import org.apache.iceberg.TestMetrics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableSet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.junit.Assert;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestOrcMetrics
extends TestMetrics {
    static final ImmutableSet<Object> BINARY_TYPES = ImmutableSet.of((Object)Type.TypeID.BINARY, (Object)Type.TypeID.FIXED, (Object)Type.TypeID.UUID);

    @Parameterized.Parameters(name="formatVersion = {0}")
    public static Object[] parameters() {
        return new Object[]{1, 2};
    }

    public TestOrcMetrics(int formatVersion) {
        super(formatVersion);
    }

    protected OutputFile createOutputFile() throws IOException {
        File tmpFolder = this.temp.newFolder("orc");
        String filename = UUID.randomUUID().toString();
        return Files.localOutput((File)new File(tmpFolder, FileFormat.ORC.addExtension(filename)));
    }

    public FileFormat fileFormat() {
        return FileFormat.ORC;
    }

    public Metrics getMetrics(Schema schema, Record ... records) throws IOException {
        return this.getMetrics(schema, MetricsConfig.getDefault(), records);
    }

    public Metrics getMetrics(Schema schema, MetricsConfig metricsConfig, Record ... records) throws IOException {
        return this.getMetrics(schema, this.createOutputFile(), (Map<String, String>)ImmutableMap.of(), metricsConfig, records);
    }

    protected Metrics getMetricsForRecordsWithSmallRowGroups(Schema schema, OutputFile outputFile, Record ... records) {
        throw new UnsupportedOperationException("supportsSmallRowGroups = " + this.supportsSmallRowGroups());
    }

    private Metrics getMetrics(Schema schema, OutputFile file, Map<String, String> properties, MetricsConfig metricsConfig, Record ... records) throws IOException {
        FileAppender writer;
        try (FileAppender appender = writer = ORC.write((OutputFile)file).schema(schema).setAll(properties).createWriterFunc(GenericOrcWriter::buildWriter).metricsConfig(metricsConfig).build();){
            appender.addAll((Iterable)Lists.newArrayList((Object[])records));
        }
        return writer.metrics();
    }

    public int splitCount(InputFile inputFile) {
        return 0;
    }

    private boolean isBinaryType(Type type) {
        return BINARY_TYPES.contains((Object)type.typeId());
    }

    protected <T> void assertBounds(int fieldId, Type type, T lowerBound, T upperBound, Metrics metrics) {
        if (this.isBinaryType(type)) {
            Assert.assertFalse((String)"ORC binary field should not have lower bounds.", (boolean)metrics.lowerBounds().containsKey(fieldId));
            Assert.assertFalse((String)"ORC binary field should not have upper bounds.", (boolean)metrics.upperBounds().containsKey(fieldId));
            return;
        }
        super.assertBounds(fieldId, type, lowerBound, upperBound, metrics);
    }
}

