/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.parquet;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.DataTestHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.data.parquet.GenericParquetWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.schema.MessageType;
import org.junit.Assert;
import org.junit.Test;

public class TestGenericData
extends DataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        ArrayList rows;
        List<Record> expected = RandomGenericData.generate(schema, 100, 0L);
        File testFile = this.temp.newFile();
        Assert.assertTrue((String)"Delete should succeed", (boolean)testFile.delete());
        try (FileAppender appender = Parquet.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).createWriterFunc(GenericParquetWriter::buildWriter).build();){
            appender.addAll(expected);
        }
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            DataTestHelpers.assertEquals(schema.asStruct(), expected.get(i), (Record)rows.get(i));
        }
        reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();
        var6_9 = null;
        try {
            CloseableIterator it = reader.iterator();
            int idx = 0;
            while (it.hasNext()) {
                GenericRecord actualRecord = (GenericRecord)it.next();
                DataTestHelpers.assertEquals(schema.asStruct(), expected.get(idx), (Record)actualRecord);
                ++idx;
            }
        }
        catch (Throwable throwable) {
            var6_9 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                TestGenericData.$closeResource(var6_9, (AutoCloseable)reader);
            }
        }
    }

    @Test
    public void testTwoLevelList() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"arraybytes", (Type)Types.ListType.ofRequired((int)3, (Type)Types.BinaryType.get())), Types.NestedField.optional((int)2, (String)"topbytes", (Type)Types.BinaryType.get())});
        org.apache.avro.Schema avroSchema = AvroSchemaUtil.convert((Type)schema.asStruct());
        File testFile = this.temp.newFile();
        Assert.assertTrue((boolean)testFile.delete());
        ParquetWriter writer = ((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((Path)new Path(testFile.toURI())).withDataModel(GenericData.get()).withSchema(avroSchema).config("parquet.avro.add-list-element-records", "true")).config("parquet.avro.write-old-list-structure", "true")).build();
        GenericRecordBuilder recordBuilder = new GenericRecordBuilder(avroSchema);
        ArrayList<ByteBuffer> expectedByteList = new ArrayList<ByteBuffer>();
        byte[] expectedByte = new byte[]{0, 1};
        ByteBuffer expectedBinary = ByteBuffer.wrap(expectedByte);
        expectedByteList.add(expectedBinary);
        recordBuilder.set("arraybytes", expectedByteList);
        recordBuilder.set("topbytes", (Object)expectedBinary);
        GenericData.Record expectedRecord = recordBuilder.build();
        writer.write((Object)expectedRecord);
        writer.close();
        try (CloseableIterable reader = Parquet.read((InputFile)Files.localInput((File)testFile)).project(schema).reuseContainers().createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();){
            CloseableIterator it = reader.iterator();
            Assert.assertTrue((String)"Should have at least one row", (boolean)it.hasNext());
            while (it.hasNext()) {
                GenericRecord actualRecord = (GenericRecord)it.next();
                Assert.assertEquals(((ArrayList)actualRecord.get(0, ArrayList.class)).get(0), (Object)expectedBinary);
                Assert.assertEquals((Object)actualRecord.get(1, ByteBuffer.class), (Object)expectedBinary);
                Assert.assertFalse((String)"Should not have more than one row", (boolean)it.hasNext());
            }
        }
    }
}

