/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingDataWriter;
import org.apache.iceberg.io.RollingEqualityDeleteWriter;
import org.apache.iceberg.io.RollingPositionDeleteWriter;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public abstract class TestRollingFileWriters<T>
extends WriterTestBase<T> {
    private static final int TABLE_FORMAT_VERSION = 2;
    private static final int FILE_SIZE_CHECK_ROWS_DIVISOR = 1000;
    private static final long DEFAULT_FILE_SIZE = 0x8000000L;
    private static final long SMALL_FILE_SIZE = 2L;
    private static final String PARTITION_VALUE = "aaa";
    private final FileFormat fileFormat;
    private final boolean partitioned;
    private StructLike partition = null;
    private OutputFileFactory fileFactory = null;

    @Parameterized.Parameters(name="FileFormat={0}, Partitioned={1}")
    public static Object[] parameters() {
        return new Object[][]{{FileFormat.AVRO, false}, {FileFormat.AVRO, true}, {FileFormat.PARQUET, false}, {FileFormat.PARQUET, true}, {FileFormat.ORC, false}, {FileFormat.ORC, true}};
    }

    public TestRollingFileWriters(FileFormat fileFormat, boolean partitioned) {
        super(2);
        this.fileFormat = fileFormat;
        this.partitioned = partitioned;
    }

    protected FileFormat format() {
        return this.fileFormat;
    }

    @Before
    public void setupTable() throws Exception {
        this.tableDir = this.temp.newFolder();
        Assert.assertTrue((boolean)this.tableDir.delete());
        this.metadataDir = new File(this.tableDir, "metadata");
        if (this.partitioned) {
            this.table = this.create(SCHEMA, SPEC);
            this.partition = this.partitionKey(this.table.spec(), PARTITION_VALUE);
        } else {
            this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
            this.partition = null;
        }
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @Test
    public void testRollingDataWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingDataWriter writer = new RollingDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, this.table.spec(), this.partition);
        writer.close();
        Assert.assertEquals((String)"Must be no data files", (long)0L, (long)((DataWriteResult)writer.result()).dataFiles().size());
        writer.close();
        Assert.assertEquals((String)"Must be no data files", (long)0L, (long)((DataWriteResult)writer.result()).dataFiles().size());
    }

    @Test
    public void testRollingDataWriterSplitData() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingDataWriter writer = new RollingDataWriter(writerFactory, this.fileFactory, this.table.io(), 2L, this.table.spec(), this.partition);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)4000);
        for (int index = 0; index < 4000; ++index) {
            rows.add(this.toRow(index, PARTITION_VALUE));
        }
        try (RollingDataWriter closableWriter = writer;){
            closableWriter.write((Iterable)rows);
        }
        writer.close();
        Assert.assertEquals((long)4L, (long)((DataWriteResult)writer.result()).dataFiles().size());
    }

    @Test
    public void testRollingEqualityDeleteWriterNoRecords() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        RollingEqualityDeleteWriter writer = new RollingEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, this.table.spec(), this.partition);
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
    }

    @Test
    public void testRollingEqualityDeleteWriterSplitDeletes() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        RollingEqualityDeleteWriter writer = new RollingEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 2L, this.table.spec(), this.partition);
        ArrayList deletes = Lists.newArrayListWithExpectedSize((int)4000);
        for (int index = 0; index < 4000; ++index) {
            deletes.add(this.toRow(index, PARTITION_VALUE));
        }
        try (RollingEqualityDeleteWriter closeableWriter = writer;){
            closeableWriter.write((Iterable)deletes);
        }
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assert.assertEquals((long)4L, (long)result.deleteFiles().size());
        Assert.assertEquals((long)0L, (long)result.referencedDataFiles().size());
        Assert.assertFalse((boolean)result.referencesDataFiles());
    }

    @Test
    public void testRollingPositionDeleteWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingPositionDeleteWriter writer = new RollingPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, this.table.spec(), this.partition);
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
        writer.close();
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).deleteFiles().size());
        Assert.assertEquals((long)0L, (long)((DeleteWriteResult)writer.result()).referencedDataFiles().size());
        Assert.assertFalse((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles());
    }

    @Test
    public void testRollingPositionDeleteWriterSplitDeletes() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingPositionDeleteWriter writer = new RollingPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 2L, this.table.spec(), this.partition);
        ArrayList deletes = Lists.newArrayListWithExpectedSize((int)4000);
        for (int index = 0; index < 4000; ++index) {
            deletes.add(this.positionDelete("path/to/data/file-1.parquet", index, null));
        }
        try (RollingPositionDeleteWriter closeableWriter = writer;){
            closeableWriter.write((Iterable)deletes);
        }
        writer.close();
        DeleteWriteResult result = (DeleteWriteResult)writer.result();
        Assert.assertEquals((long)4L, (long)result.deleteFiles().size());
        Assert.assertEquals((long)1L, (long)result.referencedDataFiles().size());
        Assert.assertTrue((boolean)result.referencesDataFiles());
    }
}

