/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecordBuilder;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.AvroSchemaUtil;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.exceptions.ValidationException;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.expressions.UnboundTerm;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.parquet.ParquetMetricsRowGroupFilter;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.OrcFile;
import org.apache.orc.Reader;
import org.apache.orc.TypeDescription;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractBooleanAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestMetricsRowGroupFilter {
    private static final Types.StructType STRUCT_FIELD_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"int_field", (Type)Types.IntegerType.get())});
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"no_stats_parquet", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"required", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"all_nulls", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)5, (String)"some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"struct_not_null", (Type)STRUCT_FIELD_TYPE), Types.NestedField.optional((int)9, (String)"not_in_file", (Type)Types.FloatType.get()), Types.NestedField.optional((int)10, (String)"str", (Type)Types.StringType.get()), Types.NestedField.optional((int)11, (String)"map_not_null", (Type)Types.MapType.ofRequired((int)12, (int)13, (Type)Types.StringType.get(), (Type)Types.IntegerType.get())), Types.NestedField.optional((int)14, (String)"all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)15, (String)"some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)16, (String)"no_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)17, (String)"some_double_nans", (Type)Types.DoubleType.get())});
    private static final Types.StructType UNDERSCORE_STRUCT_FIELD_TYPE = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)8, (String)"_int_field", (Type)Types.IntegerType.get())});
    private static final Schema FILE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"_id", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"_no_stats_parquet", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"_required", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"_all_nulls", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)5, (String)"_some_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)6, (String)"_no_nulls", (Type)Types.StringType.get()), Types.NestedField.optional((int)7, (String)"_struct_not_null", (Type)UNDERSCORE_STRUCT_FIELD_TYPE), Types.NestedField.optional((int)10, (String)"_str", (Type)Types.StringType.get()), Types.NestedField.optional((int)14, (String)"_all_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)15, (String)"_some_nans", (Type)Types.FloatType.get()), Types.NestedField.optional((int)16, (String)"_no_nans", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)17, (String)"_some_double_nans", (Type)Types.DoubleType.get())});
    private static final String TOO_LONG_FOR_STATS_PARQUET;
    private static final int INT_MIN_VALUE = 30;
    private static final int INT_MAX_VALUE = 79;
    private File orcFile = null;
    private MessageType parquetSchema = null;
    private BlockMetaData rowGroupMetadata = null;
    @Parameter
    private FileFormat format;
    @TempDir
    private File tempDir;

    @Parameters(name="fileFormat = {0}")
    public static List<Object> parameters() {
        return Arrays.asList(FileFormat.PARQUET, FileFormat.ORC);
    }

    @BeforeEach
    public void createInputFile() throws IOException {
        switch (this.format) {
            case ORC: {
                this.createOrcInputFile();
                break;
            }
            case PARQUET: {
                this.createParquetInputFile();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Row group filter tests not supported for " + this.format);
            }
        }
    }

    public void createOrcInputFile() throws IOException {
        this.orcFile = File.createTempFile("junit", null, this.tempDir);
        Assertions.assertThat((boolean)this.orcFile.delete()).isTrue();
        OutputFile outFile = Files.localOutput((File)this.orcFile);
        try (FileAppender appender = ORC.write((OutputFile)outFile).schema(FILE_SCHEMA).createWriterFunc(GenericOrcWriter::buildWriter).build();){
            GenericRecord record = GenericRecord.create((Schema)FILE_SCHEMA);
            for (int i = 0; i < 50; ++i) {
                record.setField("_id", (Object)(30 + i));
                record.setField("_no_stats_parquet", (Object)TOO_LONG_FOR_STATS_PARQUET);
                record.setField("_required", (Object)"req");
                record.setField("_all_nulls", null);
                record.setField("_some_nulls", (Object)(i % 10 == 0 ? null : "some"));
                record.setField("_no_nulls", (Object)"");
                record.setField("_str", (Object)(i + "str" + i));
                record.setField("_all_nans", (Object)Double.NaN);
                record.setField("_some_nans", (Object)Float.valueOf(i % 10 == 0 ? Float.NaN : 2.0f));
                record.setField("_some_double_nans", (Object)(i % 10 == 0 ? Double.NaN : 2.0));
                record.setField("_no_nans", (Object)3.0);
                GenericRecord structNotNull = GenericRecord.create((Types.StructType)UNDERSCORE_STRUCT_FIELD_TYPE);
                structNotNull.setField("_int_field", (Object)(30 + i));
                record.setField("_struct_not_null", (Object)structNotNull);
                appender.add((Object)record);
            }
        }
        InputFile inFile = Files.localInput((File)this.orcFile);
        try (Reader reader = OrcFile.createReader((Path)new Path(inFile.location()), (OrcFile.ReaderOptions)OrcFile.readerOptions((Configuration)new Configuration()));){
            ((ListAssert)Assertions.assertThat((List)reader.getStripes()).as("Should create only one stripe", new Object[0])).hasSize(1);
        }
        this.orcFile.deleteOnExit();
    }

    private void createParquetInputFile() throws IOException {
        File parquetFile = File.createTempFile("junit", null, this.tempDir);
        Assertions.assertThat((boolean)parquetFile.delete()).isTrue();
        org.apache.avro.Schema structSchema = AvroSchemaUtil.convert((Type)UNDERSCORE_STRUCT_FIELD_TYPE);
        OutputFile outFile = Files.localOutput((File)parquetFile);
        try (FileAppender appender = Parquet.write((OutputFile)outFile).schema(FILE_SCHEMA).build();){
            GenericRecordBuilder builder = new GenericRecordBuilder(AvroSchemaUtil.convert((Schema)FILE_SCHEMA, (String)"table"));
            for (int i = 0; i < 50; ++i) {
                builder.set("_id", (Object)(30 + i));
                builder.set("_no_stats_parquet", (Object)TOO_LONG_FOR_STATS_PARQUET);
                builder.set("_required", (Object)"req");
                builder.set("_all_nulls", null);
                builder.set("_some_nulls", (Object)(i % 10 == 0 ? null : "some"));
                builder.set("_no_nulls", (Object)"");
                builder.set("_all_nans", (Object)Double.NaN);
                builder.set("_some_nans", (Object)Float.valueOf(i % 10 == 0 ? Float.NaN : 2.0f));
                builder.set("_some_double_nans", (Object)(i % 10 == 0 ? Double.NaN : 2.0));
                builder.set("_no_nans", (Object)3.0);
                builder.set("_str", (Object)(i + "str" + i));
                GenericData.Record structNotNull = new GenericData.Record(structSchema);
                structNotNull.put("_int_field", (Object)(30 + i));
                builder.set("_struct_not_null", (Object)structNotNull);
                appender.add((Object)builder.build());
            }
        }
        InputFile inFile = Files.localInput((File)parquetFile);
        try (ParquetFileReader reader = ParquetFileReader.open((org.apache.parquet.io.InputFile)this.parquetInputFile(inFile));){
            ((ListAssert)Assertions.assertThat((List)reader.getRowGroups()).as("Should create only one row group", new Object[0])).hasSize(1);
            this.rowGroupMetadata = (BlockMetaData)reader.getRowGroups().get(0);
            this.parquetSchema = reader.getFileMetaData().getSchema();
        }
        parquetFile.deleteOnExit();
    }

    @TestTemplate
    public void testAllNulls() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.notNull((String)"all_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: no non-null value in all null column", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.notNull((String)"some_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nulls contains a non-null value", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notNull((String)"no_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: non-null column contains a non-null value", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notNull((String)"map_not_null"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: map type is not skipped", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notNull((String)"struct_not_null"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: struct type is not skipped", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testNoNulls() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.isNull((String)"all_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: at least one null value in all null column", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.isNull((String)"some_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nulls contains a null value", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.isNull((String)"no_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: non-null column contains no null values", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.isNull((String)"map_not_null"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: map type is not skipped", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.isNull((String)"struct_not_null"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: struct type is not skipped", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testFloatWithNan() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"some_nans", (Object)1.0));
        Assertions.assertThat((boolean)shouldRead).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"some_nans", (Object)1.0));
        Assertions.assertThat((boolean)shouldRead).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"some_nans", (Object)3.0));
        Assertions.assertThat((boolean)shouldRead).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"some_nans", (Object)1.0));
        Assertions.assertThat((boolean)shouldRead).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"some_nans", (Object)2.0));
        Assertions.assertThat((boolean)shouldRead).isTrue();
    }

    @TestTemplate
    public void testDoubleWithNan() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"some_double_nans", (Object)1.0));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nans contains target value", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"some_double_nans", (Object)1.0));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nans contains the target value", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"some_double_nans", (Object)3.0));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nans contains target value", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"some_double_nans", (Object)1.0));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nans contains target value", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"some_double_nans", (Object)2.0));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: column with some nans contains target value", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIsNaN() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.isNaN((String)"all_nans"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: NaN counts are not tracked in Parquet metrics", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.isNaN((String)"some_nans"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: NaN counts are not tracked in Parquet metrics", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.isNaN((String)"no_nans"));
        switch (this.format) {
            case ORC: {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read 0 rows due to the ORC filter push-down feature", new Object[0])).isFalse();
                break;
            }
            case PARQUET: {
                ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: NaN counts are not tracked in Parquet metrics", new Object[0])).isTrue();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Row group filter tests not supported for " + this.format);
            }
        }
        shouldRead = this.shouldRead((Expression)Expressions.isNaN((String)"all_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: all null column will not contain nan value", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testNotNaN() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.notNaN((String)"all_nans"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: NaN counts are not tracked in Parquet metrics", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notNaN((String)"some_nans"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: NaN counts are not tracked in Parquet metrics", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notNaN((String)"no_nans"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: NaN counts are not tracked in Parquet metrics", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notNaN((String)"all_nulls"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: NaN counts are not tracked in Parquet metrics", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testRequiredColumn() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.notNull((String)"required"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: required columns are always non-null", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.isNull((String)"required"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: required columns are always non-null", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testMissingColumn() {
        ((AbstractThrowableAssert)((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.shouldRead((Expression)Expressions.lessThan((String)"missing", (Object)5))).as("Should complain about missing column in expression", new Object[0])).isInstanceOf(ValidationException.class)).hasMessageStartingWith("Cannot find field 'missing'");
    }

    @TestTemplate
    public void testColumnNotInFile() {
        Expression[] canMatch;
        Expression[] cannotMatch;
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.format).as("If a column is not in file, ORC does NOT try to apply predicates assuming null values for the column", new Object[0])).isNotEqualTo((Object)FileFormat.ORC);
        for (Expression expr : cannotMatch = new Expression[]{Expressions.lessThan((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.lessThanOrEqual((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.equal((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.greaterThan((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.greaterThanOrEqual((String)"not_in_file", (Object)Float.valueOf(1.0f)), Expressions.notNull((String)"not_in_file")}) {
            boolean shouldRead = this.shouldRead(expr);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip when column is not in file (all nulls): " + expr, new Object[0])).isFalse();
        }
        for (Expression expr : canMatch = new Expression[]{Expressions.isNull((String)"not_in_file"), Expressions.notEqual((String)"not_in_file", (Object)Float.valueOf(1.0f))}) {
            boolean shouldRead = this.shouldRead(expr);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read when column is not in file (all nulls): " + expr, new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testMissingStatsParquet() {
        Expression[] exprs;
        Assumptions.assumeThat((Comparable)this.format).isEqualTo((Object)FileFormat.PARQUET);
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"no_stats_parquet", (Object)"a"), Expressions.lessThanOrEqual((String)"no_stats_parquet", (Object)"b"), Expressions.equal((String)"no_stats_parquet", (Object)"c"), Expressions.greaterThan((String)"no_stats_parquet", (Object)"d"), Expressions.greaterThanOrEqual((String)"no_stats_parquet", (Object)"e"), Expressions.notEqual((String)"no_stats_parquet", (Object)"f"), Expressions.isNull((String)"no_stats_parquet"), Expressions.notNull((String)"no_stats_parquet"), Expressions.startsWith((String)"no_stats_parquet", (String)"a"), Expressions.notStartsWith((String)"no_stats_parquet", (String)"a")}) {
            boolean shouldRead = this.shouldRead(expr);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read when missing stats for expr: " + expr, new Object[0])).isTrue();
        }
    }

    @TestTemplate
    public void testZeroRecordFileParquet() {
        Expression[] exprs;
        Assumptions.assumeThat((Comparable)this.format).isEqualTo((Object)FileFormat.PARQUET);
        BlockMetaData emptyBlock = new BlockMetaData();
        emptyBlock.setRowCount(0L);
        for (Expression expr : exprs = new Expression[]{Expressions.lessThan((String)"id", (Object)5), Expressions.lessThanOrEqual((String)"id", (Object)30), Expressions.equal((String)"id", (Object)70), Expressions.greaterThan((String)"id", (Object)78), Expressions.greaterThanOrEqual((String)"id", (Object)90), Expressions.notEqual((String)"id", (Object)101), Expressions.isNull((String)"some_nulls"), Expressions.notNull((String)"some_nulls")}) {
            boolean shouldRead = this.shouldReadParquet(expr, true, this.parquetSchema, emptyBlock);
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should never read 0-record file: " + expr, new Object[0])).isFalse();
        }
    }

    @TestTemplate
    public void testNot() {
        boolean shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.lessThan((String)"id", (Object)5)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: not(false)", new Object[0])).isTrue();
        shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.greaterThan((String)"id", (Object)5)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: not(true)", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testAnd() {
        boolean shouldRead = this.shouldRead(Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)0)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, true)", new Object[0])).isFalse();
        shouldRead = this.shouldRead(Expressions.and((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: and(false, false)", new Object[0])).isFalse();
        shouldRead = this.shouldRead(Expressions.and((Expression)Expressions.greaterThan((String)"id", (Object)5), (Expression)Expressions.lessThanOrEqual((String)"id", (Object)30)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: and(true, true)", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testOr() {
        boolean shouldRead = this.shouldRead(Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: or(false, false)", new Object[0])).isFalse();
        shouldRead = this.shouldRead(Expressions.or((Expression)Expressions.lessThan((String)"id", (Object)5), (Expression)Expressions.greaterThanOrEqual((String)"id", (Object)60)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: or(false, true)", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerLt() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"id", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"id", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (30 is not < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"id", (Object)31));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"id", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerLtEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"id", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"id", (Object)29));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (29 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"id", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"id", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: many possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerGt() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"id", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"id", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (79 is not > 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"id", (Object)78));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"id", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerGtEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)80));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (80 > 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.equal((String)"id", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"id", (Object)29));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"id", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"id", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"id", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"id", (Object)80));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"id", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testIntegerNotEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)29));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)80));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerNotEqRewritten() {
        boolean shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.equal((String)"id", (Object)5)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.equal((String)"id", (Object)29)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.equal((String)"id", (Object)30)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.equal((String)"id", (Object)75)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.equal((String)"id", (Object)79)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.equal((String)"id", (Object)80)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead(Expressions.not((Expression)Expressions.equal((String)"id", (Object)85)));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldLt() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (30 is not < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)31));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThan((String)"struct_not_null.int_field", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldLtEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (5 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)29));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range below lower bound (29 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.lessThanOrEqual((String)"struct_not_null.int_field", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: many possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldGt() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (79 is not > 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)78));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThan((String)"struct_not_null.int_field", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldGtEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (85 < 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)80));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id range above upper bound (80 > 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: one possible id", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.greaterThanOrEqual((String)"struct_not_null.int_field", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: may possible ids", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testStructFieldEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)29));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)80));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.equal((String)"struct_not_null.int_field", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testStructFieldNotEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)5));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)29));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)30));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)75));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)79));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"id", (Object)80));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"struct_not_null.int_field", (Object)85));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testCaseInsensitive() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.equal((String)"ID", (Object)5), false);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testStringStartsWith() {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.format).as("ORC row group filter does not support StringStartsWith", new Object[0])).isNotEqualTo((Object)FileFormat.ORC);
        boolean shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"1"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"0st"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"1str1"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"1str1_xgd"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"2str"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"9xstr"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"0S"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"x"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.startsWith((String)"str", (String)"9str9aaa"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
    }

    @TestTemplate
    public void testStringNotStartsWith() {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.format).as("ORC row group filter does not support StringStartsWith", new Object[0])).isNotEqualTo((Object)FileFormat.ORC);
        boolean shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"str", (String)"1"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"str", (String)"0st"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"str", (String)"1str1"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"str", (String)"1str1_xgd"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"str", (String)"2str"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"str", (String)"9xstr"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"required", (String)"r"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: range doesn't match", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"required", (String)"requ"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"ssome"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notStartsWith((String)"some_nulls", (String)"som"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: range matches", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerIn() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{5, 6}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound (5 < 30, 6 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{28, 29}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id below lower bound (28 < 30, 29 < 30)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{29, 30}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound (30 == 30)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{75, 76}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds (30 < 75 < 79, 30 < 76 < 79)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{79, 80}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound (79 == 79)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{80, 81}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound (80 > 79, 81 > 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{85, 86}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read: id above upper bound (85 > 79, 86 > 79)", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"all_nulls", (Object[])new Integer[]{1, 2}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: in on all nulls column", new Object[0])).isFalse();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"some_nulls", (Object[])new String[]{"aaa", "some"}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on some nulls column", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"no_nulls", (Object[])new String[]{"aaa", ""}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: in on no nulls column", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testIntegerNotIn() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{5, 6}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound (5 < 30, 6 < 30)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{28, 29}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id below lower bound (28 < 30, 29 < 30)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{29, 30}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to lower bound (30 == 30)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{75, 76}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id between lower and upper bounds (30 < 75 < 79, 30 < 76 < 79)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{79, 80}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id equal to upper bound (79 == 79)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{80, 81}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound (80 > 79, 81 > 79)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"id", (Object[])new Integer[]{85, 86}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: id above upper bound (85 > 79, 86 > 79)", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"all_nulls", (Object[])new Integer[]{1, 2}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on all nulls column", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"some_nulls", (Object[])new String[]{"aaa", "some"}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on some nulls column", new Object[0])).isTrue();
        shouldRead = this.shouldRead((Expression)Expressions.notIn((String)"no_nulls", (Object[])new String[]{"aaa", ""}));
        if (this.format == FileFormat.PARQUET) {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notIn on no nulls column", new Object[0])).isTrue();
        } else {
            ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should skip: notIn on no nulls column", new Object[0])).isFalse();
        }
    }

    @TestTemplate
    public void testSomeNullsNotEq() {
        boolean shouldRead = this.shouldRead((Expression)Expressions.notEqual((String)"some_nulls", (Object)"some"));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: notEqual on some nulls column", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testInLimitParquet() {
        Assumptions.assumeThat((Comparable)this.format).isEqualTo((Object)FileFormat.PARQUET);
        boolean shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Object[])new Integer[]{1, 2}));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should not read if IN is evaluated", new Object[0])).isFalse();
        ArrayList ids = Lists.newArrayListWithExpectedSize((int)400);
        for (int id = -400; id <= 0; ++id) {
            ids.add(id);
        }
        shouldRead = this.shouldRead((Expression)Expressions.in((String)"id", (Iterable)ids));
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read if IN is not evaluated", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testParquetTypePromotion() {
        ((AbstractComparableAssert)Assumptions.assumeThat((Comparable)this.format).as("Only valid for Parquet", new Object[0])).isEqualTo((Object)FileFormat.PARQUET);
        Schema promotedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        boolean shouldRead = new ParquetMetricsRowGroupFilter(promotedSchema, (Expression)Expressions.equal((String)"id", (Object)31), true).shouldRead(this.parquetSchema, this.rowGroupMetadata);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should succeed with promoted schema", new Object[0])).isTrue();
    }

    @TestTemplate
    public void testTransformFilter() {
        Assumptions.assumeThat((Comparable)this.format).isEqualTo((Object)FileFormat.PARQUET);
        boolean shouldRead = new ParquetMetricsRowGroupFilter(SCHEMA, (Expression)Expressions.equal((UnboundTerm)Expressions.truncate((String)"required", (int)2), (Object)"some_value"), true).shouldRead(this.parquetSchema, this.rowGroupMetadata);
        ((AbstractBooleanAssert)Assertions.assertThat((boolean)shouldRead).as("Should read: filter contains non-reference evaluate as True", new Object[0])).isTrue();
    }

    private boolean shouldRead(Expression expression) {
        return this.shouldRead(expression, true);
    }

    private boolean shouldRead(Expression expression, boolean caseSensitive) {
        switch (this.format) {
            case ORC: {
                return this.shouldReadOrc(expression, caseSensitive);
            }
            case PARQUET: {
                return this.shouldReadParquet(expression, caseSensitive, this.parquetSchema, this.rowGroupMetadata);
            }
        }
        throw new UnsupportedOperationException("Row group filter tests not supported for " + this.format);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean shouldReadOrc(Expression expression, boolean caseSensitive) {
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)this.orcFile)).project(SCHEMA).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)SCHEMA, (TypeDescription)fileSchema)).filter(expression).caseSensitive(caseSensitive).build();){
            boolean bl = !Lists.newArrayList((Iterable)reader).isEmpty();
            return bl;
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    private boolean shouldReadParquet(Expression expression, boolean caseSensitive, MessageType messageType, BlockMetaData blockMetaData) {
        return new ParquetMetricsRowGroupFilter(SCHEMA, expression, caseSensitive).shouldRead(messageType, blockMetaData);
    }

    private org.apache.parquet.io.InputFile parquetInputFile(final InputFile inFile) {
        return new org.apache.parquet.io.InputFile(){

            public long getLength() throws IOException {
                return inFile.getLength();
            }

            public SeekableInputStream newStream() throws IOException {
                final org.apache.iceberg.io.SeekableInputStream stream = inFile.newStream();
                return new DelegatingSeekableInputStream((InputStream)stream){

                    public long getPos() throws IOException {
                        return stream.getPos();
                    }

                    public void seek(long newPos) throws IOException {
                        stream.seek(newPos);
                    }
                };
            }
        };
    }

    static {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 200; ++i) {
            sb.append(UUID.randomUUID());
        }
        TOO_LONG_FOR_STATS_PARQUET = sb.toString();
    }
}

