/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileContent;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionKey;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.RowDelta;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestBase;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.deletes.DeleteGranularity;
import org.apache.iceberg.io.BaseTaskWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileAppenderFactory;
import org.apache.iceberg.io.FileIO;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriteResult;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectArrayAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestTaskEqualityDeltaWriter
extends TestBase {
    private static final int FORMAT_V2 = 2;
    private static final long TARGET_FILE_SIZE = 128L;
    private final GenericRecord gRecord = GenericRecord.create((Schema)SCHEMA);
    private final GenericRecord posRecord = GenericRecord.create((Schema)DeleteSchemaUtil.pathPosSchema());
    private OutputFileFactory fileFactory = null;
    private int idFieldId;
    private int dataFieldId;
    @Parameter(index=1)
    protected FileFormat format;

    @Parameters(name="formatVersion = {0}, FileFormat = {0}")
    protected static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, FileFormat.AVRO}, new Object[]{2, FileFormat.ORC}, new Object[]{2, FileFormat.PARQUET});
    }

    @BeforeEach
    public void setupTable() throws IOException {
        this.tableDir = java.nio.file.Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)this.tableDir.delete()).isTrue();
        this.metadataDir = new File(this.tableDir, "metadata");
        this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.format).build();
        this.idFieldId = this.table.schema().findField("id").fieldId();
        this.dataFieldId = this.table.schema().findField("data").fieldId();
        this.table.updateProperties().defaultFormat(this.format).commit();
    }

    private Record createRecord(Integer id, String data) {
        return this.gRecord.copy("id", (Object)id, "data", (Object)data);
    }

    @TestTemplate
    public void testPureInsert() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId, this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        ArrayList expected = Lists.newArrayList();
        for (int i = 0; i < 20; ++i) {
            Record record = this.createRecord(i, String.format("val-%d", i));
            expected.add(record);
            deltaWriter.write(record);
        }
        WriteResult result = deltaWriter.complete();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should only have a data file.", new Object[0])).hasSize(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have no delete file", new Object[0])).hasSize(0);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.expectedRowSet(expected)).as("Should have expected records", new Object[0])).isEqualTo((Object)this.actualRowSet("*"));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        for (int i = 20; i < 30; ++i) {
            Record record = this.createRecord(i, String.format("val-%d", i));
            expected.add(record);
            deltaWriter.write(record);
        }
        result = deltaWriter.complete();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should only have a data file.", new Object[0])).hasSize(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have no delete file", new Object[0])).hasSize(0);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet(expected));
    }

    @TestTemplate
    public void testInsertDuplicatedKey() throws IOException {
        ArrayList equalityFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(equalityFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        deltaWriter.write(this.createRecord(1, "aaa"));
        deltaWriter.write(this.createRecord(2, "bbb"));
        deltaWriter.write(this.createRecord(3, "ccc"));
        deltaWriter.write(this.createRecord(4, "ddd"));
        deltaWriter.write(this.createRecord(4, "eee"));
        deltaWriter.write(this.createRecord(3, "fff"));
        deltaWriter.write(this.createRecord(2, "ggg"));
        deltaWriter.write(this.createRecord(1, "hhh"));
        WriteResult result = deltaWriter.complete();
        this.commitTransaction(result);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should have a data file.", new Object[0])).hasSize(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have a pos-delete file", new Object[0])).hasSize(1);
        DeleteFile posDeleteFile = result.deleteFiles()[0];
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)posDeleteFile.content()).as("Should be a pos-delete file", new Object[0])).isEqualTo((Object)FileContent.POSITION_DELETES);
        Assertions.assertThat((Object[])result.referencedDataFiles()).hasSize(1);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(4, "eee"), (Object)this.createRecord(3, "fff"), (Object)this.createRecord(2, "ggg"), (Object)this.createRecord(1, "hhh"))));
        DataFile dataFile = result.dataFiles()[0];
        Assertions.assertThat(this.readRecordsAsList(this.table.schema(), dataFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.createRecord(1, "aaa"), (Object)this.createRecord(2, "bbb"), (Object)this.createRecord(3, "ccc"), (Object)this.createRecord(4, "ddd"), (Object)this.createRecord(4, "eee"), (Object)this.createRecord(3, "fff"), (Object)this.createRecord(2, "ggg"), (Object)this.createRecord(1, "hhh")));
        Schema posDeleteSchema = DeleteSchemaUtil.pathPosSchema();
        Assertions.assertThat(this.readRecordsAsList(posDeleteSchema, posDeleteFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L), (Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)1L), (Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)2L), (Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)3L)));
    }

    @TestTemplate
    public void testUpsertSameRow() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId, this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        Record record = this.createRecord(1, "aaa");
        deltaWriter.write(record);
        deltaWriter.delete(record);
        deltaWriter.write(record);
        WriteResult result = deltaWriter.complete();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should have a data file.", new Object[0])).hasSize(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have a pos-delete file", new Object[0])).hasSize(1);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have an expected record", new Object[0])).isEqualTo((Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)record)));
        DataFile dataFile = result.dataFiles()[0];
        Assertions.assertThat(this.readRecordsAsList(this.table.schema(), dataFile.path())).isEqualTo((Object)ImmutableList.of((Object)record, (Object)record));
        DeleteFile posDeleteFile = result.deleteFiles()[0];
        Assertions.assertThat(this.readRecordsAsList(DeleteSchemaUtil.pathPosSchema(), posDeleteFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L)));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        deltaWriter.delete(record);
        result = deltaWriter.complete();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should have 0 data file.", new Object[0])).hasSize(0);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have 1 eq-delete file", new Object[0])).hasSize(1);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have no record", new Object[0])).isEqualTo((Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of()));
    }

    @TestTemplate
    public void testUpsertData() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        deltaWriter.write(this.createRecord(1, "aaa"));
        deltaWriter.write(this.createRecord(2, "bbb"));
        deltaWriter.write(this.createRecord(3, "aaa"));
        deltaWriter.write(this.createRecord(3, "ccc"));
        deltaWriter.write(this.createRecord(4, "ccc"));
        WriteResult result = deltaWriter.complete();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should have a data file", new Object[0])).hasSize(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have a pos-delete file for deduplication purpose", new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)result.deleteFiles()[0].content()).as("Should be pos-delete file", new Object[0])).isEqualTo((Object)FileContent.POSITION_DELETES);
        Assertions.assertThat((Object[])result.referencedDataFiles()).hasSize(1);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(2, "bbb"), (Object)this.createRecord(3, "aaa"), (Object)this.createRecord(4, "ccc"))));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        GenericRecord keyRecord = GenericRecord.create((Schema)eqDeleteRowSchema);
        Function<String, Record> keyFunc = data -> keyRecord.copy("data", data);
        deltaWriter.deleteKey(keyFunc.apply("aaa"));
        deltaWriter.write(this.createRecord(5, "aaa"));
        deltaWriter.deleteKey(keyFunc.apply("aaa"));
        deltaWriter.write(this.createRecord(6, "aaa"));
        deltaWriter.deleteKey(keyFunc.apply("ccc"));
        deltaWriter.write(this.createRecord(7, "ccc"));
        deltaWriter.deleteKey(keyFunc.apply("bbb"));
        result = deltaWriter.complete();
        Assertions.assertThat((Object[])result.dataFiles()).hasSize(1);
        Assertions.assertThat((Object[])result.deleteFiles()).hasSize(2);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc"))));
        DataFile dataFile = result.dataFiles()[0];
        Assertions.assertThat(this.readRecordsAsList(this.table.schema(), dataFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.createRecord(5, "aaa"), (Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc")));
        DeleteFile eqDeleteFile = result.deleteFiles()[0];
        Assertions.assertThat((Comparable)eqDeleteFile.content()).isEqualTo((Object)FileContent.EQUALITY_DELETES);
        Assertions.assertThat(this.readRecordsAsList(eqDeleteRowSchema, eqDeleteFile.path())).isEqualTo((Object)ImmutableList.of((Object)keyFunc.apply("aaa"), (Object)keyFunc.apply("ccc"), (Object)keyFunc.apply("bbb")));
        DeleteFile posDeleteFile = result.deleteFiles()[1];
        Schema posDeleteSchema = DeleteSchemaUtil.pathPosSchema();
        Assertions.assertThat((Comparable)posDeleteFile.content()).isEqualTo((Object)FileContent.POSITION_DELETES);
        Assertions.assertThat(this.readRecordsAsList(posDeleteSchema, posDeleteFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L)));
    }

    @TestTemplate
    public void testUpsertDataWithFullRowSchema() throws IOException {
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        deltaWriter.write(this.createRecord(1, "aaa"));
        deltaWriter.write(this.createRecord(2, "bbb"));
        deltaWriter.write(this.createRecord(3, "aaa"));
        deltaWriter.write(this.createRecord(3, "ccc"));
        deltaWriter.write(this.createRecord(4, "ccc"));
        WriteResult result = deltaWriter.complete();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should have a data file", new Object[0])).hasSize(1);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have a pos-delete file for deduplication purpose", new Object[0])).hasSize(1);
        ((AbstractComparableAssert)Assertions.assertThat((Comparable)result.deleteFiles()[0].content()).as("Should be pos-delete file", new Object[0])).isEqualTo((Object)FileContent.POSITION_DELETES);
        Assertions.assertThat((Object[])result.referencedDataFiles()).hasSize(1);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(2, "bbb"), (Object)this.createRecord(3, "aaa"), (Object)this.createRecord(4, "ccc"))));
        deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, DeleteGranularity.PARTITION);
        deltaWriter.delete(this.createRecord(3, "aaa"));
        deltaWriter.write(this.createRecord(5, "aaa"));
        deltaWriter.delete(this.createRecord(5, "aaa"));
        deltaWriter.write(this.createRecord(6, "aaa"));
        deltaWriter.delete(this.createRecord(4, "ccc"));
        deltaWriter.write(this.createRecord(7, "ccc"));
        deltaWriter.delete(this.createRecord(2, "bbb"));
        result = deltaWriter.complete();
        Assertions.assertThat((Object[])result.dataFiles()).hasSize(1);
        Assertions.assertThat((Object[])result.deleteFiles()).hasSize(2);
        Assertions.assertThat((Object[])result.referencedDataFiles()).hasSize(1);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have expected records", new Object[0])).isEqualTo((Object)this.expectedRowSet((Iterable<Record>)ImmutableList.of((Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc"))));
        DataFile dataFile = result.dataFiles()[0];
        Assertions.assertThat(this.readRecordsAsList(this.table.schema(), dataFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.createRecord(5, "aaa"), (Object)this.createRecord(6, "aaa"), (Object)this.createRecord(7, "ccc")));
        DeleteFile eqDeleteFile = result.deleteFiles()[0];
        Assertions.assertThat((Comparable)eqDeleteFile.content()).isEqualTo((Object)FileContent.EQUALITY_DELETES);
        Assertions.assertThat(this.readRecordsAsList(eqDeleteRowSchema, eqDeleteFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.createRecord(3, "aaa"), (Object)this.createRecord(4, "ccc"), (Object)this.createRecord(2, "bbb")));
        DeleteFile posDeleteFile = result.deleteFiles()[1];
        Schema posDeleteSchema = DeleteSchemaUtil.pathPosSchema();
        Assertions.assertThat((Comparable)posDeleteFile.content()).isEqualTo((Object)FileContent.POSITION_DELETES);
        Assertions.assertThat(this.readRecordsAsList(posDeleteSchema, posDeleteFile.path())).isEqualTo((Object)ImmutableList.of((Object)this.posRecord.copy("file_path", (Object)dataFile.path(), "pos", (Object)0L)));
    }

    @TestTemplate
    public void testDeleteFileGranularity() throws IOException {
        this.withGranularity(DeleteGranularity.FILE);
    }

    @TestTemplate
    public void testDeletePartitionGranularity() throws IOException {
        this.withGranularity(DeleteGranularity.PARTITION);
    }

    private void withGranularity(DeleteGranularity granularity) throws IOException {
        int i;
        ArrayList eqDeleteFieldIds = Lists.newArrayList((Object[])new Integer[]{this.idFieldId, this.dataFieldId});
        Schema eqDeleteRowSchema = this.table.schema();
        GenericTaskDeltaWriter deltaWriter = this.createTaskWriter(eqDeleteFieldIds, eqDeleteRowSchema, granularity);
        HashMap expected = Maps.newHashMapWithExpectedSize((int)2000);
        int expectedDeleteCount = 0;
        for (i = 0; i < 2000; ++i) {
            Record record = this.createRecord(i, "aaa" + i);
            deltaWriter.write(record);
            if (i % 5 == 0) {
                deltaWriter.delete(record);
                ++expectedDeleteCount;
                continue;
            }
            expected.put(i, record);
        }
        for (i = 0; i < 199; ++i) {
            int id = i * 10 + 1;
            Record record = this.createRecord(id, "aaa" + id);
            deltaWriter.delete(record);
            ++expectedDeleteCount;
            expected.remove(id);
        }
        WriteResult result = deltaWriter.complete();
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.dataFiles()).as("Should have 2 data files.", new Object[0])).hasSize(2);
        ((ObjectArrayAssert)Assertions.assertThat((Object[])result.deleteFiles()).as("Should have correct number of pos-delete files", new Object[0])).hasSize(granularity.equals((Object)DeleteGranularity.FILE) ? 2 : 1);
        Assertions.assertThat((long)Arrays.stream(result.deleteFiles()).mapToLong(delete -> delete.recordCount()).sum()).isEqualTo((long)expectedDeleteCount);
        this.commitTransaction(result);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.actualRowSet("*")).as("Should have expected record", new Object[0])).isEqualTo((Object)this.expectedRowSet(expected.values()));
    }

    private void commitTransaction(WriteResult result) {
        RowDelta rowDelta = this.table.newRowDelta();
        Arrays.stream(result.dataFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addRows(arg_0));
        Arrays.stream(result.deleteFiles()).forEach(arg_0 -> ((RowDelta)rowDelta).addDeletes(arg_0));
        rowDelta.validateDeletedFiles().validateDataFilesExist((Iterable)Lists.newArrayList((Object[])result.referencedDataFiles())).commit();
    }

    private StructLikeSet expectedRowSet(Iterable<Record> records) {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        records.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    private StructLikeSet actualRowSet(String ... columns) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        try (CloseableIterable reader = IcebergGenerics.read((Table)this.table).select(columns).build();){
            reader.forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        }
        return set;
    }

    private GenericTaskDeltaWriter createTaskWriter(List<Integer> equalityFieldIds, Schema eqDeleteRowSchema, DeleteGranularity deleteGranularity) {
        GenericAppenderFactory appenderFactory = new GenericAppenderFactory(this.table.schema(), this.table.spec(), ArrayUtil.toIntArray(equalityFieldIds), eqDeleteRowSchema, null);
        ArrayList columns = Lists.newArrayList();
        for (Integer fieldId : equalityFieldIds) {
            columns.add(this.table.schema().findField(fieldId.intValue()).name());
        }
        Schema deleteSchema = this.table.schema().select((Collection)columns);
        return new GenericTaskDeltaWriter(this.table.schema(), deleteSchema, this.table.spec(), this.format, (FileAppenderFactory)appenderFactory, this.fileFactory, this.table.io(), 128L, deleteGranularity);
    }

    private List<Record> readRecordsAsList(Schema schema, CharSequence path) throws IOException {
        AvroIterable iterable;
        InputFile inputFile = Files.localInput((String)path.toString());
        switch (this.format) {
            case PARQUET: {
                iterable = Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();
                break;
            }
            case AVRO: {
                iterable = Avro.read((InputFile)inputFile).project(schema).createReaderFunc(DataReader::create).build();
                break;
            }
            case ORC: {
                iterable = ORC.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)fileSchema)).build();
                break;
            }
            default: {
                throw new UnsupportedOperationException("Unsupported file format: " + this.format);
            }
        }
        try (AvroIterable closeableIterable = iterable;){
            ArrayList arrayList = Lists.newArrayList((Iterable)closeableIterable);
            return arrayList;
        }
    }

    private static class GenericTaskDeltaWriter
    extends BaseTaskWriter<Record> {
        private final GenericEqualityDeltaWriter deltaWriter;

        private GenericTaskDeltaWriter(Schema schema, Schema deleteSchema, PartitionSpec spec, FileFormat format, FileAppenderFactory<Record> appenderFactory, OutputFileFactory fileFactory, FileIO io, long targetFileSize, DeleteGranularity deleteGranularity) {
            super(spec, format, appenderFactory, fileFactory, io, targetFileSize);
            this.deltaWriter = new GenericEqualityDeltaWriter(null, schema, deleteSchema, deleteGranularity);
        }

        public void write(Record row) throws IOException {
            this.deltaWriter.write(row);
        }

        public void delete(Record row) throws IOException {
            this.deltaWriter.delete(row);
        }

        public void deleteKey(Record key) throws IOException {
            this.deltaWriter.deleteKey(key);
        }

        public void close() throws IOException {
            this.deltaWriter.close();
        }

        private class GenericEqualityDeltaWriter
        extends BaseTaskWriter.BaseEqualityDeltaWriter {
            private GenericEqualityDeltaWriter(PartitionKey partition, Schema schema, Schema eqDeleteSchema, DeleteGranularity deleteGranularity) {
                super((BaseTaskWriter)GenericTaskDeltaWriter.this, (StructLike)partition, schema, eqDeleteSchema, deleteGranularity);
            }

            protected StructLike asStructLike(Record row) {
                return row;
            }

            protected StructLike asStructLikeKey(Record data) {
                return data;
            }
        }
    }
}

