/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.SortOrder;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractComparableAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestWriterMetrics<T> {
    private static final int FORMAT_V2 = 2;
    protected static final Types.NestedField ID_FIELD = Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get());
    protected static final Types.NestedField DATA_FIELD = Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get());
    protected static final Types.StructType NESTED_FIELDS = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"booleanField", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)5, (String)"longValue", (Type)Types.LongType.get())});
    protected static final Types.NestedField STRUCT_FIELD = Types.NestedField.optional((int)3, (String)"structField", (Type)NESTED_FIELDS);
    protected static final Schema SCHEMA = new Schema(new Types.NestedField[]{ID_FIELD, DATA_FIELD, STRUCT_FIELD});
    protected static final SortOrder SORT_ORDER = ((SortOrder.Builder)((SortOrder.Builder)SortOrder.builderFor((Schema)SCHEMA).asc("id")).asc("structField.longValue")).build();
    protected static final Map<String, String> PROPERTIES = ImmutableMap.of((Object)"write.metadata.metrics.default", (Object)"none");
    @TempDir
    private File tempDir;
    protected FileFormat fileFormat;
    protected TestTables.TestTable table = null;
    private OutputFileFactory fileFactory = null;

    @Parameters(name="fileFormat = {0}")
    public static List<Object> parameters() {
        return Arrays.asList(FileFormat.ORC, FileFormat.PARQUET);
    }

    public TestWriterMetrics(FileFormat fileFormat) {
        this.fileFormat = fileFormat;
    }

    protected abstract FileWriterFactory<T> newWriterFactory(Table var1);

    protected abstract T toRow(Integer var1, String var2, boolean var3, Long var4);

    protected abstract T toGenericRow(int var1, int var2);

    @BeforeEach
    public void setupTable() throws Exception {
        File tableDir = Files.createTempDirectory(this.tempDir.toPath(), "junit", new FileAttribute[0]).toFile();
        tableDir.delete();
        this.table = TestTables.create((File)tableDir, (String)"test", (Schema)SCHEMA, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)SORT_ORDER, (int)2);
        this.table.updateProperties().set("write.metadata.metrics.default", "none").commit();
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @AfterEach
    public void after() {
        TestTables.clearTables();
    }

    @TestTemplate
    public void verifySortedColMetric() throws Exception {
        T row = this.toRow(3, "3", true, 3L);
        DataWriter dataWriter = this.newWriterFactory((Table)this.table).newDataWriter(this.fileFactory.newOutputFile(), PartitionSpec.unpartitioned(), null);
        dataWriter.write(row);
        dataWriter.close();
        DataFile dataFile = dataWriter.toDataFile();
        Map lowerBounds = dataFile.lowerBounds();
        Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(1))))).isEqualTo(3);
        Assertions.assertThat((Map)lowerBounds).doesNotContainKey((Object)2);
        Assertions.assertThat((Map)lowerBounds).doesNotContainKey((Object)3);
        Assertions.assertThat((Map)lowerBounds).doesNotContainKey((Object)4);
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(5))))).isEqualTo(3L);
        Map upperBounds = dataFile.upperBounds();
        Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(1))))).isEqualTo(3);
        Assertions.assertThat((Map)upperBounds).doesNotContainKey((Object)2);
        Assertions.assertThat((Map)upperBounds).doesNotContainKey((Object)3);
        Assertions.assertThat((Map)upperBounds).doesNotContainKey((Object)4);
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(5))))).isEqualTo(3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testPositionDeleteMetrics() throws IOException {
        FileWriterFactory<T> writerFactory = this.newWriterFactory((Table)this.table);
        EncryptedOutputFile outputFile = this.fileFactory.newOutputFile();
        try (PositionDeleteWriter deleteWriter = writerFactory.newPositionDeleteWriter(outputFile, this.table.spec(), null);){
            T deletedRow = this.toRow(3, "3", true, 3L);
            PositionDelete positionDelete = PositionDelete.create();
            positionDelete.set((CharSequence)"File A", 1L, deletedRow);
            deleteWriter.write(positionDelete);
        }
        DeleteFile deleteFile = deleteWriter.toDeleteFile();
        int pathFieldId = MetadataColumns.DELETE_FILE_PATH.fieldId();
        int posFieldId = MetadataColumns.DELETE_FILE_POS.fieldId();
        Map lowerBounds = deleteFile.lowerBounds();
        Assertions.assertThat((Object)Conversions.fromByteBuffer((Type)Types.StringType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(pathFieldId)))).isEqualTo((Object)CharBuffer.wrap("File A"));
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(posFieldId))))).isEqualTo(1L);
        Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(1))))).isEqualTo(3);
        Assertions.assertThat((Map)lowerBounds).doesNotContainKey((Object)2);
        Assertions.assertThat((Map)lowerBounds).doesNotContainKey((Object)3);
        Assertions.assertThat((Map)lowerBounds).doesNotContainKey((Object)4);
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(5))))).isEqualTo(3L);
        Map upperBounds = deleteFile.upperBounds();
        Assertions.assertThat((Object)Conversions.fromByteBuffer((Type)Types.StringType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(pathFieldId)))).isEqualTo((Object)CharBuffer.wrap("File A"));
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(posFieldId))))).isEqualTo(1L);
        Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(1))))).isEqualTo(3);
        Assertions.assertThat((Map)upperBounds).doesNotContainKey((Object)2);
        Assertions.assertThat((Map)upperBounds).doesNotContainKey((Object)3);
        Assertions.assertThat((Map)upperBounds).doesNotContainKey((Object)4);
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(5))))).isEqualTo(3L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @TestTemplate
    public void testPositionDeleteMetricsCoveringMultipleDataFiles() throws IOException {
        FileWriterFactory<T> writerFactory = this.newWriterFactory((Table)this.table);
        EncryptedOutputFile outputFile = this.fileFactory.newOutputFile();
        try (PositionDeleteWriter deleteWriter = writerFactory.newPositionDeleteWriter(outputFile, this.table.spec(), null);){
            PositionDelete positionDelete = PositionDelete.create();
            positionDelete.set((CharSequence)"File A", 1L, this.toRow(3, "3", true, 3L));
            deleteWriter.write(positionDelete);
            positionDelete.set((CharSequence)"File B", 1L, this.toRow(3, "3", true, 3L));
            deleteWriter.write(positionDelete);
        }
        DeleteFile deleteFile = deleteWriter.toDeleteFile();
        Map lowerBounds = deleteFile.lowerBounds();
        Assertions.assertThat((Map)lowerBounds).hasSize(2);
        Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(1))))).isEqualTo(3);
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(5))))).isEqualTo(3L);
        Map upperBounds = deleteFile.upperBounds();
        Assertions.assertThat((Map)upperBounds).hasSize(2);
        Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(1))))).isEqualTo(3);
        Assertions.assertThat((long)((Long)Conversions.fromByteBuffer((Type)Types.LongType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(5))))).isEqualTo(3L);
    }

    @TestTemplate
    public void testMaxColumns() throws IOException {
        int id;
        File tableDir = Files.createTempDirectory(this.tempDir.toPath(), "table", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)tableDir.delete()).isTrue();
        int numColumns = 101;
        ArrayList fields = Lists.newArrayListWithCapacity((int)numColumns);
        for (int i = 0; i < numColumns; ++i) {
            fields.add(Types.NestedField.required((int)i, (String)("col" + i), (Type)Types.IntegerType.get()));
        }
        Schema maxColSchema = new Schema((List)fields);
        TestTables.TestTable maxColumnTable = TestTables.create((File)tableDir, (String)"max_col_table", (Schema)maxColSchema, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)SortOrder.unsorted(), (int)2);
        OutputFileFactory maxColFactory = OutputFileFactory.builderFor((Table)maxColumnTable, (int)1, (long)1L).format(this.fileFormat).build();
        T row = this.toGenericRow(1, numColumns);
        DataWriter dataWriter = this.newWriterFactory((Table)maxColumnTable).newDataWriter(maxColFactory.newOutputFile(), PartitionSpec.unpartitioned(), null);
        dataWriter.write(row);
        dataWriter.close();
        DataFile dataFile = dataWriter.toDataFile();
        for (id = 1; id <= 100; ++id) {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ByteBuffer)dataFile.lowerBounds().get(id))).as("Should have lower bound metrics", new Object[0])).isNotNull();
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ByteBuffer)dataFile.upperBounds().get(id))).as("Should have upper bound metrics", new Object[0])).isNotNull();
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)dataFile.nanValueCounts().get(id))).as("Should not have nan value metrics (not floating point)", new Object[0])).isNull();
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)dataFile.nullValueCounts().get(id))).as("Should have null value metrics", new Object[0])).isNotNull();
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)dataFile.valueCounts().get(id))).as("Should have value metrics", new Object[0])).isNotNull();
        }
        while (id <= numColumns) {
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ByteBuffer)dataFile.lowerBounds().get(id))).as("Should not have any lower bound metrics", new Object[0])).isNull();
            ((AbstractComparableAssert)Assertions.assertThat((Comparable)((ByteBuffer)dataFile.upperBounds().get(id))).as("Should not have any upper bound metrics", new Object[0])).isNull();
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)dataFile.nanValueCounts().get(id))).as("Should not have any nan value metrics", new Object[0])).isNull();
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)dataFile.nullValueCounts().get(id))).as("Should not have any null value metrics", new Object[0])).isNull();
            ((AbstractLongAssert)Assertions.assertThat((Long)((Long)dataFile.valueCounts().get(id))).as("Should not have any value metrics", new Object[0])).isNull();
            ++id;
        }
    }

    @TestTemplate
    public void testMaxColumnsWithDefaultOverride() throws IOException {
        File tableDir = Files.createTempDirectory(this.tempDir.toPath(), "table", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)tableDir.delete()).isTrue();
        int numColumns = 101;
        ArrayList fields = Lists.newArrayListWithCapacity((int)numColumns);
        for (int i = 0; i < numColumns; ++i) {
            fields.add(Types.NestedField.required((int)i, (String)("col" + i), (Type)Types.IntegerType.get()));
        }
        Schema maxColSchema = new Schema((List)fields);
        TestTables.TestTable maxColumnTable = TestTables.create((File)tableDir, (String)"max_col_table", (Schema)maxColSchema, (PartitionSpec)PartitionSpec.unpartitioned(), (SortOrder)SortOrder.unsorted(), (int)2);
        maxColumnTable.updateProperties().set("write.metadata.metrics.default", "truncate(16)").commit();
        OutputFileFactory maxColFactory = OutputFileFactory.builderFor((Table)maxColumnTable, (int)1, (long)1L).format(this.fileFormat).build();
        T row = this.toGenericRow(1, numColumns);
        DataWriter dataWriter = this.newWriterFactory((Table)maxColumnTable).newDataWriter(maxColFactory.newOutputFile(), PartitionSpec.unpartitioned(), null);
        dataWriter.write(row);
        dataWriter.close();
        DataFile dataFile = dataWriter.toDataFile();
        Map upperBounds = dataFile.upperBounds();
        Map lowerBounds = dataFile.upperBounds();
        for (int i = 0; i < numColumns; ++i) {
            Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)upperBounds.get(1))))).isEqualTo(1);
            Assertions.assertThat((int)((Integer)Conversions.fromByteBuffer((Type)Types.IntegerType.get(), (ByteBuffer)((ByteBuffer)lowerBounds.get(1))))).isEqualTo(1);
        }
    }
}

