/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Metrics;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Conversions;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.NaNUtil;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestMergingMetrics<T> {
    protected static final Types.NestedField ID_FIELD = Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get());
    protected static final Types.NestedField DATA_FIELD = Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get());
    protected static final Types.NestedField FLOAT_FIELD = Types.NestedField.required((int)3, (String)"float", (Type)Types.FloatType.get());
    protected static final Types.NestedField DOUBLE_FIELD = Types.NestedField.optional((int)4, (String)"double", (Type)Types.DoubleType.get());
    protected static final Types.NestedField DECIMAL_FIELD = Types.NestedField.optional((int)5, (String)"decimal", (Type)Types.DecimalType.of((int)5, (int)3));
    protected static final Types.NestedField FIXED_FIELD = Types.NestedField.optional((int)7, (String)"fixed", (Type)Types.FixedType.ofLength((int)4));
    protected static final Types.NestedField BINARY_FIELD = Types.NestedField.optional((int)8, (String)"binary", (Type)Types.BinaryType.get());
    protected static final Types.NestedField FLOAT_LIST = Types.NestedField.optional((int)9, (String)"floatlist", (Type)Types.ListType.ofRequired((int)10, (Type)Types.FloatType.get()));
    protected static final Types.NestedField LONG_FIELD = Types.NestedField.optional((int)11, (String)"long", (Type)Types.LongType.get());
    protected static final Types.NestedField MAP_FIELD_1 = Types.NestedField.optional((int)17, (String)"map1", (Type)Types.MapType.ofOptional((int)18, (int)19, (Type)Types.FloatType.get(), (Type)Types.StringType.get()));
    protected static final Types.NestedField MAP_FIELD_2 = Types.NestedField.optional((int)20, (String)"map2", (Type)Types.MapType.ofOptional((int)21, (int)22, (Type)Types.IntegerType.get(), (Type)Types.DoubleType.get()));
    protected static final Types.NestedField STRUCT_FIELD = Types.NestedField.optional((int)23, (String)"structField", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)24, (String)"booleanField", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)25, (String)"date", (Type)Types.DateType.get()), Types.NestedField.optional((int)27, (String)"timestamp", (Type)Types.TimestampType.withZone())}));
    private static final Map<Types.NestedField, Integer> FIELDS_WITH_NAN_COUNT_TO_ID = ImmutableMap.of((Object)FLOAT_FIELD, (Object)3, (Object)DOUBLE_FIELD, (Object)4, (Object)FLOAT_LIST, (Object)10, (Object)MAP_FIELD_1, (Object)18, (Object)MAP_FIELD_2, (Object)22);
    protected static final Schema SCHEMA = new Schema(new Types.NestedField[]{ID_FIELD, DATA_FIELD, FLOAT_FIELD, DOUBLE_FIELD, DECIMAL_FIELD, FIXED_FIELD, BINARY_FIELD, FLOAT_LIST, LONG_FIELD, MAP_FIELD_1, MAP_FIELD_2, STRUCT_FIELD});
    @Parameter
    protected FileFormat fileFormat;
    @TempDir
    protected File tempDir;

    protected abstract FileAppender<T> writeAndGetAppender(List<Record> var1) throws Exception;

    @Parameters(name="fileFormat = {0}")
    public static List<Object> parameters() {
        return Arrays.asList(FileFormat.PARQUET, FileFormat.ORC);
    }

    @TestTemplate
    public void verifySingleRecordMetric() throws Exception {
        GenericRecord record = GenericRecord.create((Schema)SCHEMA);
        record.setField(ID_FIELD.name(), (Object)3);
        record.setField(FLOAT_FIELD.name(), (Object)Float.valueOf(Float.NaN));
        record.setField(DOUBLE_FIELD.name(), (Object)Double.NaN);
        record.setField(FLOAT_LIST.name(), (Object)ImmutableList.of((Object)Float.valueOf(3.3f), (Object)Float.valueOf(2.8f), (Object)Float.valueOf(Float.NaN), (Object)Float.valueOf(-25.1f), (Object)Float.valueOf(Float.NaN)));
        record.setField(MAP_FIELD_1.name(), (Object)ImmutableMap.of((Object)Float.valueOf(Float.NaN), (Object)"a", (Object)Float.valueOf(0.0f), (Object)"b"));
        record.setField(MAP_FIELD_2.name(), (Object)ImmutableMap.of((Object)0, (Object)0.0, (Object)1, (Object)Double.NaN, (Object)2, (Object)2.0, (Object)3, (Object)Double.NaN, (Object)4, (Object)Double.NaN));
        FileAppender<T> appender = this.writeAndGetAppender((List<Record>)ImmutableList.of((Object)record));
        Metrics metrics = appender.metrics();
        Map nanValueCount = metrics.nanValueCounts();
        Map upperBounds = metrics.upperBounds();
        Map lowerBounds = metrics.lowerBounds();
        this.assertNaNCountMatch(1L, nanValueCount, FLOAT_FIELD);
        this.assertNaNCountMatch(1L, nanValueCount, DOUBLE_FIELD);
        this.assertNaNCountMatch(2L, nanValueCount, FLOAT_LIST);
        this.assertNaNCountMatch(1L, nanValueCount, MAP_FIELD_1);
        this.assertNaNCountMatch(3L, nanValueCount, MAP_FIELD_2);
        this.assertBoundValueMatch(null, upperBounds, FLOAT_FIELD);
        this.assertBoundValueMatch(null, upperBounds, DOUBLE_FIELD);
        this.assertBoundValueMatch(Float.valueOf(3.3f), upperBounds, FLOAT_LIST);
        this.assertBoundValueMatch(Float.valueOf(0.0f), upperBounds, MAP_FIELD_1);
        this.assertBoundValueMatch(2.0, upperBounds, MAP_FIELD_2);
        this.assertBoundValueMatch(null, lowerBounds, FLOAT_FIELD);
        this.assertBoundValueMatch(null, lowerBounds, DOUBLE_FIELD);
        this.assertBoundValueMatch(Float.valueOf(-25.1f), lowerBounds, FLOAT_LIST);
        this.assertBoundValueMatch(Float.valueOf(0.0f), lowerBounds, MAP_FIELD_1);
        this.assertBoundValueMatch(0.0, lowerBounds, MAP_FIELD_2);
    }

    @TestTemplate
    public void verifyRandomlyGeneratedRecordsMetric() throws Exception {
        List<Record> recordList = RandomGenericData.generate(SCHEMA, 5, 250L);
        FileAppender<T> appender = this.writeAndGetAppender(recordList);
        HashMap expectedUpperBounds = Maps.newHashMap();
        HashMap expectedLowerBounds = Maps.newHashMap();
        HashMap expectedNaNCount = Maps.newHashMap();
        this.populateExpectedValues(recordList, expectedUpperBounds, expectedLowerBounds, expectedNaNCount);
        Metrics metrics = appender.metrics();
        expectedUpperBounds.forEach((key, value) -> this.assertBoundValueMatch((Number)value.get(), metrics.upperBounds(), (Types.NestedField)key));
        expectedLowerBounds.forEach((key, value) -> this.assertBoundValueMatch((Number)value.get(), metrics.lowerBounds(), (Types.NestedField)key));
        expectedNaNCount.forEach((key, value) -> this.assertNaNCountMatch(value.get(), metrics.nanValueCounts(), (Types.NestedField)key));
        SCHEMA.columns().stream().filter(column -> !FIELDS_WITH_NAN_COUNT_TO_ID.containsKey(column)).map(Types.NestedField::fieldId).forEach(id -> ((AbstractLongAssert)Assertions.assertThat((Long)((Long)metrics.nanValueCounts().get(id))).as("NaN count for field %s should be null", new Object[0])).isNull());
    }

    private void assertNaNCountMatch(Long expected, Map<Integer, Long> nanValueCount, Types.NestedField field) {
        ((MapAssert)Assertions.assertThat(nanValueCount).as(String.format("NaN count for field %s does not match expected", field.name()), new Object[0])).containsEntry((Object)FIELDS_WITH_NAN_COUNT_TO_ID.get(field), (Object)expected);
    }

    private void assertBoundValueMatch(Number expected, Map<Integer, ByteBuffer> boundMap, Types.NestedField field) {
        if (field.type().isNestedType() && this.fileFormat == FileFormat.ORC) {
            return;
        }
        int actualFieldId = FIELDS_WITH_NAN_COUNT_TO_ID.get(field);
        ByteBuffer byteBuffer = boundMap.get(actualFieldId);
        Type type = SCHEMA.findType(actualFieldId);
        ((ObjectAssert)Assertions.assertThat(byteBuffer == null ? null : Conversions.fromByteBuffer((Type)type, (ByteBuffer)byteBuffer)).as(String.format("Bound value for field %s must match", field.name()), new Object[0])).isEqualTo((Object)expected);
    }

    private void populateExpectedValues(List<Record> records, Map<Types.NestedField, AtomicReference<Number>> upperBounds, Map<Types.NestedField, AtomicReference<Number>> lowerBounds, Map<Types.NestedField, AtomicLong> expectedNaNCount) {
        for (Types.NestedField field : FIELDS_WITH_NAN_COUNT_TO_ID.keySet()) {
            expectedNaNCount.put(field, new AtomicLong(0L));
        }
        for (Record record : records) {
            Map map2;
            Map map1;
            this.updateExpectedValuePerRecord(upperBounds, lowerBounds, expectedNaNCount, FLOAT_FIELD, (Float)record.getField(FLOAT_FIELD.name()));
            this.updateExpectedValuePerRecord(upperBounds, lowerBounds, expectedNaNCount, DOUBLE_FIELD, (Double)record.getField(DOUBLE_FIELD.name()));
            List floatList = (List)record.getField(FLOAT_LIST.name());
            if (floatList != null) {
                this.updateExpectedValueFromRecords(upperBounds, lowerBounds, expectedNaNCount, FLOAT_LIST, floatList);
            }
            if ((map1 = (Map)record.getField(MAP_FIELD_1.name())) != null) {
                this.updateExpectedValueFromRecords(upperBounds, lowerBounds, expectedNaNCount, MAP_FIELD_1, map1.keySet());
            }
            if ((map2 = (Map)record.getField(MAP_FIELD_2.name())) == null) continue;
            this.updateExpectedValueFromRecords(upperBounds, lowerBounds, expectedNaNCount, MAP_FIELD_2, map2.values());
        }
    }

    private <T1 extends Number> void updateExpectedValueFromRecords(Map<Types.NestedField, AtomicReference<Number>> upperBounds, Map<Types.NestedField, AtomicReference<Number>> lowerBounds, Map<Types.NestedField, AtomicLong> expectedNaNCount, Types.NestedField key, Collection<T1> vals) {
        List nonNullNumbers = vals.stream().filter(v -> !NaNUtil.isNaN((Object)v)).collect(Collectors.toList());
        Optional<Number> maxOptional = nonNullNumbers.stream().filter(Objects::nonNull).reduce((v1, v2) -> this.getMinOrMax((Number)v1, (Number)v2, true));
        Optional<Number> minOptional = nonNullNumbers.stream().filter(Objects::nonNull).reduce((v1, v2) -> this.getMinOrMax((Number)v1, (Number)v2, false));
        expectedNaNCount.get(key).addAndGet(vals.size() - nonNullNumbers.size());
        maxOptional.ifPresent(max -> this.updateBound(key, (Number)max, upperBounds, true));
        minOptional.ifPresent(min -> this.updateBound(key, (Number)min, lowerBounds, false));
    }

    private void updateExpectedValuePerRecord(Map<Types.NestedField, AtomicReference<Number>> upperBounds, Map<Types.NestedField, AtomicReference<Number>> lowerBounds, Map<Types.NestedField, AtomicLong> expectedNaNCount, Types.NestedField key, Number val) {
        if (NaNUtil.isNaN((Object)val)) {
            expectedNaNCount.get(key).incrementAndGet();
        } else if (val != null) {
            this.updateBound(key, val, upperBounds, true);
            this.updateBound(key, val, lowerBounds, false);
        }
    }

    private void updateBound(Types.NestedField key, Number val, Map<Types.NestedField, AtomicReference<Number>> bounds, boolean isMax) {
        bounds.computeIfAbsent(key, k -> new AtomicReference<Number>(val)).updateAndGet(old -> this.getMinOrMax((Number)old, val, isMax));
    }

    private Number getMinOrMax(Number val1, Number val2, boolean isMax) {
        if (val1 instanceof Double) {
            return isMax ? Double.max((Double)val1, (Double)val2) : Double.min((Double)val1, (Double)val2);
        }
        return Float.valueOf(isMax ? Float.max(((Float)val1).floatValue(), ((Float)val2).floatValue()) : Float.min(((Float)val1).floatValue(), ((Float)val2).floatValue()));
    }
}

