/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestHelpers;
import org.apache.iceberg.data.FileHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.ArrayUtil;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.DateTimeUtil;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.iceberg.util.StructProjection;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.io.TempDir;

public abstract class DeleteReadTests {
    public static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    public static final Schema DATE_SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"dt", (Type)Types.DateType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)3, (String)"id", (Type)Types.IntegerType.get())});
    public static final PartitionSpec SPEC = PartitionSpec.builderFor((Schema)SCHEMA).bucket("data", 16).build();
    public static final PartitionSpec DATE_SPEC = PartitionSpec.builderFor((Schema)DATE_SCHEMA).day("dt").build();
    @TempDir
    protected Path temp;
    protected String tableName = null;
    protected String dateTableName = null;
    protected Table table = null;
    protected Table dateTable = null;
    protected List<Record> records = null;
    private List<Record> dateRecords = null;
    protected DataFile dataFile = null;
    @Parameter
    protected FileFormat format;

    @Parameters(name="fileFormat = {0}")
    public static Object[][] parameters() {
        return new Object[][]{{FileFormat.PARQUET}, {FileFormat.AVRO}, {FileFormat.ORC}};
    }

    @BeforeEach
    public void writeTestDataFile() throws IOException {
        this.tableName = "test";
        this.table = this.createTable(this.tableName, SCHEMA, SPEC);
        this.records = Lists.newArrayList();
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        this.records.add(record.copy("id", (Object)29, "data", (Object)"a"));
        this.records.add(record.copy("id", (Object)43, "data", (Object)"b"));
        this.records.add(record.copy("id", (Object)61, "data", (Object)"c"));
        this.records.add(record.copy("id", (Object)89, "data", (Object)"d"));
        this.records.add(record.copy("id", (Object)100, "data", (Object)"e"));
        this.records.add(record.copy("id", (Object)121, "data", (Object)"f"));
        this.records.add(record.copy("id", (Object)122, "data", (Object)"g"));
        this.dataFile = FileHelpers.writeDataFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), this.records);
        this.table.newAppend().appendFile(this.dataFile).commit();
    }

    @AfterEach
    public void cleanup() throws IOException {
        this.dropTable("test");
        this.dropTable("test2");
    }

    private void initDateTable() throws IOException {
        this.dropTable("test2");
        this.dateTableName = "test2";
        this.dateTable = this.createTable(this.dateTableName, DATE_SCHEMA, DATE_SPEC);
        GenericRecord record = GenericRecord.create((Schema)this.dateTable.schema());
        this.dateRecords = Lists.newArrayList((Object[])new Record[]{record.copy("dt", (Object)LocalDate.parse("2021-09-01"), "data", (Object)"a", "id", (Object)1), record.copy("dt", (Object)LocalDate.parse("2021-09-02"), "data", (Object)"b", "id", (Object)2), record.copy("dt", (Object)LocalDate.parse("2021-09-03"), "data", (Object)"c", "id", (Object)3), record.copy("dt", (Object)LocalDate.parse("2021-09-04"), "data", (Object)"d", "id", (Object)4), record.copy("dt", (Object)LocalDate.parse("2021-09-05"), "data", (Object)"e", "id", (Object)5)});
        DataFile dataFile1 = FileHelpers.writeDataFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-01"))}), this.dateRecords.subList(0, 1));
        DataFile dataFile2 = FileHelpers.writeDataFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-02"))}), this.dateRecords.subList(1, 2));
        DataFile dataFile3 = FileHelpers.writeDataFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-03"))}), this.dateRecords.subList(2, 3));
        DataFile dataFile4 = FileHelpers.writeDataFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-04"))}), this.dateRecords.subList(3, 4));
        DataFile dataFile5 = FileHelpers.writeDataFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-05"))}), this.dateRecords.subList(4, 5));
        this.dateTable.newAppend().appendFile(dataFile1).appendFile(dataFile2).appendFile(dataFile3).appendFile(dataFile4).appendFile(dataFile5).commit();
    }

    protected abstract Table createTable(String var1, Schema var2, PartitionSpec var3) throws IOException;

    protected abstract void dropTable(String var1) throws IOException;

    protected abstract StructLikeSet rowSet(String var1, Table var2, String ... var3) throws IOException;

    protected boolean expectPruned() {
        return true;
    }

    protected boolean countDeletes() {
        return false;
    }

    protected long deleteCount() {
        return 0L;
    }

    protected void checkDeleteCount(long expectedDeletes) {
        if (this.countDeletes()) {
            long actualDeletes = this.deleteCount();
            ((AbstractLongAssert)Assertions.assertThat((long)actualDeletes).as("Table should contain expected number of deletes", new Object[0])).isEqualTo(expectedDeletes);
        }
    }

    @TestTemplate
    public void testEqualityDeletes() throws IOException {
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(3L);
    }

    @TestTemplate
    public void testEqualityDateDeletes() throws IOException {
        this.initDateTable();
        Schema deleteRowSchema = this.dateTable.schema().select(new String[]{"*"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("dt", (Object)LocalDate.parse("2021-09-01"), "data", (Object)"a", "id", (Object)1), dataDelete.copy("dt", (Object)LocalDate.parse("2021-09-02"), "data", (Object)"b", "id", (Object)2), dataDelete.copy("dt", (Object)LocalDate.parse("2021-09-03"), "data", (Object)"c", "id", (Object)3)});
        DeleteFile eqDeletes1 = FileHelpers.writeDeleteFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-01"))}), dataDeletes.subList(0, 1), deleteRowSchema);
        DeleteFile eqDeletes2 = FileHelpers.writeDeleteFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-02"))}), dataDeletes.subList(1, 2), deleteRowSchema);
        DeleteFile eqDeletes3 = FileHelpers.writeDeleteFile(this.dateTable, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{DateTimeUtil.daysFromDate((LocalDate)LocalDate.parse("2021-09-03"))}), dataDeletes.subList(2, 3), deleteRowSchema);
        this.dateTable.newRowDelta().addDeletes(eqDeletes1).addDeletes(eqDeletes2).addDeletes(eqDeletes3).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.dateTable, this.dateRecords, 1, 2, 3);
        StructLikeSet actual = this.rowSet(this.dateTableName, this.dateTable, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(3L);
    }

    @TestTemplate
    public void testEqualityDeletesWithRequiredEqColumn() throws IOException {
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = this.selectColumns(DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122), "id");
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "id");
        if (this.expectPruned()) {
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        } else {
            ((AbstractCollectionAssert)Assertions.assertThat((Collection)this.selectColumns(actual, "id")).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        }
        this.checkDeleteCount(3L);
    }

    @TestTemplate
    public void testEqualityDeletesSpanningMultipleDataFiles() throws IOException {
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        this.records.add(record.copy("id", (Object)144, "data", (Object)"a"));
        this.dataFile = FileHelpers.writeDataFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), this.records);
        this.table.newAppend().appendFile(this.dataFile).commit();
        Schema deleteRowSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)deleteRowSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, deleteRowSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122, 144);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(7L);
    }

    @TestTemplate
    public void testPositionDeletes() throws IOException {
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)0L), Pair.of((Object)this.dataFile.path(), (Object)3L), Pair.of((Object)this.dataFile.path(), (Object)6L)});
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(3L);
    }

    @TestTemplate
    public void testMultiplePosDeleteFiles() throws IOException {
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)0L), Pair.of((Object)this.dataFile.path(), (Object)3L)});
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)6L)});
        posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), deletes);
        this.table.newRowDelta().addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(3L);
    }

    @TestTemplate
    public void testMixedPositionAndEqualityDeletes() throws IOException {
        Schema dataSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)dataSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, dataSchema);
        ArrayList deletes = Lists.newArrayList((Object[])new Pair[]{Pair.of((Object)this.dataFile.path(), (Object)3L), Pair.of((Object)this.dataFile.path(), (Object)5L)});
        Pair<DeleteFile, CharSequenceSet> posDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), deletes);
        this.table.newRowDelta().addDeletes(eqDeletes).addDeletes((DeleteFile)posDeletes.first()).validateDataFilesExist((Iterable)posDeletes.second()).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 121, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(4L);
    }

    @TestTemplate
    public void testMultipleEqualityDeleteSchemas() throws IOException {
        Schema dataSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)dataSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", (Object)"a"), dataDelete.copy("data", (Object)"d"), dataDelete.copy("data", (Object)"g")});
        DeleteFile dataEqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, dataSchema);
        Schema idSchema = this.table.schema().select(new String[]{"id"});
        GenericRecord idDelete = GenericRecord.create((Schema)idSchema);
        ArrayList idDeletes = Lists.newArrayList((Object[])new Record[]{idDelete.copy("id", (Object)121), idDelete.copy("id", (Object)29)});
        DeleteFile idEqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), idDeletes, idSchema);
        this.table.newRowDelta().addDeletes(dataEqDeletes).addDeletes(idEqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 29, 89, 121, 122);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(4L);
    }

    @TestTemplate
    public void testEqualityDeleteByNull() throws IOException {
        this.table.updateSchema().makeColumnOptional("data").commit();
        GenericRecord record = GenericRecord.create((Schema)this.table.schema());
        DataFile dataFileWithNull = FileHelpers.writeDataFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), Lists.newArrayList((Object[])new Record[]{record.copy("id", (Object)131, "data", null)}));
        this.table.newAppend().appendFile(dataFileWithNull).commit();
        Schema dataSchema = this.table.schema().select(new String[]{"data"});
        GenericRecord dataDelete = GenericRecord.create((Schema)dataSchema);
        ArrayList dataDeletes = Lists.newArrayList((Object[])new Record[]{dataDelete.copy("data", null)});
        DeleteFile eqDeletes = FileHelpers.writeDeleteFile(this.table, Files.localOutput((File)File.createTempFile("junit", null, this.temp.toFile())), (StructLike)TestHelpers.Row.of((Object[])new Object[]{0}), dataDeletes, dataSchema);
        this.table.newRowDelta().addDeletes(eqDeletes).commit();
        StructLikeSet expected = DeleteReadTests.rowSetWithoutIds(this.table, this.records, 131);
        StructLikeSet actual = this.rowSet(this.tableName, this.table, "*");
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)actual).as("Table should contain expected rows", new Object[0])).isEqualTo((Object)expected);
        this.checkDeleteCount(1L);
    }

    private StructLikeSet selectColumns(StructLikeSet rows, String ... columns) {
        Schema projection = this.table.schema().select(columns);
        StructLikeSet set = StructLikeSet.create((Types.StructType)projection.asStruct());
        rows.stream().map(row -> StructProjection.create((Schema)this.table.schema(), (Schema)projection).wrap(row)).forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    protected static StructLikeSet rowSetWithoutIds(Table table, List<Record> recordList, int ... idsToRemove) {
        HashSet deletedIds = Sets.newHashSet((Iterable)ArrayUtil.toIntList((int[])idsToRemove));
        StructLikeSet set = StructLikeSet.create((Types.StructType)table.schema().asStruct());
        recordList.stream().filter(row -> !deletedIds.contains(row.getField("id"))).map(record -> new InternalRecordWrapper(table.schema().asStruct()).wrap((StructLike)record)).forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }

    protected StructLikeSet rowSetWithIds(int ... idsToRetain) {
        HashSet deletedIds = Sets.newHashSet((Iterable)ArrayUtil.toIntList((int[])idsToRetain));
        StructLikeSet set = StructLikeSet.create((Types.StructType)this.table.schema().asStruct());
        this.records.stream().filter(row -> deletedIds.contains(row.getField("id"))).forEach(arg_0 -> ((StructLikeSet)set).add(arg_0));
        return set;
    }
}

