/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.Test;

public class TestGenericRecord {
    @Test
    public void testGetNullValue() {
        Types.LongType type = Types.LongType.get();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)type)});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.set(0, null);
        Assertions.assertThat((Object)record.get(0, type.typeId().javaClass())).isNull();
    }

    @Test
    public void testGetNotNullValue() {
        Types.LongType type = Types.LongType.get();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)type)});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.set(0, (Object)10L);
        Assertions.assertThat((Object)record.get(0, type.typeId().javaClass())).isEqualTo((Object)10L);
    }

    @Test
    public void testGetIncorrectClassInstance() {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"id", (Type)Types.LongType.get())});
        GenericRecord record = GenericRecord.create((Schema)schema);
        record.set(0, (Object)10L);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> record.get(0, CharSequence.class)).isInstanceOf(IllegalStateException.class)).hasMessage("Not an instance of java.lang.CharSequence: 10");
    }
}

