/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.orc;

import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TimeZone;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.DataTestHelpers;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.orc.GenericOrcWriter;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.orc.OrcFile;
import org.apache.orc.TypeDescription;
import org.apache.orc.Writer;
import org.apache.orc.storage.ql.exec.vector.BytesColumnVector;
import org.apache.orc.storage.ql.exec.vector.LongColumnVector;
import org.apache.orc.storage.ql.exec.vector.VectorizedRowBatch;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ObjectAssert;
import org.assertj.core.api.ThrowingConsumer;
import org.junit.jupiter.api.Test;

public class TestGenericData
extends DataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        List<Record> expected = RandomGenericData.generate(schema, 100, 0L);
        this.writeAndValidateRecords(schema, expected);
    }

    @Test
    public void writeAndValidateRepeatingRecords() throws IOException {
        Schema structSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)101, (String)"data", (Type)Types.StringType.get())});
        List<Record> expectedRepeating = Collections.nCopies(100, RandomGenericData.generate(structSchema, 1, 0L).get(0));
        this.writeAndValidateRecords(structSchema, expectedRepeating);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void writeAndValidateTimestamps() throws IOException {
        TimeZone currentTz = TimeZone.getDefault();
        try {
            ArrayList rows;
            Schema timestampSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"tsTzCol", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"tsCol", (Type)Types.TimestampType.withoutZone())});
            TimeZone.setDefault(TimeZone.getTimeZone("America/New_York"));
            GenericRecord record1 = GenericRecord.create((Schema)timestampSchema);
            record1.setField("tsTzCol", (Object)OffsetDateTime.parse("2017-01-16T17:10:34-08:00"));
            record1.setField("tsCol", (Object)LocalDateTime.parse("1970-01-01T00:01:00"));
            GenericRecord record2 = GenericRecord.create((Schema)timestampSchema);
            record2.setField("tsTzCol", (Object)OffsetDateTime.parse("2017-05-16T17:10:34-08:00"));
            record2.setField("tsCol", (Object)LocalDateTime.parse("1970-05-01T00:01:00"));
            GenericRecord record3 = GenericRecord.create((Schema)timestampSchema);
            record3.setField("tsTzCol", (Object)OffsetDateTime.parse("1935-01-16T17:10:34-08:00"));
            record3.setField("tsCol", (Object)LocalDateTime.parse("1935-01-01T00:01:00"));
            GenericRecord record4 = GenericRecord.create((Schema)timestampSchema);
            record4.setField("tsTzCol", (Object)OffsetDateTime.parse("1935-05-16T17:10:34-08:00"));
            record4.setField("tsCol", (Object)LocalDateTime.parse("1935-05-01T00:01:00"));
            File testFile = File.createTempFile("junit", null, this.temp.toFile());
            Assertions.assertThat((boolean)testFile.delete()).isTrue();
            try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)testFile)).schema(timestampSchema).createWriterFunc(GenericOrcWriter::buildWriter).build();){
                writer.add((Object)record1);
                writer.add((Object)record2);
                writer.add((Object)record3);
                writer.add((Object)record4);
            }
            TimeZone.setDefault(TimeZone.getTimeZone("Asia/Kolkata"));
            try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)testFile)).project(timestampSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)timestampSchema, (TypeDescription)fileSchema)).build();){
                rows = Lists.newArrayList((Iterable)reader);
            }
            ((ObjectAssert)Assertions.assertThat((List)rows).element(0)).satisfies(new ThrowingConsumer[]{record -> {
                Assertions.assertThat((Object)record.getField("tsTzCol")).isEqualTo((Object)OffsetDateTime.parse("2017-01-17T01:10:34Z"));
                Assertions.assertThat((Object)record.getField("tsCol")).isEqualTo((Object)LocalDateTime.parse("1970-01-01T00:01:00"));
            }});
            ((ObjectAssert)Assertions.assertThat((List)rows).element(1)).satisfies(new ThrowingConsumer[]{record -> {
                Assertions.assertThat((Object)record.getField("tsTzCol")).isEqualTo((Object)OffsetDateTime.parse("2017-05-17T01:10:34Z"));
                Assertions.assertThat((Object)record.getField("tsCol")).isEqualTo((Object)LocalDateTime.parse("1970-05-01T00:01:00"));
            }});
            ((ObjectAssert)Assertions.assertThat((List)rows).element(2)).satisfies(new ThrowingConsumer[]{record -> {
                Assertions.assertThat((Object)record.getField("tsTzCol")).isEqualTo((Object)OffsetDateTime.parse("1935-01-17T01:10:34Z"));
                Assertions.assertThat((Object)record.getField("tsCol")).isEqualTo((Object)LocalDateTime.parse("1935-01-01T00:01:00"));
            }});
            ((ObjectAssert)Assertions.assertThat((List)rows).element(3)).satisfies(new ThrowingConsumer[]{record -> {
                Assertions.assertThat((Object)record.getField("tsTzCol")).isEqualTo((Object)OffsetDateTime.parse("1935-05-17T01:10:34Z"));
                Assertions.assertThat((Object)record.getField("tsCol")).isEqualTo((Object)LocalDateTime.parse("1935-05-01T00:01:00"));
            }});
        }
        finally {
            TimeZone.setDefault(currentTz);
        }
    }

    @Test
    public void writeAndValidateExternalData() throws IOException {
        ArrayList rows;
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)testFile.delete()).isTrue();
        Configuration conf = new Configuration();
        TypeDescription writerSchema = TypeDescription.fromString((String)"struct<a:tinyint,b:smallint,c:char(10),d:varchar(10)>");
        Writer writer = OrcFile.createWriter((Path)new Path(testFile.toString()), (OrcFile.WriterOptions)OrcFile.writerOptions((Configuration)conf).setSchema(writerSchema));
        VectorizedRowBatch batch = writerSchema.createRowBatch();
        batch.ensureSize(1);
        batch.size = 1;
        ((LongColumnVector)batch.cols[0]).vector[0] = 1L;
        ((LongColumnVector)batch.cols[1]).vector[0] = 123L;
        ((BytesColumnVector)batch.cols[2]).setVal(0, "1".getBytes(StandardCharsets.UTF_8));
        ((BytesColumnVector)batch.cols[3]).setVal(0, "123".getBytes(StandardCharsets.UTF_8));
        writer.addRowBatch(batch);
        writer.close();
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)3, (String)"c", (Type)Types.StringType.get()), Types.NestedField.optional((int)4, (String)"d", (Type)Types.StringType.get())});
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)testFile)).project(readSchema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)readSchema, (TypeDescription)fileSchema)).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        ((ObjectAssert)Assertions.assertThat((List)rows).first()).satisfies(new ThrowingConsumer[]{record -> {
            Assertions.assertThat((Object)record.getField("a")).isEqualTo((Object)1);
            Assertions.assertThat((Object)record.getField("b")).isEqualTo((Object)123);
            Assertions.assertThat((Object)record.getField("c")).isEqualTo((Object)"1");
            Assertions.assertThat((Object)record.getField("d")).isEqualTo((Object)"123");
        }});
    }

    private void writeAndValidateRecords(Schema schema, List<Record> expected) throws IOException {
        ArrayList rows;
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)testFile.delete()).isTrue();
        try (FileAppender writer = ORC.write((OutputFile)Files.localOutput((File)testFile)).schema(schema).createWriterFunc(GenericOrcWriter::buildWriter).build();){
            for (Record rec : expected) {
                writer.add((Object)rec);
            }
        }
        try (CloseableIterable reader = ORC.read((InputFile)Files.localInput((File)testFile)).project(schema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)fileSchema)).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            DataTestHelpers.assertEquals(schema.asStruct(), expected.get(i), (Record)rows.get(i));
        }
    }
}

