/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DeleteFile;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataReader;
import org.apache.iceberg.data.orc.GenericOrcReader;
import org.apache.iceberg.data.parquet.GenericParquetReaders;
import org.apache.iceberg.deletes.EqualityDeleteWriter;
import org.apache.iceberg.deletes.PositionDelete;
import org.apache.iceberg.deletes.PositionDeleteWriter;
import org.apache.iceberg.encryption.EncryptedOutputFile;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.DataWriter;
import org.apache.iceberg.io.DeleteSchemaUtil;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.orc.ORC;
import org.apache.iceberg.parquet.Parquet;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.CharSequenceSet;
import org.apache.iceberg.util.Pair;
import org.apache.iceberg.util.StructLikeSet;
import org.apache.orc.TypeDescription;
import org.apache.parquet.schema.MessageType;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.assertj.core.api.MapAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestFileWriterFactory<T>
extends WriterTestBase<T> {
    private static final String PARTITION_VALUE = "aaa";
    @Parameter(index=1)
    private FileFormat fileFormat;
    @Parameter(index=2)
    private boolean partitioned;
    private StructLike partition = null;
    private OutputFileFactory fileFactory = null;
    private List<T> dataRows;

    @Parameters(name="formatVersion = {0}, fileFormat = {1}, Partitioned = {2}")
    protected static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, FileFormat.AVRO, false}, new Object[]{2, FileFormat.AVRO, true}, new Object[]{2, FileFormat.PARQUET, false}, new Object[]{2, FileFormat.PARQUET, true}, new Object[]{2, FileFormat.ORC, false}, new Object[]{2, FileFormat.ORC, true});
    }

    protected abstract StructLikeSet toSet(Iterable<T> var1);

    protected FileFormat format() {
        return this.fileFormat;
    }

    @BeforeEach
    public void setupTable() throws Exception {
        this.tableDir = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)this.tableDir.delete()).isTrue();
        this.metadataDir = new File(this.tableDir, "metadata");
        if (this.partitioned) {
            this.table = this.create(SCHEMA, SPEC);
            this.partition = this.partitionKey(this.table.spec(), PARTITION_VALUE);
        } else {
            this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
            this.partition = null;
        }
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
        this.dataRows = ImmutableList.of(this.toRow(1, PARTITION_VALUE), this.toRow(2, PARTITION_VALUE), this.toRow(3, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE), this.toRow(5, PARTITION_VALUE));
    }

    @TestTemplate
    public void testDataWriter() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        this.table.newRowDelta().addRows(dataFile).commit();
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet(this.dataRows));
    }

    @TestTemplate
    public void testEqualityDeleteWriter() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        this.table.newRowDelta().addRows(dataFile).commit();
        ImmutableList deletes = ImmutableList.of(this.toRow(1, PARTITION_VALUE), this.toRow(3, "bbb"), this.toRow(5, "ccc"));
        DeleteFile deleteFile = this.writeEqualityDeletes(writerFactory, (List<T>)deletes, this.table.spec(), this.partition);
        GenericRecord deleteRecord = GenericRecord.create((Schema)equalityDeleteRowSchema);
        ImmutableList expectedDeletes = ImmutableList.of((Object)deleteRecord.copy("id", (Object)1), (Object)deleteRecord.copy("id", (Object)3), (Object)deleteRecord.copy("id", (Object)5));
        InputFile inputDeleteFile = this.table.io().newInputFile(deleteFile.path().toString());
        List<Record> actualDeletes = this.readFile(equalityDeleteRowSchema, inputDeleteFile);
        Assertions.assertThat(actualDeletes).isEqualTo((Object)expectedDeletes);
        this.table.newRowDelta().addDeletes(deleteFile).commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(2, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testEqualityDeleteWriterWithMultipleSpecs() throws IOException {
        Assumptions.assumeThat((boolean)this.partitioned).isFalse();
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        DataFile firstDataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        ((AbstractIntegerAssert)Assertions.assertThat((int)firstDataFile.partition().size()).as("First data file must be unpartitioned", new Object[0])).isEqualTo(0);
        ImmutableList deletes = ImmutableList.of(this.toRow(1, PARTITION_VALUE), this.toRow(2, PARTITION_VALUE), this.toRow(3, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE));
        DeleteFile firstDeleteFile = this.writeEqualityDeletes(writerFactory, (List<T>)deletes, this.table.spec(), this.partition);
        ((AbstractIntegerAssert)Assertions.assertThat((int)firstDeleteFile.partition().size()).as("First delete file must be unpartitioned", new Object[0])).isEqualTo(0);
        this.table.newAppend().appendFile(firstDataFile).commit();
        this.table.newRowDelta().addDeletes(firstDeleteFile).commit();
        this.table.updateSpec().addField("data").commit();
        this.partition = this.partitionKey(this.table.spec(), PARTITION_VALUE);
        DataFile secondDataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        ((AbstractIntegerAssert)Assertions.assertThat((int)secondDataFile.partition().size()).as("Second data file must be partitioned", new Object[0])).isEqualTo(1);
        DeleteFile secondDeleteFile = this.writeEqualityDeletes(writerFactory, (List<T>)deletes, this.table.spec(), this.partition);
        ((AbstractIntegerAssert)Assertions.assertThat((int)secondDeleteFile.partition().size()).as("Second delete file must be partitioned", new Object[0])).isEqualTo(1);
        this.table.newAppend().appendFile(secondDataFile).commit();
        this.table.newRowDelta().addDeletes(secondDeleteFile).commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(5, PARTITION_VALUE), this.toRow(5, PARTITION_VALUE));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testPositionDeleteWriter() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        ImmutableList deletes = ImmutableList.of((Object)this.positionDelete(dataFile.path(), 0L, null), (Object)this.positionDelete(dataFile.path(), 2L, null), (Object)this.positionDelete(dataFile.path(), 4L, null));
        Pair<DeleteFile, CharSequenceSet> result = this.writePositionDeletes(writerFactory, (List<PositionDelete<T>>)deletes, this.table.spec(), this.partition);
        DeleteFile deleteFile = (DeleteFile)result.first();
        CharSequenceSet referencedDataFiles = (CharSequenceSet)result.second();
        if (this.fileFormat == FileFormat.AVRO) {
            Assertions.assertThat((Map)deleteFile.lowerBounds()).isNull();
            Assertions.assertThat((Map)deleteFile.upperBounds()).isNull();
            Assertions.assertThat((Map)deleteFile.columnSizes()).isNull();
        } else {
            Assertions.assertThat((Collection)referencedDataFiles).hasSize(1);
            ((MapAssert)Assertions.assertThat((Map)deleteFile.lowerBounds()).hasSize(2)).containsKey((Object)MetadataColumns.DELETE_FILE_PATH.fieldId());
            ((MapAssert)Assertions.assertThat((Map)deleteFile.upperBounds()).hasSize(2)).containsKey((Object)MetadataColumns.DELETE_FILE_PATH.fieldId());
            Assertions.assertThat((Map)deleteFile.columnSizes()).hasSize(2);
        }
        Assertions.assertThat((Map)deleteFile.valueCounts()).isNull();
        Assertions.assertThat((Map)deleteFile.nullValueCounts()).isNull();
        Assertions.assertThat((Map)deleteFile.nanValueCounts()).isNull();
        GenericRecord deleteRecord = GenericRecord.create((Schema)DeleteSchemaUtil.pathPosSchema());
        ImmutableList expectedDeletes = ImmutableList.of((Object)deleteRecord.copy(MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), MetadataColumns.DELETE_FILE_POS.name(), (Object)0L), (Object)deleteRecord.copy(MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), MetadataColumns.DELETE_FILE_POS.name(), (Object)2L), (Object)deleteRecord.copy(MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), MetadataColumns.DELETE_FILE_POS.name(), (Object)4L));
        InputFile inputDeleteFile = this.table.io().newInputFile(deleteFile.path().toString());
        List<Record> actualDeletes = this.readFile(DeleteSchemaUtil.pathPosSchema(), inputDeleteFile);
        Assertions.assertThat(actualDeletes).isEqualTo((Object)expectedDeletes);
        this.table.newRowDelta().addRows(dataFile).addDeletes(deleteFile).validateDataFilesExist((Iterable)referencedDataFiles).validateDeletedFiles().commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(2, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testPositionDeleteWriterWithRow() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), this.table.schema());
        DataFile dataFile = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        ImmutableList deletes = ImmutableList.of((Object)this.positionDelete(dataFile.path(), 0L, this.dataRows.get(0)));
        Pair<DeleteFile, CharSequenceSet> result = this.writePositionDeletes(writerFactory, (List<PositionDelete<T>>)deletes, this.table.spec(), this.partition);
        DeleteFile deleteFile = (DeleteFile)result.first();
        CharSequenceSet referencedDataFiles = (CharSequenceSet)result.second();
        if (this.fileFormat == FileFormat.AVRO) {
            Assertions.assertThat((Map)deleteFile.lowerBounds()).isNull();
            Assertions.assertThat((Map)deleteFile.upperBounds()).isNull();
            Assertions.assertThat((Map)deleteFile.columnSizes()).isNull();
            Assertions.assertThat((Map)deleteFile.valueCounts()).isNull();
            Assertions.assertThat((Map)deleteFile.nullValueCounts()).isNull();
            Assertions.assertThat((Map)deleteFile.nanValueCounts()).isNull();
        } else {
            Assertions.assertThat((Collection)referencedDataFiles).hasSize(1);
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)deleteFile.lowerBounds()).hasSize(4)).containsKey((Object)MetadataColumns.DELETE_FILE_PATH.fieldId())).containsKey((Object)MetadataColumns.DELETE_FILE_POS.fieldId());
            for (Types.NestedField column : this.table.schema().columns()) {
                Assertions.assertThat((Map)deleteFile.lowerBounds()).containsKey((Object)column.fieldId());
            }
            ((MapAssert)((MapAssert)Assertions.assertThat((Map)deleteFile.upperBounds()).hasSize(4)).containsKey((Object)MetadataColumns.DELETE_FILE_PATH.fieldId())).containsKey((Object)MetadataColumns.DELETE_FILE_POS.fieldId());
            for (Types.NestedField column : this.table.schema().columns()) {
                Assertions.assertThat((Map)deleteFile.upperBounds()).containsKey((Object)column.fieldId());
            }
            Assertions.assertThat((Map)deleteFile.columnSizes()).hasSizeGreaterThanOrEqualTo(4);
            Assertions.assertThat((Map)deleteFile.valueCounts()).hasSizeGreaterThanOrEqualTo(2);
            Assertions.assertThat((Map)deleteFile.nullValueCounts()).hasSizeGreaterThanOrEqualTo(2);
            Assertions.assertThat((Map)deleteFile.nanValueCounts()).isNull();
        }
        GenericRecord deletedRow = GenericRecord.create((Schema)this.table.schema());
        Schema positionDeleteSchema = DeleteSchemaUtil.posDeleteSchema((Schema)this.table.schema());
        GenericRecord deleteRecord = GenericRecord.create((Schema)positionDeleteSchema);
        ImmutableMap deleteRecordColumns = ImmutableMap.of((Object)MetadataColumns.DELETE_FILE_PATH.name(), (Object)dataFile.path(), (Object)MetadataColumns.DELETE_FILE_POS.name(), (Object)0L, (Object)"row", (Object)deletedRow.copy("id", (Object)1, "data", (Object)PARTITION_VALUE));
        ImmutableList expectedDeletes = ImmutableList.of((Object)deleteRecord.copy((Map)deleteRecordColumns));
        InputFile inputDeleteFile = this.table.io().newInputFile(deleteFile.path().toString());
        List<Record> actualDeletes = this.readFile(positionDeleteSchema, inputDeleteFile);
        Assertions.assertThat(actualDeletes).isEqualTo((Object)expectedDeletes);
        this.table.newRowDelta().addRows(dataFile).addDeletes(deleteFile).validateDataFilesExist((Iterable)referencedDataFiles).validateDeletedFiles().commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(2, PARTITION_VALUE), this.toRow(3, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE), this.toRow(5, PARTITION_VALUE));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    @TestTemplate
    public void testPositionDeleteWriterMultipleDataFiles() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        DataFile dataFile1 = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        DataFile dataFile2 = this.writeData(writerFactory, this.dataRows, this.table.spec(), this.partition);
        ImmutableList deletes = ImmutableList.of((Object)this.positionDelete(dataFile1.path(), 0L, null), (Object)this.positionDelete(dataFile1.path(), 2L, null), (Object)this.positionDelete(dataFile2.path(), 4L, null));
        Pair<DeleteFile, CharSequenceSet> result = this.writePositionDeletes(writerFactory, (List<PositionDelete<T>>)deletes, this.table.spec(), this.partition);
        DeleteFile deleteFile = (DeleteFile)result.first();
        CharSequenceSet referencedDataFiles = (CharSequenceSet)result.second();
        Assertions.assertThat((Collection)referencedDataFiles).hasSize(2);
        Assertions.assertThat((Map)deleteFile.lowerBounds()).isNull();
        Assertions.assertThat((Map)deleteFile.upperBounds()).isNull();
        Assertions.assertThat((Map)deleteFile.valueCounts()).isNull();
        Assertions.assertThat((Map)deleteFile.nullValueCounts()).isNull();
        Assertions.assertThat((Map)deleteFile.nanValueCounts()).isNull();
        if (this.fileFormat == FileFormat.AVRO) {
            Assertions.assertThat((Map)deleteFile.columnSizes()).isNull();
        } else {
            Assertions.assertThat((Map)deleteFile.columnSizes()).hasSize(2);
        }
        this.table.newRowDelta().addRows(dataFile1).addRows(dataFile2).addDeletes(deleteFile).validateDataFilesExist((Iterable)referencedDataFiles).validateDeletedFiles().commit();
        ImmutableList expectedRows = ImmutableList.of(this.toRow(2, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE), this.toRow(5, PARTITION_VALUE), this.toRow(1, PARTITION_VALUE), this.toRow(2, PARTITION_VALUE), this.toRow(3, PARTITION_VALUE), this.toRow(4, PARTITION_VALUE));
        Assertions.assertThat((Collection)this.actualRowSet("*")).isEqualTo((Object)this.toSet((Iterable<T>)expectedRows));
    }

    private DataFile writeData(FileWriterFactory<T> writerFactory, List<T> rows, PartitionSpec spec, StructLike partitionKey) throws IOException {
        DataWriter writer;
        EncryptedOutputFile file = this.newOutputFile(spec, partitionKey);
        try (DataWriter closeableWriter = writer = writerFactory.newDataWriter(file, spec, partitionKey);){
            for (T row : rows) {
                closeableWriter.write(row);
            }
        }
        return writer.toDataFile();
    }

    private DeleteFile writeEqualityDeletes(FileWriterFactory<T> writerFactory, List<T> deletes, PartitionSpec spec, StructLike partitionKey) throws IOException {
        EqualityDeleteWriter writer;
        EncryptedOutputFile file = this.newOutputFile(spec, partitionKey);
        try (EqualityDeleteWriter closableWriter = writer = writerFactory.newEqualityDeleteWriter(file, spec, partitionKey);){
            closableWriter.write(deletes);
        }
        return writer.toDeleteFile();
    }

    private Pair<DeleteFile, CharSequenceSet> writePositionDeletes(FileWriterFactory<T> writerFactory, List<PositionDelete<T>> deletes, PartitionSpec spec, StructLike partitionKey) throws IOException {
        EncryptedOutputFile file = this.newOutputFile(spec, partitionKey);
        PositionDeleteWriter writer = writerFactory.newPositionDeleteWriter(file, spec, partitionKey);
        PositionDelete posDelete = PositionDelete.create();
        try (PositionDeleteWriter closableWriter = writer;){
            for (PositionDelete<T> delete : deletes) {
                closableWriter.write(posDelete.set(delete.path(), delete.pos(), delete.row()));
            }
        }
        return Pair.of((Object)writer.toDeleteFile(), (Object)writer.referencedDataFiles());
    }

    private List<Record> readFile(Schema schema, InputFile inputFile) throws IOException {
        switch (this.fileFormat) {
            case PARQUET: {
                try (CloseableIterable records = Parquet.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericParquetReaders.buildReader((Schema)schema, (MessageType)fileSchema)).build();){
                    ImmutableList immutableList = ImmutableList.copyOf((Iterable)records);
                    return immutableList;
                }
            }
            case AVRO: {
                try (AvroIterable records = Avro.read((InputFile)inputFile).project(schema).createReaderFunc(DataReader::create).build();){
                    ImmutableList immutableList = ImmutableList.copyOf((Iterable)records);
                    return immutableList;
                }
            }
            case ORC: {
                try (CloseableIterable records = ORC.read((InputFile)inputFile).project(schema).createReaderFunc(fileSchema -> GenericOrcReader.buildReader((Schema)schema, (TypeDescription)fileSchema)).build();){
                    ImmutableList immutableList = ImmutableList.copyOf((Iterable)records);
                    return immutableList;
                }
            }
        }
        throw new UnsupportedOperationException("Unsupported read file format: " + this.fileFormat);
    }

    private EncryptedOutputFile newOutputFile(PartitionSpec spec, StructLike partitionKey) {
        return this.fileFactory.newOutputFile(spec, partitionKey);
    }
}

