/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.io;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.io.DataWriteResult;
import org.apache.iceberg.io.DeleteWriteResult;
import org.apache.iceberg.io.FileWriterFactory;
import org.apache.iceberg.io.OutputFileFactory;
import org.apache.iceberg.io.RollingDataWriter;
import org.apache.iceberg.io.RollingEqualityDeleteWriter;
import org.apache.iceberg.io.RollingPositionDeleteWriter;
import org.apache.iceberg.io.WriterTestBase;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;

@ExtendWith(value={ParameterizedTestExtension.class})
public abstract class TestRollingFileWriters<T>
extends WriterTestBase<T> {
    private static final int FILE_SIZE_CHECK_ROWS_DIVISOR = 1000;
    private static final long DEFAULT_FILE_SIZE = 0x8000000L;
    private static final long SMALL_FILE_SIZE = 2L;
    private static final String PARTITION_VALUE = "aaa";
    @Parameter(index=1)
    private FileFormat fileFormat;
    @Parameter(index=2)
    private boolean partitioned;
    private StructLike partition = null;
    private OutputFileFactory fileFactory = null;

    @Parameters(name="formatVersion = {0}, fileFormat = {1}, Partitioned = {2}")
    protected static List<Object> parameters() {
        return Arrays.asList(new Object[]{2, FileFormat.AVRO, false}, new Object[]{2, FileFormat.AVRO, true}, new Object[]{2, FileFormat.PARQUET, false}, new Object[]{2, FileFormat.PARQUET, true}, new Object[]{2, FileFormat.ORC, false}, new Object[]{2, FileFormat.ORC, true});
    }

    protected FileFormat format() {
        return this.fileFormat;
    }

    @BeforeEach
    public void setupTable() throws Exception {
        this.tableDir = Files.createTempDirectory(this.temp, "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)this.tableDir.delete()).isTrue();
        this.metadataDir = new File(this.tableDir, "metadata");
        if (this.partitioned) {
            this.table = this.create(SCHEMA, SPEC);
            this.partition = this.partitionKey(this.table.spec(), PARTITION_VALUE);
        } else {
            this.table = this.create(SCHEMA, PartitionSpec.unpartitioned());
            this.partition = null;
        }
        this.fileFactory = OutputFileFactory.builderFor((Table)this.table, (int)1, (long)1L).format(this.fileFormat).build();
    }

    @TestTemplate
    public void testRollingDataWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingDataWriter writer = new RollingDataWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, this.table.spec(), this.partition);
        writer.close();
        Assertions.assertThat((List)((DataWriteResult)writer.result()).dataFiles()).isEmpty();
        writer.close();
        Assertions.assertThat((List)((DataWriteResult)writer.result()).dataFiles()).isEmpty();
    }

    @TestTemplate
    public void testRollingDataWriterSplitData() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingDataWriter writer = new RollingDataWriter(writerFactory, this.fileFactory, this.table.io(), 2L, this.table.spec(), this.partition);
        ArrayList rows = Lists.newArrayListWithExpectedSize((int)4000);
        for (int index = 0; index < 4000; ++index) {
            rows.add(this.toRow(index, PARTITION_VALUE));
        }
        try (RollingDataWriter closableWriter = writer;){
            closableWriter.write((Iterable)rows);
        }
        writer.close();
        Assertions.assertThat((List)((DataWriteResult)writer.result()).dataFiles()).hasSize(4);
    }

    @TestTemplate
    public void testRollingEqualityDeleteWriterNoRecords() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        RollingEqualityDeleteWriter writer = new RollingEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, this.table.spec(), this.partition);
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
    }

    @TestTemplate
    public void testRollingEqualityDeleteWriterSplitDeletes() throws IOException {
        ImmutableList equalityFieldIds = ImmutableList.of((Object)this.table.schema().findField("id").fieldId());
        Schema equalityDeleteRowSchema = this.table.schema().select(new String[]{"id"});
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema(), (List<Integer>)equalityFieldIds, equalityDeleteRowSchema);
        RollingEqualityDeleteWriter writer = new RollingEqualityDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 2L, this.table.spec(), this.partition);
        ArrayList deletes = Lists.newArrayListWithExpectedSize((int)4000);
        for (int index = 0; index < 4000; ++index) {
            deletes.add(this.toRow(index, PARTITION_VALUE));
        }
        try (RollingEqualityDeleteWriter closeableWriter = writer;){
            closeableWriter.write((Iterable)deletes);
        }
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).hasSize(4);
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
    }

    @TestTemplate
    public void testRollingPositionDeleteWriterNoRecords() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingPositionDeleteWriter writer = new RollingPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 0x8000000L, this.table.spec(), this.partition);
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).isEmpty();
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).isEmpty();
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isFalse();
    }

    @TestTemplate
    public void testRollingPositionDeleteWriterSplitDeletes() throws IOException {
        FileWriterFactory writerFactory = this.newWriterFactory(this.table.schema());
        RollingPositionDeleteWriter writer = new RollingPositionDeleteWriter(writerFactory, this.fileFactory, this.table.io(), 2L, this.table.spec(), this.partition);
        ArrayList deletes = Lists.newArrayListWithExpectedSize((int)4000);
        for (int index = 0; index < 4000; ++index) {
            deletes.add(this.positionDelete("path/to/data/file-1.parquet", index, null));
        }
        try (RollingPositionDeleteWriter closeableWriter = writer;){
            closeableWriter.write((Iterable)deletes);
        }
        writer.close();
        Assertions.assertThat((List)((DeleteWriteResult)writer.result()).deleteFiles()).hasSize(4);
        Assertions.assertThat((Collection)((DeleteWriteResult)writer.result()).referencedDataFiles()).hasSize(1);
        Assertions.assertThat((boolean)((DeleteWriteResult)writer.result()).referencesDataFiles()).isTrue();
    }
}

