/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.Files;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestSplitScan {
    private static final Configuration CONF = new Configuration();
    private static final HadoopTables TABLES = new HadoopTables(CONF);
    private static final long SPLIT_SIZE = 0x1000000L;
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.IntegerType.get()), Types.NestedField.required((int)2, (String)"data", (Type)Types.StringType.get())});
    private Table table;
    @TempDir
    private File tableLocation;
    private List<Record> expectedRecords;
    @Parameter
    private FileFormat format;

    @Parameters(name="fileFormat = {0}")
    public static List<Object> parameters() {
        return Arrays.asList(FileFormat.PARQUET, FileFormat.AVRO);
    }

    @BeforeEach
    public void before() throws IOException {
        this.setupTable();
    }

    @TestTemplate
    public void test() {
        ((ListAssert)Assertions.assertThat((List)Lists.newArrayList((Iterable)this.table.newScan().planTasks())).as("There should be 4 tasks created since file size is approximately close to 64MB and split size 16MB", new Object[0])).hasSize(4);
        ArrayList records = Lists.newArrayList((Iterable)IcebergGenerics.read((Table)this.table).build());
        Assertions.assertThat((List)records).isEqualTo(this.expectedRecords);
    }

    private void setupTable() throws IOException {
        this.table = TABLES.create(SCHEMA, this.tableLocation.toString());
        this.table.updateProperties().set("read.split.target-size", String.valueOf(0x1000000L)).commit();
        int numRecords = 2500000;
        this.expectedRecords = RandomGenericData.generate(SCHEMA, numRecords, 0L);
        File file = this.writeToFile(this.expectedRecords, this.format);
        DataFile dataFile = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withRecordCount((long)this.expectedRecords.size()).withFileSizeInBytes(file.length()).withPath(file.toString()).withFormat(this.format).build();
        this.table.newAppend().appendFile(dataFile).commit();
    }

    private File writeToFile(List<Record> records, FileFormat fileFormat) throws IOException {
        File file = File.createTempFile("junit", null, this.tableLocation);
        Assertions.assertThat((boolean)file.delete()).isTrue();
        GenericAppenderFactory factory = new GenericAppenderFactory(SCHEMA).set("write.parquet.row-group-size-bytes", String.valueOf(0x1000000L));
        try (FileAppender appender = factory.newAppender(Files.localOutput((File)file), fileFormat);){
            appender.addAll(records);
        }
        return file;
    }
}

