/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Stream;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.TypeUtil;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.Assumptions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.Arguments;
import org.junit.jupiter.params.provider.MethodSource;

public abstract class DataTest {
    protected static final Types.StructType SUPPORTED_PRIMITIVES = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)100, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)101, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)102, (String)"b", (Type)Types.BooleanType.get()), Types.NestedField.optional((int)103, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.required((int)104, (String)"l", (Type)Types.LongType.get()), Types.NestedField.optional((int)105, (String)"f", (Type)Types.FloatType.get()), Types.NestedField.required((int)106, (String)"d", (Type)Types.DoubleType.get()), Types.NestedField.optional((int)107, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)108, (String)"ts_tz", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)109, (String)"ts", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)110, (String)"s", (Type)Types.StringType.get()), Types.NestedField.required((int)112, (String)"fixed", (Type)Types.FixedType.ofLength((int)7)), Types.NestedField.optional((int)113, (String)"bytes", (Type)Types.BinaryType.get()), Types.NestedField.required((int)114, (String)"dec_9_0", (Type)Types.DecimalType.of((int)9, (int)0)), Types.NestedField.required((int)115, (String)"dec_11_2", (Type)Types.DecimalType.of((int)11, (int)2)), Types.NestedField.required((int)116, (String)"dec_38_10", (Type)Types.DecimalType.of((int)38, (int)10)), Types.NestedField.required((int)117, (String)"time", (Type)Types.TimeType.get())});
    @TempDir
    protected Path temp;

    protected abstract void writeAndValidate(Schema var1) throws IOException;

    protected abstract void writeAndValidate(Schema var1, List<Record> var2) throws IOException;

    protected void writeAndValidate(Schema writeSchema, Schema expectedSchema) throws IOException {
        throw new UnsupportedEncodingException("Cannot run test, writeAndValidate(Schema, Schema) is not implemented");
    }

    protected boolean supportsDefaultValues() {
        return false;
    }

    protected boolean allowsWritingNullValuesForRequiredFields() {
        return false;
    }

    @Test
    public void testSimpleStruct() throws IOException {
        this.writeAndValidate(new Schema(SUPPORTED_PRIMITIVES.fields()));
    }

    @Test
    public void testArray() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.ListType.ofOptional((int)2, (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testArrayOfStructs() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.ListType.ofOptional((int)2, (Type)SUPPORTED_PRIMITIVES))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testMap() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testNumericMapKey() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.LongType.get(), (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testComplexMapKey() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"i", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)5, (String)"s", (Type)Types.StringType.get())}), (Type)Types.StringType.get()))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testMapOfStructs() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.MapType.ofOptional((int)2, (int)3, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))});
        this.writeAndValidate(schema);
    }

    @Test
    public void testMixedTypes() throws IOException {
        Types.StructType structType = Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"list_of_maps", (Type)Types.ListType.ofOptional((int)2, (Type)Types.MapType.ofOptional((int)3, (int)4, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.optional((int)5, (String)"map_of_lists", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.ListType.ofOptional((int)8, (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)9, (String)"list_of_lists", (Type)Types.ListType.ofOptional((int)10, (Type)Types.ListType.ofOptional((int)11, (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)12, (String)"map_of_maps", (Type)Types.MapType.ofOptional((int)13, (int)14, (Type)Types.StringType.get(), (Type)Types.MapType.ofOptional((int)15, (int)16, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))), Types.NestedField.required((int)17, (String)"list_of_struct_of_nested_types", (Type)Types.ListType.ofOptional((int)19, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)20, (String)"m1", (Type)Types.MapType.ofOptional((int)21, (int)22, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.optional((int)23, (String)"l1", (Type)Types.ListType.ofRequired((int)24, (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.required((int)25, (String)"l2", (Type)Types.ListType.ofRequired((int)26, (Type)SUPPORTED_PRIMITIVES)), Types.NestedField.optional((int)27, (String)"m2", (Type)Types.MapType.ofOptional((int)28, (int)29, (Type)Types.StringType.get(), (Type)SUPPORTED_PRIMITIVES))})))});
        Schema schema = new Schema(TypeUtil.assignFreshIds((Type)structType, new AtomicInteger(0)::incrementAndGet).asStructType().fields());
        this.writeAndValidate(schema);
    }

    @Test
    public void testMissingRequiredWithoutDefault() {
        Assumptions.assumeThat((boolean)this.supportsDefaultValues()).isTrue();
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((String)"missing_str").withId(6).ofType((Type)Types.StringType.get()).withDoc("Missing required field with no default").build()});
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> this.writeAndValidate(writeSchema, expectedSchema)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Missing required field: missing_str");
    }

    @Test
    public void testDefaultValues() throws IOException {
        Assumptions.assumeThat((boolean)this.supportsDefaultValues()).isTrue();
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").withDoc("Should not produce default value").build()});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").build(), Types.NestedField.required((String)"missing_str").withId(6).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"orange").build(), Types.NestedField.optional((String)"missing_int").withId(7).ofType((Type)Types.IntegerType.get()).withInitialDefault((Object)34).build()});
        this.writeAndValidate(writeSchema, expectedSchema);
    }

    @Test
    public void testNullDefaultValue() throws IOException {
        Assumptions.assumeThat((boolean)this.supportsDefaultValues()).isTrue();
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").withDoc("Should not produce default value").build()});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").build(), Types.NestedField.optional((String)"missing_date").withId(3).ofType((Type)Types.DateType.get()).build()});
        this.writeAndValidate(writeSchema, expectedSchema);
    }

    @Test
    public void testNestedDefaultValue() throws IOException {
        Assumptions.assumeThat((boolean)this.supportsDefaultValues()).isTrue();
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").withDoc("Should not produce default value").build(), Types.NestedField.optional((String)"nested").withId(3).ofType((Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"inner", (Type)Types.StringType.get())})).withDoc("Used to test nested field defaults").build()});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").build(), Types.NestedField.optional((String)"nested").withId(3).ofType((Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)4, (String)"inner", (Type)Types.StringType.get()), Types.NestedField.optional((String)"missing_inner_float").withId(5).ofType((Type)Types.FloatType.get()).withInitialDefault((Object)Float.valueOf(-0.0f)).build()})).withDoc("Used to test nested field defaults").build()});
        this.writeAndValidate(writeSchema, expectedSchema);
    }

    @Test
    public void testMapNestedDefaultValue() throws IOException {
        Assumptions.assumeThat((boolean)this.supportsDefaultValues()).isTrue();
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").withDoc("Should not produce default value").build(), Types.NestedField.optional((String)"nested_map").withId(3).ofType((Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)6, (String)"value_str", (Type)Types.StringType.get())}))).withDoc("Used to test nested map value field defaults").build()});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").build(), Types.NestedField.optional((String)"nested_map").withId(3).ofType((Type)Types.MapType.ofOptional((int)4, (int)5, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)6, (String)"value_str", (Type)Types.StringType.get()), Types.NestedField.optional((String)"value_int").withId(7).ofType((Type)Types.IntegerType.get()).withInitialDefault((Object)34).build()}))).withDoc("Used to test nested field defaults").build()});
        this.writeAndValidate(writeSchema, expectedSchema);
    }

    @Test
    public void testListNestedDefaultValue() throws IOException {
        Assumptions.assumeThat((boolean)this.supportsDefaultValues()).isTrue();
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").withDoc("Should not produce default value").build(), Types.NestedField.optional((String)"nested_list").withId(3).ofType((Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"element_str", (Type)Types.StringType.get())}))).withDoc("Used to test nested field defaults").build()});
        Schema expectedSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"data").withId(2).ofType((Type)Types.StringType.get()).withInitialDefault((Object)"wrong!").build(), Types.NestedField.optional((String)"nested_list").withId(3).ofType((Type)Types.ListType.ofOptional((int)4, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)5, (String)"element_str", (Type)Types.StringType.get()), Types.NestedField.optional((String)"element_int").withId(7).ofType((Type)Types.IntegerType.get()).withInitialDefault((Object)34).build()}))).withDoc("Used to test nested field defaults").build()});
        this.writeAndValidate(writeSchema, expectedSchema);
    }

    private static Stream<Arguments> primitiveTypesAndDefaults() {
        return Stream.of(Arguments.of((Object[])new Object[]{Types.BooleanType.get(), false}), Arguments.of((Object[])new Object[]{Types.IntegerType.get(), 34}), Arguments.of((Object[])new Object[]{Types.LongType.get(), 4900000000L}), Arguments.of((Object[])new Object[]{Types.FloatType.get(), Float.valueOf(12.21f)}), Arguments.of((Object[])new Object[]{Types.DoubleType.get(), -0.0}), Arguments.of((Object[])new Object[]{Types.DateType.get(), DateTimeUtil.isoDateToDays((String)"2024-12-17")}), Arguments.of((Object[])new Object[]{Types.TimeType.get(), DateTimeUtil.isoTimeToMicros((String)"23:59:59.999999")}), Arguments.of((Object[])new Object[]{Types.TimestampType.withZone(), DateTimeUtil.isoTimestamptzToMicros((String)"2024-12-17T23:59:59.999999+00:00")}), Arguments.of((Object[])new Object[]{Types.TimestampType.withoutZone(), DateTimeUtil.isoTimestampToMicros((String)"2024-12-17T23:59:59.999999")}), Arguments.of((Object[])new Object[]{Types.StringType.get(), "iceberg"}), Arguments.of((Object[])new Object[]{Types.UUIDType.get(), UUID.randomUUID()}), Arguments.of((Object[])new Object[]{Types.FixedType.ofLength((int)4), ByteBuffer.wrap(new byte[]{10, 11, 12, 13})}), Arguments.of((Object[])new Object[]{Types.BinaryType.get(), ByteBuffer.wrap(new byte[]{10, 11})}), Arguments.of((Object[])new Object[]{Types.DecimalType.of((int)9, (int)2), new BigDecimal("12.34")}));
    }

    @ParameterizedTest
    @MethodSource(value={"primitiveTypesAndDefaults"})
    public void testPrimitiveTypeDefaultValues(Type.PrimitiveType type, Object defaultValue) throws IOException {
        Assumptions.assumeThat((boolean)this.supportsDefaultValues()).isTrue();
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((String)"col_with_default").withId(2).ofType((Type)type).withInitialDefault(defaultValue).build()});
        this.writeAndValidate(writeSchema, readSchema);
    }

    @Test
    public void testWriteNullValueForRequiredType() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.required((int)1, (String)"string", (Type)Types.StringType.get())});
        GenericRecord genericRecord = GenericRecord.create((Schema)schema);
        genericRecord.set(0, (Object)42L);
        genericRecord.set(1, null);
        if (this.allowsWritingNullValuesForRequiredFields()) {
            this.writeAndValidate(schema, (List<Record>)ImmutableList.of((Object)genericRecord));
        } else {
            Assertions.assertThatThrownBy(() -> this.writeAndValidate(schema, (List<Record>)ImmutableList.of((Object)genericRecord)));
        }
    }
}

