/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.util.List;
import java.util.Map;
import org.apache.iceberg.data.GenericDataUtil;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;

public class DataTestHelpers {
    private DataTestHelpers() {
    }

    public static void assertEquals(Types.StructType struct, Record expected, Record actual) {
        Types.StructType expectedType = expected.struct();
        for (Types.NestedField field : struct.fields()) {
            Types.NestedField expectedField = expectedType.field(field.fieldId());
            if (expectedField != null) {
                DataTestHelpers.assertEquals(field.type(), expected.getField(expectedField.name()), actual.getField(field.name()));
                continue;
            }
            DataTestHelpers.assertEquals(field.type(), GenericDataUtil.internalToGeneric((Type)field.type(), (Object)field.initialDefault()), actual.getField(field.name()));
        }
    }

    public static void assertEquals(Types.ListType list, List<?> expected, List<?> actual) {
        Type elementType = list.elementType();
        ((ListAssert)Assertions.assertThat(actual).as("List size should match", new Object[0])).hasSameSizeAs(expected);
        for (int i = 0; i < expected.size(); ++i) {
            Object expectedValue = expected.get(i);
            Object actualValue = actual.get(i);
            DataTestHelpers.assertEquals(elementType, expectedValue, actualValue);
        }
    }

    public static void assertEquals(Types.MapType map, Map<?, ?> expected, Map<?, ?> actual) {
        Type valueType = map.valueType();
        ((MapAssert)Assertions.assertThat(actual).as("Map size should match", new Object[0])).hasSameSizeAs(expected);
        for (Object expectedKey : expected.keySet()) {
            Object expectedValue = expected.get(expectedKey);
            Object actualValue = actual.get(expectedKey);
            DataTestHelpers.assertEquals(valueType, expectedValue, actualValue);
        }
    }

    private static void assertEquals(Type type, Object expected, Object actual) {
        if (expected == null && actual == null) {
            return;
        }
        switch (type.typeId()) {
            case BOOLEAN: 
            case INTEGER: 
            case LONG: 
            case FLOAT: 
            case DOUBLE: 
            case STRING: 
            case DATE: 
            case TIME: 
            case TIMESTAMP: 
            case UUID: 
            case BINARY: 
            case DECIMAL: {
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Primitive value should be equal to expected for type " + type, new Object[0])).isEqualTo(expected);
                break;
            }
            case FIXED: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Actual should be a byte[]", new Object[0])).isInstanceOf(byte[].class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Array contents should be equal", new Object[0])).isEqualTo(expected);
                break;
            }
            case STRUCT: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a Record", new Object[0])).isInstanceOf(Record.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a Record", new Object[0])).isInstanceOf(Record.class);
                DataTestHelpers.assertEquals(type.asStructType(), (Record)expected, (Record)actual);
                break;
            }
            case LIST: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a List", new Object[0])).isInstanceOf(List.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a List", new Object[0])).isInstanceOf(List.class);
                DataTestHelpers.assertEquals(type.asListType(), (List)expected, (List)actual);
                break;
            }
            case MAP: {
                ((ObjectAssert)Assertions.assertThat((Object)expected).as("Expected should be a Map", new Object[0])).isInstanceOf(Map.class);
                ((ObjectAssert)Assertions.assertThat((Object)actual).as("Actual should be a Map", new Object[0])).isInstanceOf(Map.class);
                DataTestHelpers.assertEquals(type.asMapType(), (Map)expected, (Map)actual);
                break;
            }
            default: {
                throw new IllegalArgumentException("Not a supported type: " + type);
            }
        }
    }
}

