/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.StructLike;
import org.apache.iceberg.Table;
import org.apache.iceberg.TestTables;
import org.apache.iceberg.data.DeleteReadTests;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.InternalRecordWrapper;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.StructLikeSet;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestGenericReaderDeletes
extends DeleteReadTests {
    @TempDir
    private File tableDir;

    @Override
    protected Table createTable(String name, Schema schema, PartitionSpec spec) throws IOException {
        return TestTables.create((File)this.tableDir, (String)name, (Schema)schema, (PartitionSpec)spec, (int)this.formatVersion);
    }

    @Override
    protected void dropTable(String name) {
        TestTables.clearTables();
    }

    @Override
    public StructLikeSet rowSet(String name, Table table, String ... columns) throws IOException {
        StructLikeSet set = StructLikeSet.create((Types.StructType)table.schema().asStruct());
        try (CloseableIterable reader = IcebergGenerics.read((Table)table).select(columns).build();){
            Iterables.addAll((Collection)set, (Iterable)CloseableIterable.transform((CloseableIterable)reader, record -> new InternalRecordWrapper(table.schema().asStruct()).wrap((StructLike)record)));
        }
        return set;
    }

    @Override
    protected boolean expectPruned() {
        return false;
    }
}

