/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.iceberg.AppendFiles;
import org.apache.iceberg.DataFile;
import org.apache.iceberg.DataFiles;
import org.apache.iceberg.FileFormat;
import org.apache.iceberg.HistoryEntry;
import org.apache.iceberg.MetadataColumns;
import org.apache.iceberg.Parameter;
import org.apache.iceberg.ParameterizedTestExtension;
import org.apache.iceberg.Parameters;
import org.apache.iceberg.PartitionSpec;
import org.apache.iceberg.Schema;
import org.apache.iceberg.Table;
import org.apache.iceberg.Tables;
import org.apache.iceberg.data.GenericAppenderFactory;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.IcebergGenerics;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.expressions.Expression;
import org.apache.iceberg.expressions.Expressions;
import org.apache.iceberg.hadoop.HadoopInputFile;
import org.apache.iceberg.hadoop.HadoopOutputFile;
import org.apache.iceberg.hadoop.HadoopTables;
import org.apache.iceberg.io.CloseableIterable;
import org.apache.iceberg.io.CloseableIterator;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.relocated.com.google.common.base.Preconditions;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Iterables;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.apache.iceberg.relocated.com.google.common.collect.Sets;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.apache.iceberg.util.DateTimeUtil;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractThrowableAssert;
import org.assertj.core.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.TestTemplate;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.io.TempDir;

@ExtendWith(value={ParameterizedTestExtension.class})
public class TestLocalScan {
    private static final Schema SCHEMA = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get())});
    private static final Configuration CONF = new Configuration();
    private static final Tables TABLES = new HadoopTables(CONF);
    @Parameter
    private FileFormat format;
    @TempDir
    private File tempDir;
    private String sharedTableLocation = null;
    private Table sharedTable = null;
    private final Record genericRecord = GenericRecord.create((Schema)SCHEMA);
    private final List<Record> file1FirstSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)0L, (Object)"data", (Object)"clarification")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)1L, (Object)"data", (Object)"risky")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)2L, (Object)"data", (Object)"falafel")));
    private final List<Record> file2FirstSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)10L, (Object)"data", (Object)"clammy")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)11L, (Object)"data", (Object)"evacuate")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)12L, (Object)"data", (Object)"tissue")));
    private final List<Record> file3FirstSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)20L, (Object)"data", (Object)"ocean")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)21L, (Object)"data", (Object)"holistic")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)22L, (Object)"data", (Object)"preventative")));
    private final List<Record> file1SecondSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)4L, (Object)"data", (Object)"obscure")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)5L, (Object)"data", (Object)"secure")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)6L, (Object)"data", (Object)"fetta")));
    private final List<Record> file2SecondSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)14L, (Object)"data", (Object)"radical")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)15L, (Object)"data", (Object)"collocation")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)16L, (Object)"data", (Object)"book")));
    private final List<Record> file3SecondSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)24L, (Object)"data", (Object)"cloud")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)25L, (Object)"data", (Object)"zen")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)26L, (Object)"data", (Object)"sky")));
    private final List<Record> file1ThirdSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)6L, (Object)"data", (Object)"brainy")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)7L, (Object)"data", (Object)"film")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)8L, (Object)"data", (Object)"fetta")));
    private final List<Record> file2ThirdSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)16L, (Object)"data", (Object)"cake")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)17L, (Object)"data", (Object)"intrinsic")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)18L, (Object)"data", (Object)"paper")));
    private final List<Record> file3ThirdSnapshotRecords = ImmutableList.of((Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)26L, (Object)"data", (Object)"belleview")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)27L, (Object)"data", (Object)"overview")), (Object)this.genericRecord.copy((Map)ImmutableMap.of((Object)"id", (Object)28L, (Object)"data", (Object)"tender")));

    @Parameters(name="fileFormat = {0}")
    public static List<Object> parameters() {
        return Arrays.asList(FileFormat.PARQUET, FileFormat.ORC, FileFormat.AVRO);
    }

    private void overwriteExistingData() throws IOException {
        DataFile file12 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-12"), this.file1SecondSnapshotRecords);
        DataFile file22 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-22"), this.file2SecondSnapshotRecords);
        DataFile file32 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-32"), this.file3SecondSnapshotRecords);
        this.sharedTable.newOverwrite().overwriteByRowFilter((Expression)Expressions.alwaysTrue()).addFile(file12).addFile(file22).addFile(file32).commit();
        DataFile file13 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-13"), this.file1ThirdSnapshotRecords);
        DataFile file23 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-23"), this.file2ThirdSnapshotRecords);
        DataFile file33 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-33"), this.file3ThirdSnapshotRecords);
        this.sharedTable.newOverwrite().overwriteByRowFilter((Expression)Expressions.alwaysTrue()).addFile(file13).addFile(file23).addFile(file33).commit();
    }

    private void appendData() throws IOException {
        DataFile file12 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-12"), this.file1SecondSnapshotRecords);
        DataFile file22 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-22"), this.file2SecondSnapshotRecords);
        DataFile file32 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-32"), this.file3SecondSnapshotRecords);
        this.sharedTable.newFastAppend().appendFile(file12).appendFile(file22).appendFile(file32).commit();
        DataFile file13 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-13"), this.file1ThirdSnapshotRecords);
        DataFile file23 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-23"), this.file2ThirdSnapshotRecords);
        DataFile file33 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-33"), this.file3ThirdSnapshotRecords);
        this.sharedTable.newFastAppend().appendFile(file13).appendFile(file23).appendFile(file33).commit();
    }

    @BeforeEach
    public void createTables() throws IOException {
        File location = Files.createTempDirectory(this.tempDir.toPath(), "shared", new FileAttribute[0]).toFile();
        this.sharedTableLocation = location.toString();
        this.sharedTable = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)this.format.name()), this.sharedTableLocation);
        GenericRecord record = GenericRecord.create((Schema)SCHEMA);
        DataFile file1 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-1"), this.file1FirstSnapshotRecords);
        Record nullData = record.copy();
        nullData.setField("id", (Object)11L);
        nullData.setField("data", null);
        DataFile file2 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-2"), this.file2FirstSnapshotRecords);
        DataFile file3 = this.writeFile(this.sharedTableLocation, this.format.addExtension("file-3"), this.file3FirstSnapshotRecords);
        this.sharedTable.newAppend().appendFile(file1).appendFile(file2).appendFile(file3).commit();
    }

    @TestTemplate
    public void testRandomData() throws IOException {
        List<Record> expected = RandomGenericData.generate(SCHEMA, 1000, 435691832918L);
        File location = Files.createTempDirectory(this.tempDir.toPath(), "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)location.delete()).isTrue();
        Table table = TABLES.create(SCHEMA, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)this.format.name()), location.toString());
        AppendFiles append = table.newAppend();
        int fileNum = 0;
        int recordsPerFile = 200;
        Iterator<Record> iter = expected.iterator();
        while (iter.hasNext()) {
            int numRecords;
            Path path = new Path(location.toString(), this.format.addExtension("file-" + fileNum));
            ArrayList records = Lists.newArrayList();
            for (numRecords = 0; numRecords < recordsPerFile && iter.hasNext(); ++numRecords) {
                records.add(iter.next());
            }
            this.writeFile(location.toString(), this.format.addExtension("file-" + fileNum), records);
            DataFile file = DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withRecordCount((long)numRecords).withInputFile((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)CONF)).build();
            append.appendFile(file);
            ++fileNum;
        }
        append.commit();
        HashSet records = Sets.newHashSet((Iterable)IcebergGenerics.read((Table)table).build());
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Should produce correct number of records", new Object[0])).hasSameSizeAs(expected);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Random record set should match", new Object[0])).isEqualTo((Object)Sets.newHashSet(expected));
    }

    @TestTemplate
    public void testFullScan() {
        CloseableIterable results = IcebergGenerics.read((Table)this.sharedTable).build();
        HashSet expected = Sets.newHashSet();
        expected.addAll(this.file1FirstSnapshotRecords);
        expected.addAll(this.file2FirstSnapshotRecords);
        expected.addAll(this.file3FirstSnapshotRecords);
        HashSet records = Sets.newHashSet((Iterable)results);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Should produce correct number of records", new Object[0])).hasSameSizeAs((Iterable)expected);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Random record set should match", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testFilter() {
        CloseableIterable result = IcebergGenerics.read((Table)this.sharedTable).where((Expression)Expressions.lessThan((String)"id", (Object)3)).build();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)Sets.newHashSet((Iterable)result)).as("Records should match file 1", new Object[0])).isEqualTo((Object)Sets.newHashSet(this.file1FirstSnapshotRecords));
        result = IcebergGenerics.read((Table)this.sharedTable).where((Expression)Expressions.lessThan((String)"iD", (Object)3)).caseInsensitive().build();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)Sets.newHashSet((Iterable)result)).as("Records should match file 1", new Object[0])).isEqualTo((Object)Sets.newHashSet(this.file1FirstSnapshotRecords));
        result = IcebergGenerics.read((Table)this.sharedTable).where((Expression)Expressions.lessThanOrEqual((String)"id", (Object)1)).build();
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)Sets.newHashSet((Iterable)result)).as("Records should match file 1 without id 2", new Object[0])).isEqualTo((Object)Sets.newHashSet((Iterable)Iterables.filter(this.file1FirstSnapshotRecords, r -> (Long)r.getField("id") <= 1L)));
    }

    @TestTemplate
    public void testProject() {
        this.verifyProjectIdColumn((Iterable<Record>)IcebergGenerics.read((Table)this.sharedTable).select(new String[]{"id"}).build());
        this.verifyProjectIdColumn((Iterable<Record>)IcebergGenerics.read((Table)this.sharedTable).select(new String[]{"iD"}).caseInsensitive().build());
    }

    private void verifyProjectIdColumn(Iterable<Record> results) {
        HashSet expected = Sets.newHashSet();
        expected.addAll(Lists.transform(this.file1FirstSnapshotRecords, record -> (Long)record.getField("id")));
        expected.addAll(Lists.transform(this.file2FirstSnapshotRecords, record -> (Long)record.getField("id")));
        expected.addAll(Lists.transform(this.file3FirstSnapshotRecords, record -> (Long)record.getField("id")));
        results.forEach(record -> ((AbstractIntegerAssert)Assertions.assertThat((int)record.size()).as("Record should have one projected field", new Object[0])).isEqualTo(1));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)Sets.newHashSet((Iterable)Iterables.transform(results, record -> (Long)record.getField("id")))).as("Should project only id columns", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testProjectWithSchema() {
        CloseableIterable results = IcebergGenerics.read((Table)this.sharedTable).project(SCHEMA).build();
        HashSet expected = Sets.newHashSet();
        expected.addAll(this.file1FirstSnapshotRecords);
        expected.addAll(this.file2FirstSnapshotRecords);
        expected.addAll(this.file3FirstSnapshotRecords);
        results.forEach(record -> expected.remove(record));
        Assertions.assertThat((Collection)expected).isEmpty();
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get())});
        this.verifyProjectIdColumn((Iterable<Record>)IcebergGenerics.read((Table)this.sharedTable).project(schema).build());
        schema = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)999, (String)"unknown", (Type)Types.LongType.get())});
        IcebergGenerics.read((Table)this.sharedTable).project(schema).build().forEach(r -> Assertions.assertThat((Object)r.get(0)).isNull());
        schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"id", (Type)Types.LongType.get()), MetadataColumns.metadataColumn((Table)this.sharedTable, (String)"_partition"), Types.NestedField.optional((int)2, (String)"data", (Type)Types.StringType.get()), MetadataColumns.SPEC_ID, MetadataColumns.ROW_POSITION});
        CloseableIterator iterator = IcebergGenerics.read((Table)this.sharedTable).project(schema).where((Expression)Expressions.equal((String)"data", (Object)"falafel")).build().iterator();
        GenericRecord expectedRecord = GenericRecord.create((Schema)schema).copy((Map)ImmutableMap.of((Object)"id", (Object)2L, (Object)"data", (Object)"falafel", (Object)"_spec_id", (Object)0, (Object)"_pos", (Object)2L));
        expectedRecord.setField("_partition", null);
        Assertions.assertThat((Object)((Record)iterator.next())).isEqualTo((Object)expectedRecord);
        Assertions.assertThat((Iterator)iterator).isExhausted();
    }

    @TestTemplate
    public void testProjectWithMissingFilterColumn() {
        CloseableIterable results = IcebergGenerics.read((Table)this.sharedTable).where((Expression)Expressions.greaterThanOrEqual((String)"id", (Object)1)).where((Expression)Expressions.lessThan((String)"id", (Object)21)).select(new String[]{"data"}).build();
        HashSet expected = Sets.newHashSet();
        for (Record record2 : Iterables.concat(this.file1FirstSnapshotRecords, this.file2FirstSnapshotRecords, this.file3FirstSnapshotRecords)) {
            Long id = (Long)record2.getField("id");
            if (id < 1L || id >= 21L) continue;
            expected.add(record2.getField("data").toString());
        }
        results.forEach(record -> ((AbstractIntegerAssert)Assertions.assertThat((int)record.size()).as("Record should have two projected fields", new Object[0])).isEqualTo(2));
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)Sets.newHashSet((Iterable)Iterables.transform((Iterable)results, record -> record.getField("data").toString()))).as("Should project correct rows", new Object[0])).isEqualTo((Object)expected);
    }

    @TestTemplate
    public void testUseSnapshot() throws IOException {
        this.overwriteExistingData();
        CloseableIterable results = IcebergGenerics.read((Table)this.sharedTable).useSnapshot(((HistoryEntry)this.sharedTable.history().get(1)).snapshotId()).build();
        HashSet expected = Sets.newHashSet();
        expected.addAll(this.file1SecondSnapshotRecords);
        expected.addAll(this.file2SecondSnapshotRecords);
        expected.addAll(this.file3SecondSnapshotRecords);
        HashSet records = Sets.newHashSet((Iterable)results);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Should produce correct number of records", new Object[0])).hasSameSizeAs((Iterable)expected);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Record set should match", new Object[0])).isEqualTo((Object)Sets.newHashSet((Iterable)expected));
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("id")).isNotNull();
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("data")).isNotNull();
    }

    @TestTemplate
    public void testAsOfTime() throws IOException {
        this.overwriteExistingData();
        CloseableIterable results = IcebergGenerics.read((Table)this.sharedTable).asOfTime(((HistoryEntry)this.sharedTable.history().get(2)).timestampMillis()).build();
        HashSet expected = Sets.newHashSet();
        expected.addAll(this.file1ThirdSnapshotRecords);
        expected.addAll(this.file2ThirdSnapshotRecords);
        expected.addAll(this.file3ThirdSnapshotRecords);
        HashSet records = Sets.newHashSet((Iterable)results);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Should produce correct number of records", new Object[0])).hasSameSizeAs((Iterable)expected);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Record set should match", new Object[0])).isEqualTo((Object)Sets.newHashSet((Iterable)expected));
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("id")).isNotNull();
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("data")).isNotNull();
    }

    @TestTemplate
    public void testAppendsBetween() throws IOException {
        this.appendData();
        CloseableIterable results = IcebergGenerics.read((Table)this.sharedTable).appendsBetween(((HistoryEntry)this.sharedTable.history().get(1)).snapshotId(), this.sharedTable.currentSnapshot().snapshotId()).build();
        HashSet expected = Sets.newHashSet();
        expected.addAll(this.file1ThirdSnapshotRecords);
        expected.addAll(this.file2ThirdSnapshotRecords);
        expected.addAll(this.file3ThirdSnapshotRecords);
        HashSet records = Sets.newHashSet((Iterable)results);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Should produce correct number of records", new Object[0])).hasSameSizeAs((Iterable)expected);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Record set should match", new Object[0])).isEqualTo((Object)Sets.newHashSet((Iterable)expected));
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("id")).isNotNull();
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("data")).isNotNull();
    }

    @TestTemplate
    public void testAppendsAfter() throws IOException {
        this.appendData();
        CloseableIterable results = IcebergGenerics.read((Table)this.sharedTable).appendsAfter(((HistoryEntry)this.sharedTable.history().get(0)).snapshotId()).build();
        HashSet expected = Sets.newHashSet();
        expected.addAll(this.file1SecondSnapshotRecords);
        expected.addAll(this.file2SecondSnapshotRecords);
        expected.addAll(this.file3SecondSnapshotRecords);
        expected.addAll(this.file1ThirdSnapshotRecords);
        expected.addAll(this.file2ThirdSnapshotRecords);
        expected.addAll(this.file3ThirdSnapshotRecords);
        HashSet records = Sets.newHashSet((Iterable)results);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Should produce correct number of records", new Object[0])).hasSameSizeAs((Iterable)expected);
        ((AbstractCollectionAssert)Assertions.assertThat((Collection)records).as("Record set should match", new Object[0])).isEqualTo((Object)Sets.newHashSet((Iterable)expected));
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("id")).isNotNull();
        Assertions.assertThat((Object)((Record)Iterables.get((Iterable)records, (int)0)).getField("data")).isNotNull();
    }

    @TestTemplate
    public void testUnknownSnapshotId() {
        Long minSnapshotId = this.sharedTable.history().stream().map(h -> h.snapshotId()).min(Long::compareTo).get();
        IcebergGenerics.ScanBuilder scanBuilder = IcebergGenerics.read((Table)this.sharedTable);
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> scanBuilder.useSnapshot(minSnapshotId - 1L)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find snapshot with ID " + (minSnapshotId - 1L));
    }

    @TestTemplate
    public void testAsOfTimeOlderThanFirstSnapshot() {
        IcebergGenerics.ScanBuilder scanBuilder = IcebergGenerics.read((Table)this.sharedTable);
        long timestamp = ((HistoryEntry)this.sharedTable.history().get(0)).timestampMillis() - 1L;
        ((AbstractThrowableAssert)Assertions.assertThatThrownBy(() -> scanBuilder.asOfTime(timestamp)).isInstanceOf(IllegalArgumentException.class)).hasMessage("Cannot find a snapshot older than " + DateTimeUtil.formatTimestampMillis((long)timestamp));
    }

    private DataFile writeFile(String location, String filename, List<Record> records) throws IOException {
        return this.writeFile(location, filename, SCHEMA, records);
    }

    private DataFile writeFile(String location, String filename, Schema schema, List<Record> records) throws IOException {
        FileAppender fileAppender;
        Path path = new Path(location, filename);
        FileFormat fileFormat = FileFormat.fromFileName((CharSequence)filename);
        Preconditions.checkNotNull((Object)fileFormat, (String)"Cannot determine format for file: %s", (Object)filename);
        try (FileAppender appender = fileAppender = new GenericAppenderFactory(schema).newAppender(HadoopOutputFile.fromPath((Path)path, (Configuration)CONF), fileFormat);){
            appender.addAll(records);
        }
        return DataFiles.builder((PartitionSpec)PartitionSpec.unpartitioned()).withInputFile((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)CONF)).withMetrics(fileAppender.metrics()).build();
    }

    @TestTemplate
    public void testFilterWithDateAndTimestamp() throws IOException {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"timestamp_with_zone", (Type)Types.TimestampType.withZone()), Types.NestedField.required((int)2, (String)"timestamp_without_zone", (Type)Types.TimestampType.withoutZone()), Types.NestedField.required((int)3, (String)"date", (Type)Types.DateType.get()), Types.NestedField.required((int)4, (String)"time", (Type)Types.TimeType.get())});
        File tableLocation = Files.createTempDirectory(this.tempDir.toPath(), "junit", new FileAttribute[0]).toFile();
        Assertions.assertThat((boolean)tableLocation.delete()).isTrue();
        Table table = TABLES.create(schema, PartitionSpec.unpartitioned(), (Map)ImmutableMap.of((Object)"write.format.default", (Object)this.format.name()), tableLocation.getAbsolutePath());
        List<Record> expected = RandomGenericData.generate(schema, 100, 435691832918L);
        DataFile file = this.writeFile(tableLocation.toString(), this.format.addExtension("record-file"), schema, expected);
        table.newFastAppend().appendFile(file).commit();
        for (Record r : expected) {
            CloseableIterable filterResult = IcebergGenerics.read((Table)table).where((Expression)Expressions.equal((String)"timestamp_with_zone", (Object)r.getField("timestamp_with_zone").toString())).where((Expression)Expressions.equal((String)"timestamp_without_zone", (Object)r.getField("timestamp_without_zone").toString())).where((Expression)Expressions.equal((String)"date", (Object)r.getField("date").toString())).where((Expression)Expressions.equal((String)"time", (Object)r.getField("time").toString())).build();
            Assertions.assertThat(filterResult.iterator()).hasNext();
            Record readRecord = (Record)filterResult.iterator().next();
            Assertions.assertThat((Object)readRecord.getField("timestamp_with_zone")).isEqualTo(r.getField("timestamp_with_zone"));
        }
    }

    private static ByteBuffer longToBuffer(long value) {
        return ByteBuffer.allocate(8).order(ByteOrder.LITTLE_ENDIAN).putLong(0, value);
    }
}

