/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data;

import java.io.File;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.time.ZoneOffset;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iceberg.Schema;
import org.apache.iceberg.data.GenericRecord;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableList;
import org.apache.iceberg.relocated.com.google.common.collect.ImmutableMap;
import org.apache.iceberg.relocated.com.google.common.collect.Maps;
import org.apache.iceberg.types.Type;
import org.apache.iceberg.types.Types;
import org.assertj.core.api.AbstractCharSequenceAssert;
import org.assertj.core.api.AbstractCollectionAssert;
import org.assertj.core.api.AbstractFloatAssert;
import org.assertj.core.api.AbstractIntegerAssert;
import org.assertj.core.api.AbstractLongAssert;
import org.assertj.core.api.AbstractStringAssert;
import org.assertj.core.api.Assertions;
import org.assertj.core.api.ListAssert;
import org.assertj.core.api.MapAssert;
import org.assertj.core.api.ObjectAssert;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public abstract class TestReadProjection {
    @TempDir
    protected File tempDir;

    protected abstract Record writeAndRead(String var1, Schema var2, Schema var3, Record var4) throws IOException;

    @Test
    public void testFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)schema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Record projected = this.writeAndRead("full_projection", schema, schema, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)((CharSequence)projected.getField("data"))).as("Should contain the correct data value", new Object[0])).isEqualTo((Object)"test");
    }

    @Test
    public void testSpecialCharacterProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"user id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data%0", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)schema.asStruct());
        record.setField("user id", (Object)34L);
        record.setField("data%0", (Object)"test");
        Record full = this.writeAndRead("special_chars", schema, schema, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)full.getField("user id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)((CharSequence)full.getField("data%0"))).as("Should contain the correct data value", new Object[0])).isEqualTo((Object)"test");
        Record projected = this.writeAndRead("special_characters", schema, schema.select(new String[]{"data%0"}), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("user id")).as("Should not contain id value", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)((CharSequence)projected.getField("data%0"))).as("Should contain the correct data value", new Object[0])).isEqualTo((Object)"test");
    }

    @Test
    public void testReorderedFullProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)schema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("full_projection", schema, reordered, (Record)record);
        ((AbstractStringAssert)Assertions.assertThat((String)projected.get(0).toString()).as("Should contain the correct 0 value", new Object[0])).isEqualTo("test");
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(1)).as("Should contain the correct 1 value", new Object[0])).isEqualTo((Object)34L);
    }

    @Test
    public void testReorderedProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)schema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Schema reordered = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)2, (String)"missing_1", (Type)Types.StringType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)3, (String)"missing_2", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("full_projection", schema, reordered, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(0)).as("Should contain the correct 0 value", new Object[0])).isNull();
        ((AbstractStringAssert)Assertions.assertThat((String)projected.get(1).toString()).as("Should contain the correct 1 value", new Object[0])).isEqualTo("test");
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(2)).as("Should contain the correct 2 value", new Object[0])).isNull();
    }

    @Test
    public void testRenamedAddedField() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.required((int)2, (String)"b", (Type)Types.LongType.get()), Types.NestedField.required((int)3, (String)"d", (Type)Types.LongType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)schema.asStruct());
        record.setField("a", (Object)100L);
        record.setField("b", (Object)200L);
        record.setField("d", (Object)300L);
        Schema renamedAdded = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"c", (Type)Types.LongType.get()), Types.NestedField.optional((int)4, (String)"d", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("rename_and_add_column_projection", schema, renamedAdded, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(0)).as("Should contain the correct value in column 1", new Object[0])).isEqualTo((Object)100L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("a")).as("Should contain the correct value in column a", new Object[0])).isEqualTo((Object)100L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(1)).as("Should contain the correct value in column 2", new Object[0])).isEqualTo((Object)200L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("b")).as("Should contain the correct value in column b", new Object[0])).isEqualTo((Object)200L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(2)).as("Should contain the correct value in column 3", new Object[0])).isEqualTo((Object)300L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("c")).as("Should contain the correct value in column c", new Object[0])).isEqualTo((Object)300L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(3)).as("Should contain the correct value in column 4", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("d")).as("Should contain the correct value in column d", new Object[0])).isNull();
    }

    @Test
    public void testEmptyProjection() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)schema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Record projected = this.writeAndRead("empty_projection", schema, schema.select(new String[0]), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected).as("Should read a non-null record", new Object[0])).isNotNull();
        Assertions.assertThatThrownBy(() -> projected.get(0)).isInstanceOf(ArrayIndexOutOfBoundsException.class);
    }

    @Test
    public void testBasicProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get()), Types.NestedField.optional((int)2, (String)"time", (Type)Types.TimestampType.withZone())});
        GenericRecord record = GenericRecord.create((Types.StructType)writeSchema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        record.setField("time", (Object)OffsetDateTime.now(ZoneOffset.UTC));
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("basic_projection_id", writeSchema, idOnly, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("data")).as("Should not project data", new Object[0])).isNull();
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        Schema dataOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        projected = this.writeAndRead("basic_projection_data", writeSchema, dataOnly, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)((CharSequence)projected.getField("data"))).as("Should contain the correct data value", new Object[0])).isEqualTo((Object)"test");
    }

    @Test
    public void testRename() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"data", (Type)Types.StringType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)writeSchema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("data", (Object)"test");
        Schema readSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)1, (String)"renamed", (Type)Types.StringType.get())});
        Record projected = this.writeAndRead("project_and_rename", writeSchema, readSchema, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((AbstractCharSequenceAssert)Assertions.assertThat((CharSequence)((CharSequence)projected.getField("renamed"))).as("Should contain the correct data/renamed value", new Object[0])).isEqualTo((Object)"test");
    }

    @Test
    public void testNestedStructProjection() throws Exception {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        GenericRecord record = GenericRecord.create((Types.StructType)writeSchema.asStruct());
        record.setField("id", (Object)34L);
        GenericRecord location = GenericRecord.create((Types.StructType)writeSchema.findType("location").asStructType());
        location.setField("lat", (Object)Float.valueOf(52.995144f));
        location.setField("long", (Object)Float.valueOf(-1.539054f));
        record.setField("location", (Object)location);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        Record projectedLocation = (Record)projected.getField("location");
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((ObjectAssert)Assertions.assertThat((Object)projectedLocation).as("Should not project location", new Object[0])).isNull();
        Schema latOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("latitude_only", writeSchema, latOnly, (Record)record);
        projectedLocation = (Record)projected.getField("location");
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("location")).as("Should project location", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("long")).as("Should not project longitude", new Object[0])).isNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedLocation.getField("lat")).floatValue()).as("Should project latitude", new Object[0])).isCloseTo(52.995144f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        Schema longOnly = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)3, (String)"location", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())}))});
        projected = this.writeAndRead("longitude_only", writeSchema, longOnly, (Record)record);
        projectedLocation = (Record)projected.getField("location");
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("location")).as("Should project location", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedLocation.getField("lat")).as("Should not project latitude", new Object[0])).isNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedLocation.getField("long")).floatValue()).as("Should project longitude", new Object[0])).isCloseTo(-1.539054f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        Schema locationOnly = writeSchema.select(new String[]{"location"});
        projected = this.writeAndRead("location_only", writeSchema, locationOnly, (Record)record);
        projectedLocation = (Record)projected.getField("location");
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("location")).as("Should project location", new Object[0])).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedLocation.getField("lat")).floatValue()).as("Should project latitude", new Object[0])).isCloseTo(52.995144f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedLocation.getField("long")).floatValue()).as("Should project longitude", new Object[0])).isCloseTo(-1.539054f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
    }

    @Test
    public void testMapProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"properties", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StringType.get()))});
        ImmutableMap properties = ImmutableMap.of((Object)"a", (Object)"A", (Object)"b", (Object)"B");
        GenericRecord record = GenericRecord.create((Types.StructType)writeSchema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("properties", (Object)properties);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("properties")).as("Should not project properties map", new Object[0])).isNull();
        Schema keyOnly = writeSchema.select(new String[]{"properties.key"});
        projected = this.writeAndRead("key_only", writeSchema, keyOnly, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((MapAssert)Assertions.assertThat(this.toStringMap((Map)projected.getField("properties"))).as("Should project entire map", new Object[0])).isEqualTo((Object)properties);
        Schema valueOnly = writeSchema.select(new String[]{"properties.value"});
        projected = this.writeAndRead("value_only", writeSchema, valueOnly, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((MapAssert)Assertions.assertThat(this.toStringMap((Map)projected.getField("properties"))).as("Should project entire map", new Object[0])).isEqualTo((Object)properties);
        Schema mapOnly = writeSchema.select(new String[]{"properties"});
        projected = this.writeAndRead("map_only", writeSchema, mapOnly, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((MapAssert)Assertions.assertThat(this.toStringMap((Map)projected.getField("properties"))).as("Should project entire map", new Object[0])).isEqualTo((Object)properties);
    }

    private Map<String, ?> toStringMap(Map<?, ?> map) {
        HashMap stringMap = Maps.newHashMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (entry.getValue() instanceof CharSequence) {
                stringMap.put(entry.getKey().toString(), entry.getValue().toString());
                continue;
            }
            stringMap.put(entry.getKey().toString(), entry.getValue());
        }
        return stringMap;
    }

    @Test
    public void testMapOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"lat", (Type)Types.FloatType.get()), Types.NestedField.required((int)2, (String)"long", (Type)Types.FloatType.get())})))});
        GenericRecord record = GenericRecord.create((Types.StructType)writeSchema.asStruct());
        record.setField("id", (Object)34L);
        GenericRecord l1 = GenericRecord.create((Types.StructType)writeSchema.findType("locations").asMapType().valueType().asStructType());
        l1.setField("lat", (Object)Float.valueOf(53.99281f));
        l1.setField("long", (Object)Float.valueOf(-1.542616f));
        GenericRecord l2 = GenericRecord.create((Types.StructType)writeSchema.findType("locations").asMapType().valueType().asStructType());
        l2.setField("lat", (Object)Float.valueOf(52.995144f));
        l2.setField("long", (Object)Float.valueOf(-1.539054f));
        record.setField("locations", (Object)ImmutableMap.of((Object)"L1", (Object)l1, (Object)"L2", (Object)l2));
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("locations")).as("Should not project locations map", new Object[0])).isNull();
        projected = this.writeAndRead("all_locations", writeSchema, writeSchema.select(new String[]{"locations"}), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((MapAssert)Assertions.assertThat(this.toStringMap((Map)projected.getField("locations"))).as("Should project locations map", new Object[0])).isEqualTo(record.getField("locations"));
        projected = this.writeAndRead("lat_only", writeSchema, writeSchema.select(new String[]{"locations.lat"}), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        Map<String, ?> locations = this.toStringMap((Map)projected.getField("locations"));
        ((MapAssert)Assertions.assertThat(locations).as("Should project locations map", new Object[0])).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat(locations.keySet()).as("Should contain L1 and L2", new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"L1", "L2"});
        Record projectedL1 = (Record)locations.get("L1");
        ((ObjectAssert)Assertions.assertThat((Object)projectedL1).as("L1 should not be null", new Object[0])).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedL1.getField("lat")).floatValue()).as("L1 should contain lat", new Object[0])).isCloseTo(53.99281f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        ((ObjectAssert)Assertions.assertThat((Object)projectedL1.getField("long")).as("L1 should not contain long", new Object[0])).isNull();
        Record projectedL2 = (Record)locations.get("L2");
        ((ObjectAssert)Assertions.assertThat((Object)projectedL2).as("L2 should not be null", new Object[0])).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedL2.getField("lat")).floatValue()).as("L2 should contain lat", new Object[0])).isCloseTo(52.995144f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        ((ObjectAssert)Assertions.assertThat((Object)projectedL2.getField("long")).as("L2 should not contain long", new Object[0])).isNull();
        projected = this.writeAndRead("long_only", writeSchema, writeSchema.select(new String[]{"locations.long"}), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        locations = this.toStringMap((Map)projected.getField("locations"));
        ((MapAssert)Assertions.assertThat(locations).as("Should project locations map", new Object[0])).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat(locations.keySet()).as("Should contain L1 and L2", new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"L1", "L2"});
        projectedL1 = (Record)locations.get("L1");
        ((ObjectAssert)Assertions.assertThat((Object)projectedL1).as("L1 should not be null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedL1.getField("lat")).as("L1 should not contain lat", new Object[0])).isNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedL1.getField("long")).floatValue()).as("L1 should contain long", new Object[0])).isCloseTo(-1.542616f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        projectedL2 = (Record)locations.get("L2");
        ((ObjectAssert)Assertions.assertThat((Object)projectedL2).as("L2 should not be null", new Object[0])).isNotNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedL2.getField("lat")).as("L2 should not contain lat", new Object[0])).isNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedL2.getField("long")).floatValue()).as("L2 should contain long", new Object[0])).isCloseTo(-1.539054f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        Schema latitiudeRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)5, (String)"locations", (Type)Types.MapType.ofOptional((int)6, (int)7, (Type)Types.StringType.get(), (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)1, (String)"latitude", (Type)Types.FloatType.get())})))});
        projected = this.writeAndRead("latitude_renamed", writeSchema, latitiudeRenamed, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        locations = this.toStringMap((Map)projected.getField("locations"));
        ((MapAssert)Assertions.assertThat(locations).as("Should project locations map", new Object[0])).isNotNull();
        ((AbstractCollectionAssert)Assertions.assertThat(locations.keySet()).as("Should contain L1 and L2", new Object[0])).containsExactlyInAnyOrder((Object[])new String[]{"L1", "L2"});
        projectedL1 = (Record)locations.get("L1");
        ((ObjectAssert)Assertions.assertThat((Object)projectedL1).as("L1 should not be null", new Object[0])).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedL1.getField("latitude")).floatValue()).as("L1 should contain latitude", new Object[0])).isCloseTo(53.99281f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        ((ObjectAssert)Assertions.assertThat((Object)projectedL1.getField("lat")).as("L1 should not contain lat", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedL1.getField("long")).as("L1 should not contain long", new Object[0])).isNull();
        projectedL2 = (Record)locations.get("L2");
        ((ObjectAssert)Assertions.assertThat((Object)projectedL2).as("L2 should not be null", new Object[0])).isNotNull();
        ((AbstractFloatAssert)Assertions.assertThat((float)((Float)projectedL2.getField("latitude")).floatValue()).as("L2 should contain latitude", new Object[0])).isCloseTo(52.995144f, Assertions.within((Float)Float.valueOf(1.0E-6f)));
        ((ObjectAssert)Assertions.assertThat((Object)projectedL2.getField("lat")).as("L2 should not contain lat", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedL2.getField("long")).as("L2 should not contain long", new Object[0])).isNull();
    }

    @Test
    public void testListProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)10, (String)"values", (Type)Types.ListType.ofOptional((int)11, (Type)Types.LongType.get()))});
        ImmutableList values = ImmutableList.of((Object)56L, (Object)57L, (Object)58L);
        GenericRecord record = GenericRecord.create((Types.StructType)writeSchema.asStruct());
        record.setField("id", (Object)34L);
        record.setField("values", (Object)values);
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("values")).as("Should not project values list", new Object[0])).isNull();
        Schema elementOnly = writeSchema.select(new String[]{"values.element"});
        projected = this.writeAndRead("element_only", writeSchema, elementOnly, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("values")).as("Should project entire list", new Object[0])).isEqualTo((Object)values);
        Schema listOnly = writeSchema.select(new String[]{"values"});
        projected = this.writeAndRead("list_only", writeSchema, listOnly, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("values")).as("Should project entire list", new Object[0])).isEqualTo((Object)values);
    }

    @Test
    public void testListOfStructsProjection() throws IOException {
        Schema writeSchema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get()), Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)19, (String)"x", (Type)Types.IntegerType.get()), Types.NestedField.optional((int)18, (String)"y", (Type)Types.IntegerType.get())})))});
        GenericRecord record = GenericRecord.create((Types.StructType)writeSchema.asStruct());
        record.setField("id", (Object)34L);
        GenericRecord p1 = GenericRecord.create((Types.StructType)writeSchema.findType("points").asListType().elementType().asStructType());
        p1.setField("x", (Object)1);
        p1.setField("y", (Object)2);
        GenericRecord p2 = GenericRecord.create((Types.StructType)writeSchema.findType("points").asListType().elementType().asStructType());
        p2.setField("x", (Object)3);
        p2.setField("y", null);
        record.setField("points", (Object)ImmutableList.of((Object)p1, (Object)p2));
        Schema idOnly = new Schema(new Types.NestedField[]{Types.NestedField.required((int)0, (String)"id", (Type)Types.LongType.get())});
        Record projected = this.writeAndRead("id_only", writeSchema, idOnly, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("id"))).as("Should contain the correct id value", new Object[0])).isEqualTo(34L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("points")).as("Should not project points list", new Object[0])).isNull();
        projected = this.writeAndRead("all_points", writeSchema, writeSchema.select(new String[]{"points"}), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("points")).as("Should project points list", new Object[0])).isEqualTo(record.getField("points"));
        projected = this.writeAndRead("x_only", writeSchema, writeSchema.select(new String[]{"points.x"}), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("points")).as("Should project points list", new Object[0])).isNotNull();
        List points = (List)projected.getField("points");
        ((ListAssert)Assertions.assertThat((List)points).as("Should read 2 points", new Object[0])).hasSize(2);
        Record projectedP1 = (Record)points.get(0);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)projectedP1.getField("x"))).as("Should project x", new Object[0])).isEqualTo(1);
        ((ObjectAssert)Assertions.assertThat((Object)projectedP1.getField("y")).as("Should not project y", new Object[0])).isNull();
        Record projectedP2 = (Record)points.get(1);
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)projectedP2.getField("x"))).as("Should project x", new Object[0])).isEqualTo(3);
        ((ObjectAssert)Assertions.assertThat((Object)projectedP2.getField("y")).as("Should not project y", new Object[0])).isNull();
        projected = this.writeAndRead("y_only", writeSchema, writeSchema.select(new String[]{"points.y"}), (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("points")).as("Should project points list", new Object[0])).isNotNull();
        points = (List)projected.getField("points");
        ((ListAssert)Assertions.assertThat((List)points).as("Should read 2 points", new Object[0])).hasSize(2);
        projectedP1 = (Record)points.get(0);
        ((ObjectAssert)Assertions.assertThat((Object)projectedP1.getField("x")).as("Should not project x", new Object[0])).isNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)projectedP1.getField("y"))).as("Should project y", new Object[0])).isEqualTo(2);
        projectedP2 = (Record)points.get(1);
        ((ObjectAssert)Assertions.assertThat((Object)projectedP2.getField("x")).as("Should not project x", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedP2.getField("y")).as("Should project null y", new Object[0])).isNull();
        Schema yRenamed = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)22, (String)"points", (Type)Types.ListType.ofOptional((int)21, (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.optional((int)18, (String)"z", (Type)Types.IntegerType.get())})))});
        projected = this.writeAndRead("y_renamed", writeSchema, yRenamed, (Record)record);
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("id")).as("Should not project id", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("points")).as("Should project points list", new Object[0])).isNotNull();
        points = (List)projected.getField("points");
        ((ListAssert)Assertions.assertThat((List)points).as("Should read 2 points", new Object[0])).hasSize(2);
        projectedP1 = (Record)points.get(0);
        ((ObjectAssert)Assertions.assertThat((Object)projectedP1.getField("x")).as("Should not project x", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedP1.getField("y")).as("Should not project y", new Object[0])).isNull();
        ((AbstractIntegerAssert)Assertions.assertThat((int)((Integer)projectedP1.getField("z"))).as("Should project z", new Object[0])).isEqualTo(2);
        projectedP2 = (Record)points.get(1);
        ((ObjectAssert)Assertions.assertThat((Object)projectedP2.getField("x")).as("Should not project x", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedP2.getField("y")).as("Should not project y", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projectedP2.getField("z")).as("Should project null z", new Object[0])).isNull();
    }

    @Test
    public void testAddedFieldsWithRequiredChildren() throws Exception {
        Schema schema = new Schema(new Types.NestedField[]{Types.NestedField.required((int)1, (String)"a", (Type)Types.LongType.get())});
        GenericRecord record = GenericRecord.create((Types.StructType)schema.asStruct());
        record.setField("a", (Object)100L);
        Schema addedFields = new Schema(new Types.NestedField[]{Types.NestedField.optional((int)1, (String)"a", (Type)Types.LongType.get()), Types.NestedField.optional((int)2, (String)"b", (Type)Types.StructType.of((Types.NestedField[])new Types.NestedField[]{Types.NestedField.required((int)3, (String)"c", (Type)Types.LongType.get())})), Types.NestedField.optional((int)4, (String)"d", (Type)Types.ListType.ofRequired((int)5, (Type)Types.LongType.get())), Types.NestedField.optional((int)6, (String)"e", (Type)Types.MapType.ofRequired((int)7, (int)8, (Type)Types.LongType.get(), (Type)Types.LongType.get()))});
        Record projected = this.writeAndRead("add_fields_with_required_children_projection", schema, addedFields, (Record)record);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.get(0))).as("Should contain the correct value in column 1", new Object[0])).isEqualTo(100L);
        ((AbstractLongAssert)Assertions.assertThat((long)((Long)projected.getField("a"))).as("Should contain the correct value in column a", new Object[0])).isEqualTo(100L);
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(1)).as("Should contain empty value in new column 2", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("b")).as("Should contain empty value in column b", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(2)).as("Should contain empty value in new column 4", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("d")).as("Should contain empty value in column d", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.get(3)).as("Should contain empty value in new column 6", new Object[0])).isNull();
        ((ObjectAssert)Assertions.assertThat((Object)projected.getField("e")).as("Should contain empty value in column e", new Object[0])).isNull();
    }
}

