/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iceberg.data.avro;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.iceberg.Files;
import org.apache.iceberg.Schema;
import org.apache.iceberg.avro.Avro;
import org.apache.iceberg.avro.AvroIterable;
import org.apache.iceberg.data.DataTest;
import org.apache.iceberg.data.DataTestHelpers;
import org.apache.iceberg.data.RandomGenericData;
import org.apache.iceberg.data.Record;
import org.apache.iceberg.data.avro.DataWriter;
import org.apache.iceberg.data.avro.PlannedDataReader;
import org.apache.iceberg.io.FileAppender;
import org.apache.iceberg.io.InputFile;
import org.apache.iceberg.io.OutputFile;
import org.apache.iceberg.relocated.com.google.common.collect.Lists;
import org.assertj.core.api.Assertions;

public class TestGenericData
extends DataTest {
    @Override
    protected void writeAndValidate(Schema schema) throws IOException {
        this.writeAndValidate(schema, schema);
    }

    @Override
    protected void writeAndValidate(Schema writeSchema, List<Record> expectedData) throws IOException {
        this.writeAndValidate(writeSchema, writeSchema, expectedData);
    }

    @Override
    protected void writeAndValidate(Schema writeSchema, Schema expectedSchema) throws IOException {
        List<Record> data = RandomGenericData.generate(writeSchema, 100, 0L);
        this.writeAndValidate(writeSchema, expectedSchema, data);
    }

    private void writeAndValidate(Schema writeSchema, Schema expectedSchema, List<Record> expected) throws IOException {
        ArrayList rows;
        File testFile = File.createTempFile("junit", null, this.temp.toFile());
        Assertions.assertThat((boolean)testFile.delete()).isTrue();
        try (FileAppender writer = Avro.write((OutputFile)Files.localOutput((File)testFile)).schema(writeSchema).createWriterFunc(DataWriter::create).named("test").build();){
            for (Record rec : expected) {
                writer.add((Object)rec);
            }
        }
        try (AvroIterable reader = Avro.read((InputFile)Files.localInput((File)testFile)).project(expectedSchema).createResolvingReader(PlannedDataReader::create).build();){
            rows = Lists.newArrayList((Iterable)reader);
        }
        for (int i = 0; i < expected.size(); ++i) {
            DataTestHelpers.assertEquals(expectedSchema.asStruct(), expected.get(i), (Record)rows.get(i));
        }
    }

    @Override
    protected boolean supportsDefaultValues() {
        return true;
    }
}

